local assets=
{
    Asset("ANIM", "anim/berriesm.zip"),						-- Animation Zip
    Asset("ATLAS", "images/inventoryimages/berriesm.xml"),	-- Atlas for inventory TEX
    Asset("IMAGE", "images/inventoryimages/berriesm.tex"),	-- TEX for inventory
}


local function fn(Sim)
	-- Create a new entity
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	-- Set animation info
	inst.AnimState:SetBank("berries")
	inst.AnimState:SetBuild("berriesm")
	inst.AnimState:PlayAnimation("idle")
	
	-- Make it edible
	inst:AddComponent("edible")
	inst.components.edible.healthvalue =  20	-- Amount to heal
	inst.components.edible.hungervalue =  0	-- Amount to fill belly
	inst.components.edible.sanityvalue = -50
	
	
	-- Make it perishable
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
	-- Make it stackable
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	-- Make it inspectable
	inst:AddComponent("inspectable")
	
	--inst:AddComponent("tradable")
	
	-- Make it an inventory item
	inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "berriesm"	-- Use our TEX sprite
    inst.components.inventoryitem.atlasname = "images/inventoryimages/berriesm.xml"	-- here's the atlas for our tex
	
	
	return inst
end

STRINGS.NAMES.BERRIESM = "Black Berry"

-- Randomizes the inspection line upon inspection.
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BERRIESM = {	
	"Quick way to unite me and nightmare world.",

}

--AddIngredientValues({"cactus_cooked"}, {fruit=1}, true)

-- Return our prefab
return Prefab( "common/inventory/berriesm", fn, assets)