local assets=
{
	Asset("ANIM", "anim/berrybushm.zip"),
	Asset("ATLAS", "images/inventoryimages/berrybushm_map.xml"),
    Asset("IMAGE", "images/inventoryimages/berrybushm_map.tex"),
	Asset("SOUND", "sound/common.fsb"),
}


local prefabs =
{
    "cactus_picked",
}  

local function getstatus(inst)
	
	if inst.components.pickable and not inst.components.pickable:CanBePicked() then
		STRINGS.CHARACTERS.GENERIC.DESCRIBE.BERRYBUSHM = {	
		"I must wait a while.",

		}
	elseif inst.components.burnable and inst.components.burnable:IsBurning() then
		STRINGS.CHARACTERS.GENERIC.DESCRIBE.BERRYBUSHM = {	
		"Element caught it.",
		}
	else
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.BERRYBUSHM = {	
		"Time to harvest.",
		}
	
	end
end  

local function onregenfn(inst)
	inst.AnimState:PushAnimation("idle", true)
end

local function makefullfn(inst)
	inst.AnimState:PlayAnimation("idle", true)
	
end



local function onpickedfn(inst, picker)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/pickup_reeds") 

	inst.AnimState:PlayAnimation("berries_picked")
	
	if picker.components.combat then
        picker.components.combat:GetAttacked(inst, TUNING.MARSHBUSH_DAMAGE)
        picker:PushEvent("thorns")
	end
	
end

local function makeemptyfn(inst)
	inst.AnimState:PlayAnimation("empty", true)
	
end


	local function fn(Sim)
		local inst = CreateEntity()
		local trans = inst.entity:AddTransform()
		local anim = inst.entity:AddAnimState()
	    local sound = inst.entity:AddSoundEmitter()
		
		local minimap = inst.entity:AddMiniMapEntity()
		minimap:SetIcon( "berrybushm_map.tex" )
	    
	    anim:SetBank("berrybush")
	    anim:SetBuild("berrybushm")
	    anim:PlayAnimation("idle",true)
	    anim:SetTime(math.random()*2)

		inst:AddComponent("pickable")
		inst.components.pickable.picksound = "dontstarve/wilson/pickup_reeds"
		inst.components.pickable:SetUp("berriesm", TUNING.MARSHBUSH_REGROW_TIME)
		inst.components.pickable.onregenfn = onregenfn
		inst.components.pickable.onpickedfn = onpickedfn
		inst.components.pickable.makeemptyfn = makeemptyfn
		inst.components.pickable.makefullfn = makefullfn

	    --if stage == 1 then
			--inst.components.pickable:MakeBarren()
		--end
		
		inst:AddComponent("lootdropper")
		
	    inst:AddComponent("inspectable")
		inst.components.inspectable.getstatus = getstatus		
	    
	    ---------------------        

	    MakeMediumBurnable(inst)
	    MakeSmallPropagator(inst)
	--	MakeNoGrowInWinter(inst)    
	    ---------------------   
	    
	    return inst
	end   

STRINGS.NAMES.BERRYBUSHM = "ʹľ"

return Prefab( "common/berrybushm", fn, assets, prefabs)