
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "ANIM", "anim/beard.zip" ),
		Asset( "SOUND", "sound/sfx.fsb" ),
		Asset( "SOUND", "sound/wilson.fsb" ),

		Asset("ANIM", "anim/mastema.zip"),
		Asset("ANIM", "anim/mastemagol.zip"),		
		

		
}
local prefabs = {}

local start_inv = 
{
"nightmarestaff",
"thulecite",
"thulecite",
"thulecite",
"thulecite",
"itag",
}


local intro_equipment = {



	"itag",


}

local function insanitycontrol(inst, data)

	if inst.state == "normal" then
		inst.AnimState:SetBuild("mastema")
		inst.MiniMapEntity:SetIcon("mastema.tex")
		inst.components.health.absorb = (0)
		if inst.components.sanity.current <= 150 then
			inst.state = "power"
			local fx = SpawnPrefab("statue_transition_2")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,2,1)
			end

			fx = SpawnPrefab("statue_transition")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,1.5,1)
			end
		elseif inst.components.sanity.current <= 60 then	
			inst.state = "demon"
		end
			
		
	elseif inst.state == "power" then
		inst.AnimState:SetBuild("mastemagol")
		inst.MiniMapEntity:SetIcon("mastemagol.tex")
		inst.components.health.absorb = (0.9)
			if inst.components.sanity.current > 150 then
				inst.state = "normal"
				
				local fx = SpawnPrefab("statue_transition_2")
				if fx then
					fx.Transform:SetPosition(inst:GetPosition():Get())
					fx.AnimState:SetScale(1,2,1)
				end

				fx = SpawnPrefab("statue_transition")
				if fx then
					fx.Transform:SetPosition(inst:GetPosition():Get())
					fx.AnimState:SetScale(1,1.5,1)
				end
				
			elseif inst.components.sanity.current <= 60 then
				inst.state = "demon"
				
				local fx = SpawnPrefab("statue_transition_2")
				if fx then
					fx.Transform:SetPosition(inst:GetPosition():Get())
					fx.AnimState:SetScale(1,2,1)
				end

				fx = SpawnPrefab("statue_transition")
				if fx then
					fx.Transform:SetPosition(inst:GetPosition():Get())
					fx.AnimState:SetScale(1,1.5,1)
				end
				
			end
			
	elseif inst.state == "demon" then
		inst.AnimState:SetBuild("mastema")
		inst.MiniMapEntity:SetIcon("mastema.tex")
		inst.components.health.absorb = (0)
			if inst.components.sanity.current > 60 then
				inst.state = "power"
				
				local fx = SpawnPrefab("statue_transition_2")
				if fx then
					fx.Transform:SetPosition(inst:GetPosition():Get())
					fx.AnimState:SetScale(1,2,1)
				end

				fx = SpawnPrefab("statue_transition")
				if fx then
					fx.Transform:SetPosition(inst:GetPosition():Get())
					fx.AnimState:SetScale(1,1.5,1)
				end
			
			elseif inst.components.sanity.current > 150 then	
			inst.state = "normal"
			
			end
				
	end
	
	

	
end
		
local function introcontrol(inst, data)
if inst.components.inventory:Has("itag", 1) then
		local item = data.item
		if table.contains( intro_equipment, item.prefab ) then
		inst.components.talker:ShutUp()
		inst.AnimState:SetBuild("empty")
        inst.components.health:SetInvincible(true)
		inst.HUD:Hide()
		inst.components.playercontroller:Enable(false)
		inst.components.locomotor:StopMoving()
		
		inst:DoTaskInTime(1.5, function()
		
		local player_pos = GetPlayer():GetPosition()
		local lightning = SpawnPrefab("lightning")
		lightning.Transform:SetPosition(player_pos.x, player_pos.y, player_pos.z)
		
		--GetSeasonManager():DoLightningStrike(GetPlayer():GetPosition())
		GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 1.4, 0.03, .7, 40)
		
		local fx = SpawnPrefab("statue_transition_2")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,2,1)
			end

			fx = SpawnPrefab("statue_transition")
			if fx then
				fx.Transform:SetPosition(inst:GetPosition():Get())
				fx.AnimState:SetScale(1,1.5,1)
			end
		
		inst.AnimState:SetBuild("mastema")
		end)
		
		inst:DoTaskInTime(2.5, function()
	    inst.components.talker:Say("罫ҵ!")
		end)
		
			inst:DoTaskInTime(5.5, function()
				inst.components.playercontroller:Enable(true)
				inst.components.health:SetInvincible(false)
				inst.HUD:Show()
				inst.components.inventory:RemoveItem(item)
			end)
		end
end
end


local disallowed_equipment = {
    --Don't Starve prefabs
	"armor_sanity",
	"armorgrass",
	"armorruins",
	"armorwood",
	"armormarble",
	"footballhat",
	"armordragonfly",
	"armorsnurtleshell",
	"slurtlehat",
	"ruinshat",
	
	--T.A.P prefabs
	"bonearmor",
	"bonehelm",
	"spiderhelm",
	"queenhelm",
	"metalarmor",
	"forcefieldn",
	
	--Madman fighting Pack prefabs
	"goldarmor",
	"goldhelm",
	
	--emeralds
	"emerald_armor",
	"emerald_crown",
	
	--steam punk
	 "gear_helmet",

}

local function NoArmor ( inst, data )
    local item = data.item
    if table.contains( disallowed_equipment, item.prefab ) then
		if item.prefab == "armorruins"then
		inst.components.talker:Say("սʿϮ׼, ҽκζ.")
		elseif item.prefab == "ruinshat"then
		inst.components.talker:Say("ûȨ..Ȼ.")
		else
		inst.components.talker:Say("ֹĶ.")
		end
        inst:DoTaskInTime(0.5, function()
			GetPlayer().components.inventory:DropItem(item)
		end) 
    end
end
	
local function OnSave(inst, data) --saving data

			
			data.state = inst.state
			

			
end

     
local function OnLoad(inst, data)
			
    if data.state == "normal"  then
                                    
        inst.state = "normal"
                              
    elseif data.state == "power" then
                                    
		inst.state = "power"
	
	elseif data.state == "demon" then
                                    
		inst.state = "demon"
                              
	end
	
	
end



local fn = function(inst)
	


	-- a minimap icon must be specified
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("mastema.tex")
	
	inst.components.builder.ancient_bonus = 4
	
	inst.components.health:SetMaxHealth(160)
	inst.components.hunger:SetMax(120)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
	inst.components.sanity:SetMax(220)
	inst.components.combat.damagemultiplier = 1.05
	inst.components.sanity.night_drain_mult = 0.7
	inst.components.sanity.neg_aura_mult = 0.7
	

	inst.soundsname = "mastema"
	
	inst.state = "normal"
	
	
	
	inst:ListenForEvent("sanitydelta", insanitycontrol)
	inst:ListenForEvent("itemget", introcontrol)
	inst:ListenForEvent( "equip", NoArmor)
	
	inst.OnSave=OnSave
	inst.OnLoad=OnLoad
	
end


return MakePlayerCharacter("mastema", prefabs, assets, fn, start_inv)
