local assets=
{
	Asset("ANIM", "anim/blow_dartm.zip"),
	--Asset("ANIM", "anim/swap_blowdart.zip"),
	Asset("ANIM", "anim/swap_blowdart_pipem.zip"),
	Asset("ATLAS", "images/inventoryimages/thuledart.xml"),
    Asset("IMAGE", "images/inventoryimages/thuledart.tex"),	
	
	
}

local prefabs = 
{
    "impact",
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_blowdart_pipem", "swap_blowdart_pipe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_object")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onhit(inst, attacker, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx and attacker then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(attacker.Transform:GetWorldPosition())
    end
    inst:Remove()
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
end


local function common()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("blow_dart")
    anim:SetBuild("blow_dartm")
    
    inst:AddTag("blowdart")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(120)
    inst.components.weapon:SetRange(9, 11)
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(60)
    inst.components.projectile:SetOnHitFn(onhit)
    inst:ListenForEvent("onthrown", onthrown)
    -------
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "thuledart"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/thuledart.xml"	
    
    inst:AddComponent("stackable")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.equipstack = true
    
    return inst
end

local function thulethrown(inst)
    inst.AnimState:PlayAnimation("dart_pipe")
end

local function thule()
    local inst = common()

    inst.AnimState:PlayAnimation("idle_pipe")

   -- inst.components.weapon:SetDamage(TUNING.PIPE_DART_DAMAGE)
    inst.components.projectile:SetOnThrownFn(thulethrown)
    
    return inst
end

STRINGS.NAMES.THULEDART = "󴵼"
STRINGS.RECIPE_DESC.THULEDART = "ܵı."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.THULEDART = {	
	"Ϯ.",
	 
}

return Prefab( "common/inventory/thuledart", thule, assets, prefabs) 
