/*
 * Decompiled with CFR 0.152.
 */
package data.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lazywizard.lazylib.MathUtils;

public class BaseRandomSRAMissionDefinition
implements MissionDefinitionPlugin {
    public static final Comparator<FleetMemberAPI> PRIORITY = new Comparator<FleetMemberAPI>(){

        @Override
        public int compare(FleetMemberAPI member1, FleetMemberAPI member2) {
            if (member1.isFlagship()) {
                if (!member2.isFlagship()) {
                    return -1;
                }
            } else if (member2.isFlagship()) {
                return 1;
            }
            if (!member1.isCivilian()) {
                if (member2.isCivilian()) {
                    return -1;
                }
            } else if (!member2.isCivilian()) {
                return 1;
            }
            if (!member1.isFighterWing()) {
                if (member2.isFighterWing()) {
                    return -1;
                }
            } else if (!member2.isFighterWing()) {
                return 1;
            }
            if (member1.getFleetPointCost() > member2.getFleetPointCost()) {
                return -1;
            }
            if (member1.getFleetPointCost() < member2.getFleetPointCost()) {
                return 1;
            }
            if (member1.getCaptain() != null) {
                if (member2.getCaptain() == null) {
                    return -1;
                }
            } else if (member2.getCaptain() != null) {
                return 1;
            }
            if (!member1.isFrigate()) {
                if (member2.isFrigate()) {
                    return -1;
                }
            } else if (!member2.isFrigate()) {
                return 1;
            }
            if (!member1.isDestroyer()) {
                if (member2.isDestroyer()) {
                    return -1;
                }
            } else if (!member2.isDestroyer()) {
                return 1;
            }
            if (!member1.isCruiser()) {
                if (member2.isCruiser()) {
                    return -1;
                }
            } else if (!member2.isCruiser()) {
                return 1;
            }
            if (!member1.isCapital()) {
                if (member2.isCapital()) {
                    return -1;
                }
            } else if (!member2.isCapital()) {
                return 1;
            }
            return member1.getSpecId().compareTo(member2.getSpecId());
        }
    };
    private static final String[] OBJECTIVE_TYPES = new String[]{"sensor_array", "nav_buoy", "comm_relay"};
    private static final Map<String, Float> QUALITY_FACTORS = new HashMap<String, Float>(11);
    private FactionAPI enemy;
    private boolean flagshipChosen = false;
    private FactionAPI player;
    private final Random rand = new Random();

    public void defineMission(MissionDefinitionAPI api) {
        if (this.player == null || this.enemy == null) {
            this.chooseFactions(null, null);
        }
        api.initFleet(FleetSide.PLAYER, "", FleetGoal.ATTACK, false, 5);
        api.initFleet(FleetSide.ENEMY, "", FleetGoal.ATTACK, true, 5);
        api.setFleetTagline(FleetSide.PLAYER, this.player.getDisplayNameLong() + " \u8230\u961f");
        api.setFleetTagline(FleetSide.ENEMY, this.enemy.getDisplayNameLong() + " \u8230\u961f");
        int size = 5 + (int)((float)Math.random() * 45.0f);
        float difficulty = 0.7f + this.rand.nextFloat() * 0.3f;
        int playerFP = this.generateFleet(this.player, api, FleetSide.PLAYER, (int)((float)size * difficulty), QUALITY_FACTORS.get(this.player.getId()).floatValue());
        int enemyFP = this.generateFleet(this.enemy, api, FleetSide.ENEMY, size, QUALITY_FACTORS.get(this.enemy.getId()).floatValue());
        float width = 13000.0f + 13000.0f * (float)(size / 40);
        float height = 13000.0f + 13000.0f * (float)(size / 40);
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        float minX = -width / 2.0f;
        float minY = -height / 2.0f;
        int objectiveCount = (int)Math.floor((float)size / 8.0f);
        while (objectiveCount > 0) {
            String type = OBJECTIVE_TYPES[this.rand.nextInt(3)];
            if (objectiveCount == 1) {
                api.addObjective(0.0f, 0.0f, type);
                --objectiveCount;
                continue;
            }
            float theta = (float)(Math.random() * Math.PI);
            double radius = Math.min(width, height);
            radius = radius * 0.1 + radius * 0.3 * Math.random();
            int x = (int)(Math.cos(theta) * radius);
            int y = (int)(Math.sin(theta) * radius);
            api.addObjective((float)x, (float)(-y), type);
            api.addObjective((float)(-x), (float)y, type);
            objectiveCount -= 2;
        }
        if (Math.random() < 0.5 && (this.player.getId().contentEquals("shadow_industry") || this.enemy.getId().contentEquals("shadow_industry"))) {
            String[] planets = new String[]{"planet_euripides"};
            String planet = planets[(int)(Math.random() * (double)planets.length)];
            float radius = 300.0f;
            api.addPlanet(0.0f, 0.0f, radius, planet, 200.0f, true);
        }
        api.addBriefingItem(this.player.getDisplayName() + "  (" + playerFP + ")   vs.  " + this.enemy.getDisplayName() + "  (" + enemyFP + ")");
        float nebulaChance = MathUtils.getRandomNumberInRange((int)0, (int)100);
        if (nebulaChance < 50.0f) {
            float nebulaCount = 10.0f + (float)Math.random() * 30.0f;
            float nebulaSize = (float)Math.random();
            int i = 0;
            while ((float)i < nebulaCount) {
                float x = (float)Math.random() * width - width / 2.0f;
                float y = (float)Math.random() * height - height / 2.0f;
                float nebulaRadius = (400.0f + (float)Math.random() * 1600.0f) * nebulaSize;
                api.addNebula(x, y, nebulaRadius);
                ++i;
            }
            api.addBriefingItem("\u661f\u4e91\u5bc6\u5ea6:  " + (int)(nebulaCount * nebulaSize / 40.0f * 100.0f) + "%");
        } else {
            api.addBriefingItem("\u661f\u4e91\u5bc6\u5ea6: \u65e0");
        }
        float asteroidChance = MathUtils.getRandomNumberInRange((int)0, (int)100);
        if (asteroidChance < 50.0f) {
            int minAsteroidSpeed = MathUtils.getRandomNumberInRange((int)15, (int)50);
            int asteroidCount = 5 * size + (int)((double)(size * 20) * Math.pow(Math.random(), 2.0));
            api.addAsteroidField(minX + width * 0.5f, minY + height * 0.5f, (float)(this.rand.nextInt(90) - 45 + this.rand.nextInt() % 2 * 180), width * 0.25f + (float)Math.random() * height / 2.0f, (float)minAsteroidSpeed, (float)minAsteroidSpeed * 1.1f, asteroidCount);
            api.addBriefingItem("\u5c0f\u884c\u661f\u5bc6\u5ea6:  " + (int)((float)asteroidCount / 1000.0f * 100.0f) + "%");
            api.addBriefingItem("\u5c0f\u884c\u661f\u79fb\u52a8\u901f\u5ea6:  " + minAsteroidSpeed);
        } else {
            api.addBriefingItem("\u5c0f\u884c\u661f\u5bc6\u5ea6: \u65e0");
            api.addBriefingItem("\u5c0f\u884c\u661f\u79fb\u52a8\u901f\u5ea6: \u65e0");
        }
    }

    protected void chooseFactions(String playerFactionId, String enemyFactionId) {
        this.player = Global.getSector().getFaction(playerFactionId);
        this.enemy = Global.getSector().getFaction(enemyFactionId);
        ArrayList<FactionAPI> acceptableFactions = new ArrayList<FactionAPI>(11);
        acceptableFactions.add(Global.getSector().getFaction("sindrian_diktat"));
        acceptableFactions.add(Global.getSector().getFaction("hegemony"));
        acceptableFactions.add(Global.getSector().getFaction("independent"));
        acceptableFactions.add(Global.getSector().getFaction("lions_guard"));
        acceptableFactions.add(Global.getSector().getFaction("luddic_church"));
        acceptableFactions.add(Global.getSector().getFaction("luddic_path"));
        acceptableFactions.add(Global.getSector().getFaction("pirates"));
        acceptableFactions.add(Global.getSector().getFaction("tritachyon"));
        this.player = this.player != null ? this.player : (FactionAPI)acceptableFactions.get(this.rand.nextInt(acceptableFactions.size()));
        acceptableFactions.remove(this.player);
        this.enemy = this.enemy != null ? this.enemy : (FactionAPI)acceptableFactions.get(this.rand.nextInt(acceptableFactions.size()));
    }

    int generateFleet(FactionAPI faction, MissionDefinitionAPI api, FleetSide side, int minFP, float qf) {
        MarketAPI market = Global.getFactory().createMarket(String.valueOf(new Random().nextLong()), String.valueOf(new Random().nextLong()), 4);
        market.setFactionId(faction.getId());
        market.setBaseSmugglingStabilityValue(0);
        CampaignFleetAPI fleet = FleetFactoryV2.createFleet((FleetParams)new FleetParams(null, market, market.getFactionId(), null, "patrolLarge", (float)minFP, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, qf, 1.0f, 0));
        List fleetList = fleet.getFleetData().getMembersListCopy();
        Collections.sort(fleetList, PRIORITY);
        for (FleetMemberAPI m : fleetList) {
            String variant = m.isFighterWing() ? m.getSpecId() : m.getVariant().getHullVariantId();
            api.addToFleet(side, variant, m.getType(), m.getShipName(), !m.isFighterWing() && !this.flagshipChosen);
            if (m.isFighterWing() || this.flagshipChosen) continue;
            this.flagshipChosen = true;
        }
        return fleet.getFleetPoints();
    }

    static {
        QUALITY_FACTORS.put("shadow_industry", Float.valueOf(0.85f));
        QUALITY_FACTORS.put("sindrian_diktat", Float.valueOf(0.5f));
        QUALITY_FACTORS.put("hegemony", Float.valueOf(0.5f));
        QUALITY_FACTORS.put("independent", Float.valueOf(0.5f));
        QUALITY_FACTORS.put("lions_guard", Float.valueOf(0.75f));
        QUALITY_FACTORS.put("luddic_church", Float.valueOf(0.25f));
        QUALITY_FACTORS.put("luddic_path", Float.valueOf(0.0f));
        QUALITY_FACTORS.put("pirates", Float.valueOf(0.0f));
        QUALITY_FACTORS.put("tritachyon", Float.valueOf(0.85f));
    }
}

