/*
 * Decompiled with CFR 0.152.
 */
package data.missions.stampede;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class EndlessRespawn
extends BaseEveryFrameCombatPlugin {
    private static CombatEngineAPI engine;
    private float mapX = 0.0f;
    private float mapY = 0.0f;
    private int countingCows = 0;
    private boolean combatOver = false;
    private static final int MAX_RESPAWN = 300;
    private static final int MAX_BUFFALO = 30;

    public void advance(float amount, List<InputEventAPI> events) {
        if (engine != Global.getCombatEngine()) {
            engine = Global.getCombatEngine();
            this.mapX = engine.getMapWidth();
            this.mapY = engine.getMapHeight();
            return;
        }
        if (engine.isPaused()) {
            return;
        }
        if (Global.getSector().getPlayerFleet() != null) {
            return;
        }
        if (!this.combatOver) {
            if (this.countingCows >= 300) {
                this.combatOver = true;
                CombatFleetManagerAPI eManager = engine.getFleetManager(FleetSide.ENEMY);
                eManager.getTaskManager(this.combatOver).orderFullRetreat();
                return;
            }
            engine.setDoNotEndCombat(true);
            List ships = engine.getShips();
            for (ShipAPI ship : ships) {
                CombatFleetManagerAPI eManager;
                if (ship == null) continue;
                if (ship.isAlive() && ship.getOriginalOwner() == 1 && !ship.isShuttlePod() && !ship.isWingLeader() && !ship.isDrone() && (eManager = engine.getFleetManager(FleetSide.ENEMY)).getTaskManager(this.combatOver).getAssignmentFor(ship) != null && eManager.getTaskManager(this.combatOver).getAssignmentFor(ship).getType() == CombatAssignmentType.RETREAT) {
                    eManager.getTaskManager(this.combatOver).orderSearchAndDestroy(eManager.getDeployedFleetMember(ship), false);
                }
                if (!ship.isHulk() || ship.isFighter() || ship.getOriginalOwner() != 1) continue;
                if (ships.size() < 30) {
                    int owner = ship.getOriginalOwner();
                    Vector2f safeSpawnLoc = this.getSafeSpawn(owner);
                    Vector2f safeSpawnLoc2 = this.getSafeSpawn(owner);
                    String variantID = ship.getVariant().getHullVariantId();
                    ShipAPI randShip = (ShipAPI)engine.getShips().get(0);
                    if (owner == 1) {
                        ++this.countingCows;
                        engine.addFloatingText(engine.getPlayerShip().getLocation(), "You have killed " + this.countingCows + " Buffalo!", 30.0f, Color.yellow, (CombatEntityAPI)engine.getPlayerShip(), 1.0f, 2.0f);
                        ShipAPI spawned = engine.getFleetManager(FleetSide.ENEMY).spawnShipOrWing(variantID, safeSpawnLoc, 270.0f, 3.0f);
                        ShipAPI spawned2 = engine.getFleetManager(FleetSide.ENEMY).spawnShipOrWing(variantID, safeSpawnLoc2, 270.0f, 3.0f);
                        spawned.setCurrentCR(ship.getCurrentCR());
                        spawned2.setCurrentCR(ship.getCurrentCR());
                        engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(spawned).getMember().getCaptain().setPersonality("aggressive");
                        engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(spawned2).getMember().getCaptain().setPersonality("aggressive");
                        spawned.getShipAI().forceCircumstanceEvaluation();
                        spawned2.getShipAI().forceCircumstanceEvaluation();
                    }
                    engine.applyDamage((CombatEntityAPI)ship, ship.getLocation(), 1000000.0f, DamageType.ENERGY, 0.0f, true, true, (Object)randShip);
                    continue;
                }
                ShipAPI randShip = (ShipAPI)engine.getShips().get(0);
                engine.applyDamage((CombatEntityAPI)ship, ship.getLocation(), 1000000.0f, DamageType.ENERGY, 0.0f, true, true, (Object)randShip);
            }
        }
    }

    public void init(CombatEngineAPI engine) {
    }

    private Vector2f getSafeSpawn(int side) {
        Vector2f spawnLocation = new Vector2f();
        spawnLocation.x = MathUtils.getRandomNumberInRange((float)(-this.mapX / 2.0f), (float)(this.mapX / 2.0f));
        spawnLocation.y = side == 100 || side == 0 ? -this.mapY / 2.0f : this.mapY / 2.0f;
        return spawnLocation;
    }
}

