/*
 * Decompiled with CFR 0.152.
 */
package data.scripts;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.ai.MS_Barrago_S2_AI;
import data.scripts.ai.MS_BlackcapAI;
import data.scripts.ai.MS_SimpleMissileAI;
import data.scripts.ai.WindingMissileAI;
import data.scripts.ai.WindingRocketAI;
import data.scripts.hullmods.TEM_LatticeShield;
import data.scripts.world.SHIGen;
import exerelin.campaign.SectorManager;
import org.dark.shaders.light.LightData;
import org.dark.shaders.util.ShaderLib;
import org.dark.shaders.util.TextureData;

public class ShadowyardsModPlugin
extends BaseModPlugin {
    public static final String SIDEWINDER_MISSILE = "ms_tusk_bomblet";
    public static final String SIDEWINDER_ROCKET = "ms_splinter_rocket";
    public static final String SIMPLE_SHRIKE = "ms_shrike";
    public static final String BARRAGO_LRM_S2 = "ma_barrago_lrm_s2";
    public static final String BLACKCAP_AFM = "ms_blackcap";
    public static boolean hasTwigLib;
    public static boolean isExerelin;
    public static boolean hasShaderLib;
    public static boolean templarsExist;

    public void onApplicationLoad() {
        isExerelin = Global.getSettings().getModManager().isModEnabled("nexerelin");
        hasTwigLib = Global.getSettings().getModManager().isModEnabled("ztwiglib");
        hasShaderLib = Global.getSettings().getModManager().isModEnabled("shaderLib");
        templarsExist = Global.getSettings().getModManager().isModEnabled("Templars");
        try {
            if (hasShaderLib) {
                ShaderLib.init();
                if (ShaderLib.areShadersAllowed() && ShaderLib.areBuffersAllowed()) {
                    LightData.readLightDataCSV((String)"data/lights/ms_light_data.csv");
                    TextureData.readTextureDataCSV((String)"data/lights/ms_texture_data.csv");
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            if (TEM_LatticeShield.AEGIS_SHIELD_COLOR != null) {
                templarsExist = true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void onNewGame() {
        if (isExerelin && !SectorManager.getCorvusMode()) {
            return;
        }
        ShadowyardsModPlugin.initShadowyards();
    }

    public PluginPick<MissileAIPlugin> pickMissileAI(MissileAPI missile, ShipAPI launchingShip) {
        switch (missile.getProjectileSpecId()) {
            case "ms_tusk_bomblet": {
                return new PluginPick((Object)new WindingMissileAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SET);
            }
            case "ms_splinter_rocket": {
                return new PluginPick((Object)new WindingRocketAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SET);
            }
            case "ms_shrike": {
                return new PluginPick((Object)new MS_SimpleMissileAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SET);
            }
            case "ma_barrago_lrm_s2": {
                return new PluginPick((Object)new MS_Barrago_S2_AI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SET);
            }
            case "ms_blackcap": {
                return new PluginPick((Object)new MS_BlackcapAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SET);
            }
        }
        return null;
    }

    private static void initShadowyards() {
        new SHIGen().generate(Global.getSector());
    }

    static {
        templarsExist = false;
    }
}

