/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_Barrago_S2_AI
implements MissileAIPlugin,
GuidedMissileAI {
    private static final float MIRV_DISTANCE = 400.0f;
    private static final float MIRV_SPEED = 150.0f;
    private static final float VELOCITY_DAMPING_FACTOR = 0.15f;
    private static final Vector2f ZERO = new Vector2f();
    private static final String MIRV_ID = "ms_barrago_lrm_shatter";
    private static final String SOUND_ID = "flak_fire";
    private final MissileAPI missile;
    private float nearestHorizonAngle = 180.0f;
    private CombatEntityAPI target;
    private float timeLive = 0.0f;

    public MS_Barrago_S2_AI(MissileAPI missile, ShipAPI launchingShip) {
        List directTargets;
        this.missile = missile;
        if (launchingShip.getShipTarget() != null && !launchingShip.getShipTarget().isHulk()) {
            this.setTarget((CombatEntityAPI)launchingShip.getShipTarget());
        }
        if (this.target == null && !(directTargets = CombatUtils.getShipsWithinRange((Vector2f)launchingShip.getMouseTarget(), (float)200.0f)).isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(launchingShip.getMouseTarget()));
            int size = directTargets.size();
            for (int i = 0; i < size; ++i) {
                ShipAPI tmp = (ShipAPI)directTargets.get(i);
                if (tmp.isHulk() || tmp.getOwner() == launchingShip.getOwner() || tmp.isDrone() || tmp.isFighter()) continue;
                this.setTarget((CombatEntityAPI)tmp);
                break;
            }
        }
        if (this.target == null) {
            this.setTarget((CombatEntityAPI)MS_Barrago_S2_AI.findBestTarget(missile));
        }
    }

    public void advance(float amount) {
        Vector2f guidedTarget;
        if (this.missile.isFizzling() || this.missile.isFading()) {
            Vector2f mirvTarget;
            if (this.target == null) {
                return;
            }
            float distance = MathUtils.getDistance((Vector2f)this.target.getLocation(), (Vector2f)this.missile.getLocation());
            float guidance = 0.45f;
            float mirvSpeed = 150.0f;
            if (this.missile.getSource() != null) {
                guidance += Math.min(this.missile.getSource().getMutableStats().getMissileGuidance().getModifiedValue() - this.missile.getSource().getMutableStats().getMissileGuidance().getBaseValue(), 1.0f) * 0.3f;
                mirvSpeed *= this.missile.getSource().getMutableStats().getProjectileSpeedMult().getModifiedValue();
            }
            if ((mirvTarget = MS_Barrago_S2_AI.intercept(this.missile.getLocation(), mirvSpeed, this.target.getLocation(), Vector2f.sub((Vector2f)this.target.getVelocity(), (Vector2f)this.missile.getVelocity(), null))) == null) {
                Vector2f projection = new Vector2f((ReadableVector2f)this.target.getVelocity());
                float scalar = distance / mirvSpeed;
                projection.scale(scalar);
                Vector2f.add((Vector2f)this.target.getLocation(), (Vector2f)projection, (Vector2f)mirvTarget);
            }
            if (mirvTarget != null) {
                Vector2f.sub((Vector2f)mirvTarget, (Vector2f)this.target.getLocation(), (Vector2f)mirvTarget);
                mirvTarget.scale(guidance * 0.3f);
                Vector2f.add((Vector2f)mirvTarget, (Vector2f)this.target.getLocation(), (Vector2f)mirvTarget);
                float angularDistance = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)mirvTarget));
                float offBy = (float)Math.sin(Math.toRadians(angularDistance)) * distance;
                if (distance <= 400.0f + this.target.getCollisionRadius() + this.missile.getCollisionRadius() && offBy <= this.target.getCollisionRadius()) {
                    MS_Barrago_S2_AI.mirv(this.missile);
                }
            }
            return;
        }
        this.timeLive += amount;
        if (this.target == null || this.target instanceof ShipAPI && ((ShipAPI)this.target).isHulk() || this.missile.getOwner() == this.target.getOwner() || !Global.getCombatEngine().isEntityInPlay(this.target)) {
            this.setTarget((CombatEntityAPI)MS_Barrago_S2_AI.findBestTarget(this.missile));
            if (this.target == null) {
                this.missile.giveCommand(ShipCommand.ACCELERATE);
                return;
            }
        }
        float distance = MathUtils.getDistance((Vector2f)this.target.getLocation(), (Vector2f)this.missile.getLocation());
        float acceleration = this.missile.getAcceleration();
        float maxSpeed = this.missile.getMaxSpeed();
        float mirvSpeed = 150.0f;
        float guidance = 0.45f;
        if (this.missile.getSource() != null) {
            mirvSpeed *= this.missile.getSource().getMutableStats().getProjectileSpeedMult().getModifiedValue();
            guidance += Math.min(this.missile.getSource().getMutableStats().getMissileGuidance().getModifiedValue() - this.missile.getSource().getMutableStats().getMissileGuidance().getBaseValue(), 1.0f) * 0.3f;
        }
        if ((guidedTarget = MS_Barrago_S2_AI.intercept(this.missile.getLocation(), this.missile.getVelocity().length(), acceleration, maxSpeed, this.target.getLocation(), Vector2f.sub((Vector2f)this.target.getVelocity(), (Vector2f)this.missile.getVelocity(), null))) == null) {
            Vector2f projection = new Vector2f((ReadableVector2f)this.target.getVelocity());
            float scalar = distance / (this.missile.getVelocity().length() + 1.0f);
            projection.scale(scalar);
            guidedTarget = Vector2f.add((Vector2f)this.target.getLocation(), (Vector2f)projection, null);
        }
        Vector2f.sub((Vector2f)guidedTarget, (Vector2f)this.target.getLocation(), (Vector2f)guidedTarget);
        guidedTarget.scale(guidance);
        Vector2f.add((Vector2f)guidedTarget, (Vector2f)this.target.getLocation(), (Vector2f)guidedTarget);
        Vector2f mirvTarget = MS_Barrago_S2_AI.intercept(this.missile.getLocation(), mirvSpeed, this.target.getLocation(), Vector2f.sub((Vector2f)this.target.getVelocity(), (Vector2f)this.missile.getVelocity(), null));
        if (mirvTarget == null) {
            Vector2f projection = new Vector2f((ReadableVector2f)this.target.getVelocity());
            float scalar = distance / mirvSpeed;
            projection.scale(scalar);
            Vector2f.add((Vector2f)this.target.getLocation(), (Vector2f)projection, (Vector2f)mirvTarget);
        }
        if (mirvTarget != null) {
            Vector2f.sub((Vector2f)mirvTarget, (Vector2f)this.target.getLocation(), (Vector2f)mirvTarget);
            mirvTarget.scale(guidance * 0.3f);
            Vector2f.add((Vector2f)mirvTarget, (Vector2f)this.target.getLocation(), (Vector2f)mirvTarget);
            float mirvAngularDistance = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)mirvTarget));
            float offBy = (float)Math.sin(Math.toRadians(mirvAngularDistance)) * distance;
            if (!this.target.getShield().isOn() && this.target.getCollisionClass() != CollisionClass.NONE && distance <= 400.0f + this.target.getCollisionRadius() + this.missile.getCollisionRadius() && offBy <= this.target.getCollisionRadius() && this.timeLive >= 1.0f || this.target.getShield().isOn() && this.target.getCollisionClass() != CollisionClass.NONE && distance <= 400.0f + this.target.getCollisionRadius() + this.missile.getCollisionRadius() && offBy <= this.target.getShield().getRadius() && this.timeLive >= 1.0f) {
                this.timeLive = -99999.0f;
                MS_Barrago_S2_AI.mirv(this.missile);
                return;
            }
        }
        float velocityFacing = VectorUtils.getFacing((Vector2f)this.missile.getVelocity());
        float absoluteDistance = MathUtils.getShortestRotation((float)velocityFacing, (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)guidedTarget));
        float angularDistance = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)guidedTarget));
        float nearestHorizonAngularDistance = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)this.nearestHorizonAngle);
        float compensationDifference = MathUtils.getShortestRotation((float)angularDistance, (float)absoluteDistance);
        if (Math.abs(compensationDifference) <= 75.0f) {
            angularDistance += 0.5f * compensationDifference;
        }
        float absDVel = Math.abs(absoluteDistance);
        float absDAng = Math.abs(angularDistance);
        this.missile.giveCommand(angularDistance < 0.0f ? ShipCommand.TURN_RIGHT : ShipCommand.TURN_LEFT);
        if (absDVel >= 135.0f || absDAng <= 90.0f || this.missile.getVelocity().length() <= maxSpeed * 0.75f) {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
        }
        if (absDAng < Math.abs(this.missile.getAngularVelocity()) * 0.15f) {
            this.missile.setAngularVelocity(angularDistance / 0.15f);
        }
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public final void setTarget(CombatEntityAPI target) {
        this.target = target;
    }

    private static ShipAPI findBestTarget(MissileAPI missile) {
        ShipAPI closest = null;
        float closestDistance = Float.MAX_VALUE;
        List ships = AIUtils.getEnemiesOnMap((CombatEntityAPI)missile);
        int size = ships.size();
        for (int i = 0; i < size; ++i) {
            float distance;
            ShipAPI tmp = (ShipAPI)ships.get(i);
            float mod = 0.0f;
            if (tmp.isFighter() || tmp.isDrone() || tmp.getCollisionClass() == CollisionClass.NONE) {
                mod = 4000.0f;
            }
            if (!((distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)missile.getLocation()) + mod) < closestDistance)) continue;
            closest = tmp;
            closestDistance = distance;
        }
        return closest;
    }

    private static Vector2f intercept(Vector2f point, float speed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - speed * speed;
        float b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        float c = difference.x * difference.x + difference.y * difference.y;
        Vector2f solutionSet = MS_Barrago_S2_AI.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    private static Vector2f intercept(Vector2f point, float speed, float acceleration, float maxspeed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float s = speed;
        float a = acceleration / 2.0f;
        float b = speed;
        float c = difference.length();
        Vector2f solutionSet = MS_Barrago_S2_AI.quad(a, b, c);
        if (solutionSet != null) {
            float t = Math.min(solutionSet.x, solutionSet.y);
            if (t < 0.0f) {
                t = Math.max(solutionSet.x, solutionSet.y);
            }
            if (t > 0.0f) {
                s = acceleration * t;
                s = s / 2.0f + speed;
                s = Math.min(s, maxspeed);
            }
        }
        a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - s * s;
        b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        c = difference.x * difference.x + difference.y * difference.y;
        solutionSet = MS_Barrago_S2_AI.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    private static void mirv(MissileAPI missile) {
        Global.getSoundPlayer().playSound(SOUND_ID, 1.0f, 1.0f, missile.getLocation(), ZERO);
        Global.getCombatEngine().applyDamage((CombatEntityAPI)missile, missile.getLocation(), missile.getHitpoints() * 100.0f, DamageType.FRAGMENTATION, 0.0f, false, false, (Object)missile);
        Vector2f location = MathUtils.getPointOnCircumference((Vector2f)missile.getLocation(), (float)5.0f, (float)missile.getFacing());
        Global.getCombatEngine().spawnProjectile(missile.getSource(), missile.getWeapon(), MIRV_ID, location, missile.getFacing(), missile.getVelocity());
    }

    private static Vector2f quad(float a, float b, float c) {
        Vector2f solution = null;
        if (Float.compare(Math.abs(a), 0.0f) == 0) {
            solution = Float.compare(Math.abs(b), 0.0f) == 0 ? (Float.compare(Math.abs(c), 0.0f) == 0 ? new Vector2f(0.0f, 0.0f) : null) : new Vector2f(-c / b, -c / b);
        } else {
            float d = b * b - 4.0f * a * c;
            if (d >= 0.0f) {
                d = (float)Math.sqrt(d);
                a = 2.0f * a;
                solution = new Vector2f((-b - d) / a, (-b + d) / a);
            }
        }
        return solution;
    }
}

