/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_BlackcapAI
implements MissileAIPlugin,
GuidedMissileAI {
    private CombatEngineAPI engine;
    private final MissileAPI missile;
    private CombatEntityAPI target;
    private Vector2f lead = new Vector2f(0.0f, 0.0f);
    private final float flightSpeed;
    private final float maxSearchRange = 1000.0f;
    private static final float damping = 0.1f;
    private IntervalUtil timer = new IntervalUtil(0.1f, 0.0f);

    public static ShipAPI findBestTarget(MissileAPI missile) {
        ShipAPI source = missile.getSource();
        if (source != null && source.getShipTarget() != null && !source.getShipTarget().isHulk()) {
            return source.getShipTarget();
        }
        return AIUtils.getNearestEnemy((CombatEntityAPI)missile);
    }

    public MS_BlackcapAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        this.flightSpeed = missile.getMaxSpeed();
        List directTargets = CombatUtils.getShipsWithinRange((Vector2f)launchingShip.getMouseTarget(), (float)100.0f);
        if (!directTargets.isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(launchingShip.getMouseTarget()));
            for (ShipAPI tmp : directTargets) {
                if (tmp.isHulk() || tmp.getOwner() == launchingShip.getOwner()) continue;
                this.setTarget((CombatEntityAPI)tmp);
                break;
            }
        }
        if (this.target == null) {
            this.setTarget((CombatEntityAPI)MS_BlackcapAI.findBestTarget(missile));
        }
    }

    public void advance(float amount) {
        if (this.missile.isFading() || this.missile.isFizzling()) {
            return;
        }
        this.timer.advance(amount);
        if (this.target == null || this.target instanceof ShipAPI && ((ShipAPI)this.target).isHulk() || this.missile.getOwner() == this.target.getOwner() || !Global.getCombatEngine().isEntityInPlay(this.target)) {
            this.setTarget((CombatEntityAPI)MS_BlackcapAI.findBestTarget(this.missile));
            return;
        }
        if (Global.getCombatEngine().isPaused() || this.missile.isFading() || this.missile.isFizzling() || this.target == null) {
            return;
        }
        this.lead = AIUtils.getBestInterceptPoint((Vector2f)this.missile.getLocation(), (float)this.flightSpeed, (Vector2f)this.target.getLocation(), (Vector2f)this.target.getVelocity());
        if (this.lead == null) {
            return;
        }
        float aimAngle = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)this.lead));
        if (Math.abs(aimAngle) > 90.0f) {
            if (aimAngle < 0.0f) {
                this.missile.giveCommand(ShipCommand.TURN_RIGHT);
            } else {
                this.missile.giveCommand(ShipCommand.TURN_LEFT);
            }
        } else {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
            if (aimAngle < 0.0f) {
                this.missile.giveCommand(ShipCommand.TURN_RIGHT);
            } else {
                this.missile.giveCommand(ShipCommand.TURN_LEFT);
            }
        }
        if (Math.abs(aimAngle) < Math.abs(this.missile.getAngularVelocity()) * 0.1f) {
            this.missile.setAngularVelocity(aimAngle / 0.1f);
        }
    }

    public CombatEntityAPI assignTarget(MissileAPI missile) {
        ShipAPI source = missile.getSource();
        ShipAPI currentTarget = source.getShipTarget();
        if (currentTarget != null && currentTarget.isAlive() && currentTarget.getOwner() != missile.getOwner()) {
            return currentTarget;
        }
        ShipAPI closest = null;
        float closestDistance = Float.MAX_VALUE;
        for (ShipAPI tmp : AIUtils.getNearbyEnemies((CombatEntityAPI)missile, (float)1000.0f)) {
            float distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)missile.getLocation());
            if (!(distance < closestDistance)) continue;
            closest = tmp;
            closestDistance = distance;
        }
        return closest;
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        this.target = target;
    }

    public void init(CombatEngineAPI engine) {
    }
}

