/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_SimpleMissileAI
implements MissileAIPlugin,
GuidedMissileAI {
    private CombatEngineAPI engine;
    private final MissileAPI missile;
    private CombatEntityAPI target;
    private Vector2f lead = new Vector2f(0.0f, 0.0f);
    private boolean overshoot = false;
    private boolean runOnce = false;
    private final float flightSpeed;
    private final float maxSearchRange = 2000.0f;
    private final float searchCone = 10.0f;
    private final float cancellingCone = 15.0f;
    private static final float damping = 0.1f;

    public MS_SimpleMissileAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        this.flightSpeed = missile.getMaxSpeed();
    }

    public void advance(float amount) {
        if (this.engine != Global.getCombatEngine()) {
            this.engine = Global.getCombatEngine();
        }
        if (!this.runOnce) {
            this.setTarget(this.assignTarget(this.missile));
            this.runOnce = true;
        }
        if (Global.getCombatEngine().isPaused() || this.overshoot || this.missile.isFading() || this.missile.isFizzling() || this.target == null) {
            return;
        }
        this.lead = AIUtils.getBestInterceptPoint((Vector2f)this.missile.getLocation(), (float)this.flightSpeed, (Vector2f)this.target.getLocation(), (Vector2f)this.target.getVelocity());
        if (this.lead == null) {
            return;
        }
        float aimAngle = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)this.lead));
        if (Math.abs(aimAngle) > 90.0f) {
            if (aimAngle < 0.0f) {
                this.overshoot = true;
                return;
            }
        } else {
            this.missile.giveCommand(ShipCommand.ACCELERATE);
            if (aimAngle < 0.0f) {
                this.missile.giveCommand(ShipCommand.TURN_RIGHT);
            } else {
                this.missile.giveCommand(ShipCommand.TURN_LEFT);
            }
        }
        if (Math.abs(aimAngle) < Math.abs(this.missile.getAngularVelocity()) * 0.1f) {
            this.missile.setAngularVelocity(aimAngle / 0.1f);
        }
    }

    public CombatEntityAPI assignTarget(MissileAPI missile) {
        ShipAPI source = missile.getSource();
        ShipAPI currentTarget = source.getShipTarget();
        if (currentTarget != null && !currentTarget.isFighter() && !currentTarget.isDrone() && currentTarget.isAlive() && currentTarget.getOwner() != missile.getOwner() && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)currentTarget.getLocation())) < 15.0f) {
            return currentTarget;
        }
        ShipAPI closest = null;
        float closestDistance = Float.MAX_VALUE;
        for (ShipAPI tmp : AIUtils.getNearbyEnemies((CombatEntityAPI)missile, (float)2000.0f)) {
            float distance;
            if (MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > 10.0f || !((distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)missile.getLocation())) < closestDistance)) continue;
            closest = tmp;
            closestDistance = distance;
        }
        return closest;
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        this.target = target;
    }

    public void init(CombatEngineAPI engine) {
    }
}

