/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Collections;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public final class WindingMissileAI
implements MissileAIPlugin,
GuidedMissileAI {
    private final MissileAPI missile;
    private CombatEntityAPI target;
    private float offtarget = 40.0f * (float)(0.5 - Math.random());
    private float baseofftarget = 20.0f * (float)(0.5 - Math.random());
    private IntervalUtil timer = new IntervalUtil(0.1f, 0.0f);

    public static ShipAPI findBestTarget(MissileAPI missile) {
        ShipAPI source = missile.getSource();
        if (source != null && source.getShipTarget() != null && !source.getShipTarget().isHulk()) {
            return source.getShipTarget();
        }
        return AIUtils.getNearestEnemy((CombatEntityAPI)missile);
    }

    public WindingMissileAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        List directTargets = CombatUtils.getShipsWithinRange((Vector2f)launchingShip.getMouseTarget(), (float)100.0f);
        if (!directTargets.isEmpty()) {
            Collections.sort(directTargets, new CollectionUtils.SortEntitiesByDistance(launchingShip.getMouseTarget()));
            for (ShipAPI tmp : directTargets) {
                if (tmp.isHulk() || tmp.getOwner() == launchingShip.getOwner()) continue;
                this.setTarget((CombatEntityAPI)tmp);
                break;
            }
        }
        if (this.target == null) {
            this.setTarget((CombatEntityAPI)WindingMissileAI.findBestTarget(missile));
        }
    }

    public void advance(float amount) {
        float offtargetby;
        float AbsAngD;
        if (this.missile.isFading() || this.missile.isFizzling()) {
            return;
        }
        this.timer.advance(amount);
        this.missile.giveCommand(ShipCommand.ACCELERATE);
        if (this.target == null || this.target instanceof ShipAPI && ((ShipAPI)this.target).isHulk() || this.missile.getOwner() == this.target.getOwner() || !Global.getCombatEngine().isEntityInPlay(this.target)) {
            this.setTarget((CombatEntityAPI)WindingMissileAI.findBestTarget(this.missile));
            return;
        }
        float angularDistance = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)this.target.getLocation()));
        if (this.timer.intervalElapsed()) {
            float f = this.offtarget = this.offtarget > 0.0f ? this.offtarget - 1.0f : this.offtarget + 1.0f;
        }
        if ((AbsAngD = Math.abs(angularDistance - (offtargetby = 0.0f + (this.offtarget + this.baseofftarget * this.target.getCollisionRadius() / 75.0f)))) > 0.5f) {
            this.missile.giveCommand(angularDistance > offtargetby ? ShipCommand.TURN_LEFT : ShipCommand.TURN_RIGHT);
        }
        if (AbsAngD < 5.0f) {
            float MFlightAng = VectorUtils.getAngle((Vector2f)new Vector2f(), (Vector2f)this.missile.getVelocity());
            float MFlightCC = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)MFlightAng);
            if (Math.abs(MFlightCC) > 20.0f) {
                this.missile.giveCommand(MFlightCC < 0.0f ? ShipCommand.STRAFE_LEFT : ShipCommand.STRAFE_RIGHT);
            }
        }
        if (AbsAngD < 0.4f) {
            this.missile.setAngularVelocity(0.0f);
        }
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        this.target = target;
    }
}

