/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import data.scripts.util.CustomMissileTargetingTool;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public final class WindingRocketAI
implements MissileAIPlugin,
GuidedMissileAI {
    private CombatEngineAPI engine;
    private final MissileAPI missile;
    private CombatEntityAPI target;
    private Vector2f lead = new Vector2f();
    private Vector2f offset = new Vector2f();
    private boolean launch = true;
    private boolean overshoot = false;
    private float eccm = 1.5f;
    private float timer = 0.0f;
    private float check = 0.1f;
    private final float MAX_SPEED;
    private final float MAX_RANGE;
    private final float MAX_SEARCH_RANGE = 2000.0f;
    private final float SEARCH_CONE = 180.0f;
    private final float DAMPING = 0.1f;

    public WindingRocketAI(MissileAPI missile, ShipAPI launchingShip) {
        this.missile = missile;
        this.MAX_SPEED = missile.getMaxSpeed();
        this.MAX_RANGE = missile.getWeapon().getRange();
        if (missile.getSource().getVariant().getHullMods().contains("eccm")) {
            this.eccm = 1.0f;
        }
    }

    public void advance(float amount) {
        float aimAngle;
        if (this.engine != Global.getCombatEngine()) {
            this.engine = Global.getCombatEngine();
        }
        if (Global.getCombatEngine().isPaused() || this.missile.isFading() || this.missile.isFizzling()) {
            return;
        }
        this.missile.giveCommand(ShipCommand.ACCELERATE);
        if (this.launch) {
            this.launch = false;
            this.setTarget(CustomMissileTargetingTool.assignTarget(this.missile, 0, false, true, Float.valueOf(this.MAX_RANGE), Float.valueOf(2000.0f), Float.valueOf(180.0f)));
            if (this.target != null) {
                this.offset = MathUtils.getRandomPointInCircle((Vector2f)new Vector2f(), (float)(this.target.getCollisionRadius() * this.eccm / 4.0f));
                if (!CollisionUtils.isPointWithinBounds((Vector2f)new Vector2f(this.offset.x + this.target.getLocation().x, this.offset.y + this.target.getLocation().y), (CombatEntityAPI)this.target)) {
                    this.offset = new Vector2f();
                }
            }
            return;
        }
        if (this.target == null || this.overshoot || this.target.getCollisionClass() == CollisionClass.NONE) {
            return;
        }
        this.timer += amount;
        if (this.launch || this.timer >= this.check) {
            this.launch = false;
            this.timer -= this.check;
            this.check = Math.min(0.5f, Math.max(0.05f, 1.5f * MathUtils.getDistanceSquared((Vector2f)this.missile.getLocation(), (Vector2f)this.target.getLocation()) / 6000000.0f));
            this.lead = AIUtils.getBestInterceptPoint((Vector2f)this.missile.getLocation(), (float)(this.MAX_SPEED * this.eccm), (Vector2f)this.target.getLocation(), (Vector2f)this.target.getVelocity());
            if (this.lead == null) {
                this.lead = this.target.getLocation();
            }
            Vector2f.add((Vector2f)this.lead, (Vector2f)this.offset, (Vector2f)this.lead);
        }
        if ((aimAngle = MathUtils.getShortestRotation((float)this.missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.missile.getLocation(), (Vector2f)this.lead))) < 0.0f) {
            this.missile.giveCommand(ShipCommand.TURN_RIGHT);
        } else {
            this.missile.giveCommand(ShipCommand.TURN_LEFT);
        }
        if (Math.abs(aimAngle) < Math.abs(this.missile.getAngularVelocity()) * 0.1f) {
            this.missile.setAngularVelocity(aimAngle / 0.1f);
        }
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        this.target = target;
    }
}

