/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.List;

public class MSTartarusShieldFinagler
extends BaseEveryFrameCombatPlugin {
    public void advance(float amount, List<InputEventAPI> events) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine != null) {
            for (ShipAPI ship : engine.getShips()) {
                float currentArc;
                if (!"ms_tartarus".equals(ship.getHullSpec().getHullId())) continue;
                ShipSystemAPI system = ship.getSystem();
                ShieldAPI shield = ship.getShield();
                if (shield.getArc() < 360.0f) {
                    ship.setShield(shield.getType(), 0.4f, 0.7f, 720.0f);
                    shield = ship.getShield();
                }
                if (!shield.isOn() || system.isOn()) continue;
                float maxShieldArc = 270.0f;
                if (ship.getVariant().getHullMods().contains("adaptiveshields") && !ship.getVariant().getHullMods().contains("frontemitter")) {
                    maxShieldArc /= 2.0f;
                }
                if (ship.getVariant().getHullMods().contains("extendedshieldemitter")) {
                    maxShieldArc += 60.0f;
                }
                float mult = 100.0f;
                if (ship.getVariant().getHullMods().contains("advancedshieldemitter")) {
                    mult *= 2.0f;
                }
                if (!((currentArc = ship.getShield().getActiveArc()) > maxShieldArc)) continue;
                float targetArc = currentArc - mult * amount;
                if (targetArc < maxShieldArc) {
                    targetArc = maxShieldArc;
                }
                shield.setActiveArc(targetArc);
            }
        }
    }

    public void init(CombatEngineAPI engine) {
    }

    public void renderInUICoords(ViewportAPI viewport) {
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
    }
}

