/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_ArmorPiercePlugin
extends BaseEveryFrameCombatPlugin {
    private static CombatEngineAPI engine;
    private static final Map<String, CollisionClass> originalCollisionClasses;
    private static final String PIERCE_SOUND = "explosion_missile";
    private static final Color COLOR1;
    private static final Color COLOR2;
    private static final Vector2f ZERO;
    private static final Set<String> PROJ_IDS;

    public void advance(float amount, List<InputEventAPI> events) {
        if (engine != Global.getCombatEngine()) {
            engine = Global.getCombatEngine();
            originalCollisionClasses.clear();
        }
        if (engine.isPaused()) {
            return;
        }
        for (DamagingProjectileAPI proj : engine.getProjectiles()) {
            String spec = proj.getProjectileSpecId();
            if (!PROJ_IDS.contains(spec)) continue;
            if (!originalCollisionClasses.containsKey(spec)) {
                originalCollisionClasses.put(spec, proj.getCollisionClass());
            }
            proj.setCollisionClass(CollisionClass.NONE);
            Vector2f spawn = MathUtils.getRandomPointInCircle((Vector2f)proj.getLocation(), (float)(proj.getCollisionRadius() * 2.0f));
            float size = MathUtils.getRandomNumberInRange((float)20.0f, (float)10.0f);
            float sharpDur = MathUtils.getRandomNumberInRange((float)0.2f, (float)0.6f);
            float smoothDur = MathUtils.getRandomNumberInRange((float)0.1f, (float)0.4f);
            if (Math.random() > 0.08 && !engine.isPaused()) {
                engine.addHitParticle(spawn, ZERO, size, MathUtils.getRandomNumberInRange((float)1.0f, (float)2.0f), sharpDur, COLOR2);
            }
            if (Math.random() > 0.04 && !engine.isPaused()) {
                engine.addSmoothParticle(spawn, ZERO, size * 2.0f, MathUtils.getRandomNumberInRange((float)0.5f, (float)1.0f), smoothDur, COLOR1);
            }
            ArrayList toCheck = new ArrayList();
            toCheck.addAll(CombatUtils.getShipsWithinRange((Vector2f)proj.getLocation(), (float)(proj.getCollisionRadius() + 5.0f)));
            toCheck.addAll(CombatUtils.getMissilesWithinRange((Vector2f)proj.getLocation(), (float)(proj.getCollisionRadius() + 5.0f)));
            toCheck.addAll(CombatUtils.getAsteroidsWithinRange((Vector2f)proj.getLocation(), (float)(proj.getCollisionRadius() + 5.0f)));
            toCheck.remove(proj.getSource());
            for (CombatEntityAPI entity : toCheck) {
                if (entity.getCollisionClass() == CollisionClass.NONE) continue;
                if (entity.getShield() != null && entity.getShield().isOn() && entity.getShield().isWithinArc(proj.getLocation())) {
                    proj.setCollisionClass(originalCollisionClasses.get(spec));
                    continue;
                }
                if (!CollisionUtils.isPointWithinBounds((Vector2f)proj.getLocation(), (CombatEntityAPI)entity)) continue;
                float speed = proj.getVelocity().length();
                float modifier = 1.0f / (entity.getCollisionRadius() * 2.0f / speed);
                float damage = proj.getDamageAmount() * amount * modifier;
                float emp = proj.getEmpAmount() * amount * modifier;
                engine.applyDamage(entity, proj.getLocation(), damage, proj.getDamageType(), emp, true, true, (Object)proj.getSource());
                engine.spawnExplosion(proj.getLocation(), entity.getVelocity(), COLOR1, speed * amount * 2.0f, 0.5f);
                Global.getSoundPlayer().playLoop(PIERCE_SOUND, (Object)proj, 1.0f, 1.0f, proj.getLocation(), entity.getVelocity());
            }
        }
    }

    public void init(CombatEngineAPI engine) {
    }

    public void renderInUICoords(ViewportAPI viewport) {
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
        if (engine == null) {
            return;
        }
        for (DamagingProjectileAPI proj : engine.getProjectiles()) {
            String spec = proj.getProjectileSpecId();
            if (!PROJ_IDS.contains(spec)) continue;
            Vector2f Here = new Vector2f(0.0f, 0.0f);
            Here.x = proj.getLocation().x;
            Here.y = proj.getLocation().y;
            SpriteAPI sprite = Global.getSettings().getSprite("flare", "nidhoggr_ALF");
            if (!engine.isPaused()) {
                sprite.setAlphaMult(MathUtils.getRandomNumberInRange((float)0.9f, (float)1.0f));
            } else {
                float tAlf = sprite.getAlphaMult();
                sprite.setAlphaMult(tAlf);
            }
            sprite.setSize(800.0f, 100.0f);
            sprite.setAdditiveBlend();
            sprite.renderAtCenter(Here.x, Here.y);
        }
    }

    static {
        originalCollisionClasses = new HashMap<String, CollisionClass>();
        COLOR1 = new Color(165, 215, 145, 150);
        COLOR2 = new Color(155, 255, 155, 150);
        ZERO = new Vector2f();
        PROJ_IDS = new HashSet<String>();
        PROJ_IDS.add("ms_rhpcblast");
    }
}

