/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_EngineKillEffect
extends BaseEveryFrameCombatPlugin {
    private static final String PIERCE_SOUND = "ms_enginekill_impact";
    private static final Color effectColor = new Color(165, 215, 145, 150);
    private static final Color effectColorCore = new Color(255, 255, 255, 255);
    private static final float ENGINE_KILL_RADIUS_SQUARED = 900.0f;
    private static final Set<String> PROJ_IDS = new HashSet<String>();

    public void advance(float amount, List<InputEventAPI> events) {
        CombatEngineAPI engine = Global.getCombatEngine();
        for (DamagingProjectileAPI proj : engine.getProjectiles()) {
            Vector2f projLocation = proj.getLocation();
            String spec = proj.getProjectileSpecId();
            if (engine.isPaused() || !PROJ_IDS.contains(spec)) continue;
            proj.setCollisionClass(CollisionClass.NONE);
            List toCheck = CombatUtils.getShipsWithinRange((Vector2f)projLocation, (float)(proj.getCollisionRadius() + 5.0f));
            toCheck.remove(proj.getSource());
            for (CombatEntityAPI entity : toCheck) {
                if (entity.getCollisionClass() == CollisionClass.NONE || !CollisionUtils.isPointWithinBounds((Vector2f)projLocation, (CombatEntityAPI)entity)) continue;
                if (entity instanceof ShipAPI) {
                    ShipAPI ship = (ShipAPI)entity;
                    List shipEngines = ship.getEngineController().getShipEngines();
                    for (ShipEngineControllerAPI.ShipEngineAPI shipEngine : shipEngines) {
                        Vector2f shipEngineLocation;
                        float distanceSq;
                        if (shipEngine.isDisabled() || !((distanceSq = MathUtils.getDistanceSquared((Vector2f)(shipEngineLocation = shipEngine.getLocation()), (Vector2f)projLocation)) <= 900.0f)) continue;
                        shipEngine.disable();
                        engine.spawnEmpArc(proj.getSource(), projLocation, entity, entity, DamageType.OTHER, 0.0f, 0.0f, 50.0f, null, 15.0f, effectColor, effectColorCore);
                    }
                }
                engine.applyDamage(entity, projLocation, amount * proj.getDamageAmount(), proj.getDamageType(), amount * proj.getEmpAmount(), true, false, (Object)proj.getSource());
                Global.getSoundPlayer().playSound(PIERCE_SOUND, 1.0f, 1.0f, projLocation, entity.getVelocity());
            }
        }
    }

    public void init(CombatEngineAPI engine) {
    }

    public void renderInUICoords(ViewportAPI viewport) {
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
    }

    static {
        PROJ_IDS.add("ms_enginekill");
    }
}

