/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_MissileMasher
extends BaseEveryFrameCombatPlugin {
    private static CombatEngineAPI engine;
    private static final float SECONDS_TO_LOOK_AHEAD = 1.0f;
    private static final Set<String> PROJ_IDS;
    private final CollectionUtils.CollectionFilter<MissileAPI> filterMisses = new CollectionUtils.CollectionFilter<MissileAPI>(){

        public boolean accept(MissileAPI missile) {
            if (missile instanceof DamagingProjectileAPI) {
                return false;
            }
            return CollisionUtils.getCollides((Vector2f)missile.getLocation(), (Vector2f)Vector2f.add((Vector2f)missile.getLocation(), (Vector2f)((Vector2f)new Vector2f((ReadableVector2f)missile.getVelocity()).scale(1.0f)), null), (Vector2f)MS_MissileMasher.this.proj.getLocation(), (float)MS_MissileMasher.this.proj.getCollisionRadius()) && Math.abs(MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)MS_MissileMasher.this.proj.getLocation()))) <= 90.0f;
        }
    };
    private DamagingProjectileAPI proj;

    public void advance(float amount, List<InputEventAPI> events) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        for (DamagingProjectileAPI proj : engine.getProjectiles()) {
            String spec = proj.getProjectileSpecId();
            if (!PROJ_IDS.contains(spec)) continue;
            float missileCrunchRadius = Math.max(proj.getCollisionRadius(), 20.0f);
            List missiles = CombatUtils.getMissilesWithinRange((Vector2f)proj.getLocation(), (float)missileCrunchRadius);
            missiles = CollectionUtils.filter((Collection)missiles, this.filterMisses);
            for (MissileAPI missile : missiles) {
                Vector2f mLoc = missile.getLocation();
                if (missiles.isEmpty()) continue;
                engine.applyDamage((CombatEntityAPI)missile, mLoc, 99999.0f, DamageType.ENERGY, 0.0f, true, false, null);
            }
        }
    }

    static {
        PROJ_IDS = new HashSet<String>();
        PROJ_IDS.add("ms_wavebeam");
    }
}

