/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class MS_OverheatSteam
extends BaseEveryFrameCombatPlugin {
    private static final String sound = "overloadSteam";
    private static final Map<WeaponAPI.WeaponSize, Float> mag = new HashMap<WeaponAPI.WeaponSize, Float>();
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);

    public void init(CombatEngineAPI engine) {
    }

    public void advance(float amount, List<InputEventAPI> events) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine.isPaused()) {
            return;
        }
        this.interval.advance(amount);
        if (this.interval.intervalElapsed()) {
            float smokeSize = 0.8f + 0.4f * (float)Math.random();
            List ships = engine.getShips();
            for (ShipAPI ship : ships) {
                if (ship.getSystem() == null || !ship.getSystem().getId().contentEquals("ms_overdrive")) continue;
                ShipSystemAPI system = ship.getSystem();
                List weapons = ship.getAllWeapons();
                if (system == null || !system.isActive() || system.isOn()) continue;
                for (WeaponAPI weapon : weapons) {
                    float smokeSizeValue = mag.get(weapon.getSize()).floatValue();
                    float velX = (float)Math.random() * 10.0f - 5.0f;
                    float velY = (float)Math.sqrt(25.0f - velX * velX);
                    if ((float)Math.random() >= 0.5f) {
                        velY = -velY;
                    }
                    engine.addSmokeParticle(weapon.getLocation(), new Vector2f(velX, velY), 30.0f * smokeSize * smokeSizeValue, 0.05f, 4.0f, new Color(130, 130, 160, 20));
                    engine.addSmokeParticle(weapon.getLocation(), new Vector2f(velX, velY), 15.0f * smokeSize * smokeSizeValue, 0.05f, 3.0f, new Color(180, 180, 210, 20));
                }
                Global.getSoundPlayer().playSound(sound, 1.0f, 0.5f, ship.getLocation(), ship.getVelocity());
            }
        }
    }

    public void renderInUICoords(ViewportAPI viewport) {
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
    }

    static {
        mag.put(WeaponAPI.WeaponSize.SMALL, Float.valueOf(1.0f));
        mag.put(WeaponAPI.WeaponSize.MEDIUM, Float.valueOf(1.5f));
        mag.put(WeaponAPI.WeaponSize.LARGE, Float.valueOf(2.5f));
    }
}

