/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class MS_PulsePopperPlugin
extends BaseEveryFrameCombatPlugin {
    private CombatEngineAPI engine;
    private static final Color FX1 = new Color(255, 240, 165, 255);
    private static final Color FX2 = new Color(250, 135, 75, 255);
    private Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    private String sound;

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        List projs = this.engine.getProjectiles();
        int size = projs.size();
        for (int i = 0; i < size; ++i) {
            float vol;
            float popBig;
            float popSmall;
            DamagingProjectileAPI proj = (DamagingProjectileAPI)projs.get(i);
            if (!proj.isFading() || proj.getProjectileSpecId() == null || !proj.getProjectileSpecId().startsWith("ms_cepc") && !proj.getProjectileSpecId().startsWith("ms_mcepc") && !proj.getProjectileSpecId().startsWith("ms_scatter") || proj.didDamage() || !(Math.random() > 0.5)) continue;
            switch (proj.getProjectileSpecId()) {
                case "ms_mcepc_blast": {
                    popSmall = 15.0f;
                    popBig = 25.0f;
                    this.sound = "cepc_pop_big";
                    vol = 0.65f;
                    break;
                }
                case "ms_cepc_blast": 
                case "ms_scattercepc_clone": {
                    popSmall = 12.0f;
                    popBig = 17.0f;
                    this.sound = "cepc_pop";
                    vol = 0.5f;
                    break;
                }
                default: {
                    popSmall = 6.0f;
                    popBig = 11.0f;
                    this.sound = "cepc_pop_small";
                    vol = 0.4f;
                }
            }
            this.engine.addHitParticle(proj.getLocation(), this.ZERO, popSmall, 1.0f, 0.15f, FX1);
            this.engine.addHitParticle(proj.getLocation(), this.ZERO, popBig, 1.0f, 0.275f, FX2);
            Global.getSoundPlayer().playSound(this.sound, 1.0f, vol, proj.getLocation(), this.ZERO);
            this.engine.removeEntity((CombatEntityAPI)proj);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }
}

