/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import data.scripts.util.MS_Utils;
import data.scripts.util.MS_effectsHook;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_phaseGunEnergyBomb
extends BaseEveryFrameCombatPlugin {
    private static final float bombDamage = 400.0f;
    private static final float bombSplodeSize = 125.0f;
    private static final float bombSplodeCore = 112.5f;
    private static final Color effectColor1 = new Color(210, 125, 105, 215);
    private static final Color effectColor2 = new Color(85, 35, 50, 150);
    private static final float bombFlashDur = 0.25f;
    private static final float bombFuseRange = 50.0f;
    private static final String MISS_IDS = "ms_phaseblast";
    private static final float bombVisualSize = 125.0f;
    private static final float bombCoreVisualSize = 50.0f;
    private static final float LOOK_AHEAD_TIME = 0.067f;
    private static final Vector2f ZERO = new Vector2f();
    private final Set<DamagingProjectileAPI> DO_NOT_EXPLODE = new HashSet<DamagingProjectileAPI>();
    private CombatEngineAPI engine;

    public static void phaseBombExplode(DamagingProjectileAPI projectile, Vector2f point, CombatEngineAPI engine) {
        if (point == null) {
            return;
        }
        MS_effectsHook.createRift(point);
        engine.addHitParticle(point, ZERO, 50.0f, 1.0f, 0.25f, Color.WHITE);
        engine.addHitParticle(point, ZERO, 125.0f, 0.4f, 0.4f, effectColor1);
        Vector2f vel = new Vector2f();
        for (int i = 0; i < 30; ++i) {
            vel.set(((float)Math.random() * 1.25f + 0.25f) * 125.0f, 0.0f);
            VectorUtils.rotate((Vector2f)vel, (float)((float)Math.random() * 360.0f), (Vector2f)vel);
            engine.addSmoothParticle(projectile.getLocation(), vel, (float)Math.random() * 2.5f + 2.5f, 1.0f, (float)Math.random() * 0.3f + 0.6f, effectColor2);
        }
        StandardLight light = new StandardLight(projectile.getLocation(), ZERO, ZERO, null);
        light.setColor(effectColor1);
        light.setSize(137.5f);
        light.setIntensity(0.15f);
        light.fadeOut(0.2f);
        LightShader.addLight((LightAPI)light);
        Global.getSoundPlayer().playSound("phaseGunGapAsplode", 1.0f, 1.0f, point, projectile.getVelocity());
        List<ShipAPI> ships = CombatUtils.getShipsWithinRange((Vector2f)point, (float)125.0f);
        List targets = CombatUtils.getAsteroidsWithinRange((Vector2f)point, (float)125.0f);
        targets.addAll(CombatUtils.getMissilesWithinRange((Vector2f)point, (float)125.0f));
        Iterator iter = ships.iterator();
        while (iter.hasNext()) {
            ShipAPI ship = (ShipAPI)iter.next();
            if (ship.getCollisionClass() == CollisionClass.NONE) {
                iter.remove();
                continue;
            }
            if (!ship.isFighter() && !ship.isDrone()) continue;
            boolean remove = false;
            for (ShipAPI shp : ships) {
                if (shp.getShield() == null || shp == ship || !shp.getShield().isWithinArc(ship.getLocation()) || !shp.getShield().isOn() || !(MathUtils.getDistance((Vector2f)ship.getLocation(), (Vector2f)shp.getShield().getLocation()) <= shp.getShield().getRadius())) continue;
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
        ships = MS_Utils.getSortedAreaList(point, ships);
        targets.addAll(ships);
        for (CombatEntityAPI tgt : targets) {
            Vector2f damagePoint;
            ShipAPI ship;
            float distance = MS_Utils.getActualDistance(point, tgt, true);
            float reduction = 1.0f;
            if (distance > 50.0f) {
                reduction = (125.0f - distance) / 12.5f;
            }
            if (reduction <= 0.0f) continue;
            boolean shieldHit = false;
            if (tgt instanceof ShipAPI && (ship = (ShipAPI)tgt).getShield() != null && ship.getShield().isWithinArc(point)) {
                shieldHit = true;
            }
            if (shieldHit) {
                ShipAPI ship2 = (ShipAPI)tgt;
                damagePoint = MathUtils.getPointOnCircumference(null, (float)ship2.getShield().getRadius(), (float)VectorUtils.getAngle((Vector2f)ship2.getShield().getLocation(), (Vector2f)point));
                Vector2f.add((Vector2f)damagePoint, (Vector2f)tgt.getLocation(), (Vector2f)damagePoint);
            } else {
                Vector2f projection = VectorUtils.getDirectionalVector((Vector2f)point, (Vector2f)tgt.getLocation());
                projection.scale(tgt.getCollisionRadius());
                Vector2f.add((Vector2f)projection, (Vector2f)tgt.getLocation(), (Vector2f)projection);
                damagePoint = CollisionUtils.getCollisionPoint((Vector2f)point, (Vector2f)projection, (CombatEntityAPI)tgt);
            }
            if (damagePoint == null) {
                damagePoint = point;
            }
            engine.applyDamage(tgt, damagePoint, 400.0f * reduction, DamageType.ENERGY, 0.0f, false, false, (Object)projectile.getSource());
        }
        engine.removeEntity((CombatEntityAPI)projectile);
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        List projectiles = this.engine.getProjectiles();
        ArrayList<DamagingProjectileAPI> toRemove = new ArrayList<DamagingProjectileAPI>();
        for (DamagingProjectileAPI proj : this.DO_NOT_EXPLODE) {
            if (projectiles.contains(proj)) continue;
            toRemove.add(proj);
        }
        this.DO_NOT_EXPLODE.removeAll(toRemove);
        int size = projectiles.size();
        block7: for (int i = 0; i < size; ++i) {
            DamagingProjectileAPI bomb = (DamagingProjectileAPI)projectiles.get(i);
            String spec = bomb.getProjectileSpecId();
            Vector2f loc = bomb.getLocation();
            if (spec == null) continue;
            switch (spec) {
                case "ms_phaseblast": {
                    if (bomb.didDamage() || this.DO_NOT_EXPLODE.contains(bomb)) continue block7;
                    if (bomb.isFading() && Math.random() < 0.5) {
                        MS_phaseGunEnergyBomb.phaseBombExplode(bomb, loc, this.engine);
                        continue block7;
                    }
                    LinkedList toCheck = new LinkedList();
                    List asteroids = CombatUtils.getAsteroidsWithinRange((Vector2f)loc, (float)50.0f);
                    toCheck.addAll(CombatUtils.getShipsWithinRange((Vector2f)loc, (float)50.0f));
                    toCheck.addAll(CombatUtils.getMissilesWithinRange((Vector2f)loc, (float)50.0f));
                    toCheck.addAll(asteroids);
                    for (CombatEntityAPI entity : toCheck) {
                        float distance;
                        ShieldAPI shield;
                        Vector2f ahead;
                        if (entity.getCollisionClass() == CollisionClass.NONE || entity == bomb.getSource()) continue;
                        if (entity.getShield() != null && CollisionUtils.getCollides((Vector2f)loc, (Vector2f)(ahead = new Vector2f((ReadableVector2f)loc).translate(bomb.getVelocity().getX() * 0.067f, bomb.getVelocity().getY() * 0.067f)), (Vector2f)(shield = entity.getShield()).getLocation(), (float)shield.getRadius()) && shield.isWithinArc(ahead)) {
                            this.DO_NOT_EXPLODE.add(bomb);
                            MS_phaseGunEnergyBomb.phaseBombExplode(bomb, loc, this.engine);
                            break;
                        }
                        if (asteroids.contains(entity) || bomb.getOwner() == 0 && entity.getOwner() != 1 || bomb.getOwner() == 1 && entity.getOwner() != 0 || !((distance = MS_Utils.getActualDistance(loc, entity, true)) <= 50.0f)) continue;
                        this.DO_NOT_EXPLODE.add(bomb);
                        MS_phaseGunEnergyBomb.phaseBombExplode(bomb, loc, this.engine);
                        break;
                    }
                    if (!bomb.isFading() || this.DO_NOT_EXPLODE.contains(bomb)) continue block7;
                    this.DO_NOT_EXPLODE.add(bomb);
                    MS_phaseGunEnergyBomb.phaseBombExplode(bomb, loc, this.engine);
                    continue block7;
                }
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }
}

