/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_scatterGunSpreader
extends BaseEveryFrameCombatPlugin {
    private static final Set<String> SHOTGUNPROJ_IDS = new HashSet<String>(2);
    private Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    private CombatEngineAPI engine;

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        List projectiles = this.engine.getProjectiles();
        int size = projectiles.size();
        for (int i = 0; i < size; ++i) {
            DamagingProjectileAPI proj = (DamagingProjectileAPI)projectiles.get(i);
            String spec = proj.getProjectileSpecId();
            if (!SHOTGUNPROJ_IDS.contains(spec)) continue;
            Vector2f loc = proj.getLocation();
            Vector2f vel = proj.getVelocity();
            int shotCount = 20;
            for (int j = 0; j < shotCount; ++j) {
                Vector2f randomVel = MathUtils.getRandomPointOnCircumference(null, (float)MathUtils.getRandomNumberInRange((float)60.0f, (float)200.0f));
                randomVel.x += vel.x;
                randomVel.y += vel.y;
                this.engine.spawnProjectile(proj.getSource(), proj.getWeapon(), spec + "_clone", loc, proj.getFacing(), randomVel);
                if (!proj.getProjectileSpecId().equals("ms_barrago_lrm_shatter")) continue;
                for (int k = 0; k < 1; ++k) {
                    Global.getSoundPlayer().playSound("barragoSeparator", 1.0f, 1.0f, proj.getLocation(), this.ZERO);
                }
            }
            this.engine.removeEntity((CombatEntityAPI)proj);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    static {
        SHOTGUNPROJ_IDS.add("ms_scattercepc");
        SHOTGUNPROJ_IDS.add("ms_barrago_lrm_shatter");
    }
}

