/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class MS_shamashBombPrimer
extends BaseEveryFrameCombatPlugin {
    private static final float BLINKER_Y_OFFSET = -3.0f;
    private static final float BLINKS_PER_SECOND = 4.0f;
    private static final String BOMB_PROJ_ID = "ms_phaseblast";
    private static final float TIME_BETWEEN_CHECKS = 0.33f;
    private final Map<DamagingProjectileAPI, Blinker> bombs = new HashMap<DamagingProjectileAPI, Blinker>(30);
    private float nextCheck = 0.33f;
    private SpriteAPI sprite;
    private float spriteHeight;
    private float spriteWidth;

    public void advance(float amount, List<InputEventAPI> events) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine == null || engine.isPaused()) {
            return;
        }
        this.nextCheck -= amount;
        if (this.nextCheck <= 0.0f) {
            this.nextCheck = 0.33f;
            for (DamagingProjectileAPI proj : engine.getProjectiles()) {
                if (!BOMB_PROJ_ID.equals(proj.getProjectileSpecId()) || this.bombs.containsKey(proj)) continue;
                this.bombs.put(proj, new Blinker(proj));
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.sprite = Global.getSettings().getSprite("misc", "ms_bomb_blinker");
        this.sprite.setAdditiveBlend();
        this.spriteWidth = this.sprite.getWidth();
        this.spriteHeight = this.sprite.getHeight();
        this.bombs.clear();
    }

    public void renderInWorldCoords(ViewportAPI view) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine == null) {
            return;
        }
        if (!this.bombs.isEmpty()) {
            float amount = engine.isPaused() ? 0.0f : engine.getElapsedInLastFrame();
            GL11.glEnable((int)3553);
            Iterator<Map.Entry<DamagingProjectileAPI, Blinker>> iter = this.bombs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<DamagingProjectileAPI, Blinker> entry = iter.next();
                DamagingProjectileAPI proj = entry.getKey();
                if (proj.didDamage() || !engine.isEntityInPlay((CombatEntityAPI)proj)) {
                    iter.remove();
                    continue;
                }
                entry.getValue().advanceAndRender(amount);
            }
        }
    }

    private class Blinker {
        private boolean blinkDirection;
        private float blinkProgress;
        private final DamagingProjectileAPI bomb;

        private Blinker(DamagingProjectileAPI bomb) {
            this.bomb = bomb;
            this.blinkProgress = 0.0f;
            this.blinkDirection = true;
        }

        private void advanceAndRender(float amount) {
            if (amount > 0.0f) {
                this.blinkProgress += amount * 4.0f * (this.blinkDirection ? 4.0f : -4.0f);
                if (this.blinkDirection && this.blinkProgress > 1.0f || !this.blinkDirection && this.blinkProgress < -1.0f) {
                    this.blinkProgress = this.blinkDirection ? 1.0f : -1.0f;
                    boolean bl = this.blinkDirection = !this.blinkDirection;
                }
            }
            if (this.blinkProgress >= 0.0f) {
                MS_shamashBombPrimer.this.sprite.setAlphaMult(Math.min(1.0f, 0.5f + this.blinkProgress / 2.0f));
                MS_shamashBombPrimer.this.sprite.setSize(MS_shamashBombPrimer.this.spriteWidth * this.blinkProgress, MS_shamashBombPrimer.this.spriteHeight * this.blinkProgress);
                Vector2f loc = MathUtils.getPointOnCircumference((Vector2f)this.bomb.getLocation(), (float)-3.0f, (float)this.bomb.getFacing());
                MS_shamashBombPrimer.this.sprite.renderAtCenter(loc.x, loc.y);
            }
        }
    }
}

