/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import data.scripts.util.MS_Utils;
import data.scripts.util.MS_effectsHook;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_shamashFlaresFlakEffect
extends BaseEveryFrameCombatPlugin {
    private static final float flareDamage = 100.0f;
    private static final float flareFlakSize = 65.0f;
    private static final float flareFlakCoreSize = 30.0f;
    private static final Color effectColor1 = new Color(210, 125, 105, 215);
    private static final Color effectColor2 = new Color(85, 35, 50, 150);
    private static final float flareFlashDur = 0.2f;
    private static final float flareFuseRange = 30.0f;
    private static final String MISS_IDS = "ms_flare_shamash";
    private static final float flareVisualSize = 90.0f;
    private static final float flareCoreSize = 30.0f;
    private static final float LOOK_AHEAD_TIME = 0.067f;
    private static final Vector2f ZERO = new Vector2f();
    private final Set<DamagingProjectileAPI> DO_NOT_EXPLODE = new HashSet<DamagingProjectileAPI>();
    private CombatEngineAPI engine;

    public static void burstFlakExplode(DamagingProjectileAPI projectile, Vector2f point, CombatEngineAPI engine) {
        if (point == null) {
            return;
        }
        MS_effectsHook.createFlakShockwave(point);
        engine.addHitParticle(point, ZERO, 30.0f, 1.0f, 0.2f, Color.WHITE);
        engine.addHitParticle(point, ZERO, 90.0f, 0.4f, 0.6f, effectColor1);
        Vector2f vel = new Vector2f();
        for (int i = 0; i < 30; ++i) {
            vel.set(((float)Math.random() * 1.25f + 0.25f) * 90.0f, 0.0f);
            VectorUtils.rotate((Vector2f)vel, (float)((float)Math.random() * 360.0f), (Vector2f)vel);
            engine.addSmoothParticle(projectile.getLocation(), vel, (float)Math.random() * 2.5f + 2.5f, 1.0f, (float)Math.random() * 0.3f + 0.6f, effectColor2);
        }
        StandardLight light = new StandardLight(projectile.getLocation(), ZERO, ZERO, null);
        light.setColor(effectColor1);
        light.setSize(99.0f);
        light.setIntensity(0.15f);
        light.fadeOut(0.2f);
        LightShader.addLight((LightAPI)light);
        Global.getSoundPlayer().playSound("hit_light", 1.0f, 1.0f, point, projectile.getVelocity());
        List<ShipAPI> ships = CombatUtils.getShipsWithinRange((Vector2f)point, (float)65.0f);
        List targets = CombatUtils.getAsteroidsWithinRange((Vector2f)point, (float)65.0f);
        targets.addAll(CombatUtils.getMissilesWithinRange((Vector2f)point, (float)65.0f));
        Iterator iter = ships.iterator();
        while (iter.hasNext()) {
            ShipAPI ship = (ShipAPI)iter.next();
            if (ship.getCollisionClass() == CollisionClass.NONE) {
                iter.remove();
                continue;
            }
            if (!ship.isFighter() && !ship.isDrone()) continue;
            boolean remove = false;
            for (ShipAPI shp : ships) {
                if (shp.getShield() == null || shp == ship || !shp.getShield().isWithinArc(ship.getLocation()) || !shp.getShield().isOn() || !(MathUtils.getDistance((Vector2f)ship.getLocation(), (Vector2f)shp.getShield().getLocation()) <= shp.getShield().getRadius())) continue;
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
        ships = MS_Utils.getSortedAreaList(point, ships);
        targets.addAll(ships);
        for (CombatEntityAPI tgt : targets) {
            Vector2f damagePoint;
            ShipAPI ship;
            if (tgt.getOwner() == projectile.getOwner()) continue;
            float distance = MS_Utils.getActualDistance(point, tgt, true);
            float reduction = 1.0f;
            if (distance > 30.0f) {
                reduction = (65.0f - distance) / 35.0f;
            }
            if (reduction <= 0.0f) continue;
            boolean shieldHit = false;
            if (tgt instanceof ShipAPI && (ship = (ShipAPI)tgt).getShield() != null && ship.getShield().isWithinArc(point)) {
                shieldHit = true;
            }
            if (shieldHit) {
                ShipAPI ship2 = (ShipAPI)tgt;
                damagePoint = MathUtils.getPointOnCircumference(null, (float)ship2.getShield().getRadius(), (float)VectorUtils.getAngle((Vector2f)ship2.getShield().getLocation(), (Vector2f)point));
                Vector2f.add((Vector2f)damagePoint, (Vector2f)tgt.getLocation(), (Vector2f)damagePoint);
            } else {
                Vector2f projection = VectorUtils.getDirectionalVector((Vector2f)point, (Vector2f)tgt.getLocation());
                projection.scale(tgt.getCollisionRadius());
                Vector2f.add((Vector2f)projection, (Vector2f)tgt.getLocation(), (Vector2f)projection);
                damagePoint = CollisionUtils.getCollisionPoint((Vector2f)point, (Vector2f)projection, (CombatEntityAPI)tgt);
            }
            if (damagePoint == null) {
                damagePoint = point;
            }
            engine.applyDamage(tgt, damagePoint, 100.0f * reduction, DamageType.FRAGMENTATION, 0.0f, false, false, (Object)projectile.getSource());
        }
        engine.removeEntity((CombatEntityAPI)projectile);
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        List projectiles = this.engine.getProjectiles();
        ArrayList<DamagingProjectileAPI> toRemove = new ArrayList<DamagingProjectileAPI>();
        for (DamagingProjectileAPI proj : this.DO_NOT_EXPLODE) {
            if (projectiles.contains(proj)) continue;
            toRemove.add(proj);
        }
        this.DO_NOT_EXPLODE.removeAll(toRemove);
        int size = projectiles.size();
        block7: for (int i = 0; i < size; ++i) {
            DamagingProjectileAPI flare = (DamagingProjectileAPI)projectiles.get(i);
            String spec = flare.getProjectileSpecId();
            Vector2f loc = flare.getLocation();
            if (spec == null) continue;
            switch (spec) {
                case "ms_flare_shamash": {
                    if (flare.didDamage() || this.DO_NOT_EXPLODE.contains(flare)) continue block7;
                    LinkedList toCheck = new LinkedList();
                    List asteroids = CombatUtils.getAsteroidsWithinRange((Vector2f)loc, (float)65.0f);
                    toCheck.addAll(CombatUtils.getShipsWithinRange((Vector2f)loc, (float)65.0f));
                    toCheck.addAll(CombatUtils.getMissilesWithinRange((Vector2f)loc, (float)65.0f));
                    toCheck.addAll(asteroids);
                    for (CombatEntityAPI entity : toCheck) {
                        Vector2f ahead;
                        float distance;
                        ShieldAPI shield;
                        Vector2f ahead2;
                        ShipAPI ship;
                        if (entity.getCollisionClass() == CollisionClass.NONE || entity == flare.getSource() || entity.getOwner() == flare.getOwner() && (entity instanceof DamagingProjectileAPI || entity instanceof ShipAPI && ((ship = (ShipAPI)entity).isFighter() || ship.isDrone()) && ship.isAlive() && !ship.getEngineController().isFlamedOut())) continue;
                        if (entity.getShield() != null && CollisionUtils.getCollides((Vector2f)loc, (Vector2f)(ahead2 = new Vector2f((ReadableVector2f)loc).translate(flare.getVelocity().getX() * 0.067f, flare.getVelocity().getY() * 0.067f)), (Vector2f)(shield = entity.getShield()).getLocation(), (float)shield.getRadius()) && shield.isWithinArc(ahead2)) {
                            if (entity.getOwner() == flare.getOwner() || entity.getOwner() > 1) {
                                this.DO_NOT_EXPLODE.add(flare);
                                break;
                            }
                            this.DO_NOT_EXPLODE.add(flare);
                            MS_shamashFlaresFlakEffect.burstFlakExplode(flare, loc, this.engine);
                            break;
                        }
                        if ((entity.getOwner() == flare.getOwner() || entity.getOwner() > 1) && (distance = MS_Utils.getActualDistance(loc, entity, true)) <= 30.0f && CollisionUtils.getCollisionPoint((Vector2f)loc, (Vector2f)(ahead = new Vector2f((ReadableVector2f)loc).translate(flare.getVelocity().getX() * 0.067f, flare.getVelocity().getY() * 0.067f)), (CombatEntityAPI)entity) != null) {
                            this.DO_NOT_EXPLODE.add(flare);
                            break;
                        }
                        if (asteroids.contains(entity) || flare.getOwner() == 0 && entity.getOwner() != 1 || flare.getOwner() == 1 && entity.getOwner() != 0 || !((distance = MS_Utils.getActualDistance(loc, entity, true)) <= 30.0f)) continue;
                        this.DO_NOT_EXPLODE.add(flare);
                        MS_shamashFlaresFlakEffect.burstFlakExplode(flare, loc, this.engine);
                        break;
                    }
                    if (!flare.isFading() || this.DO_NOT_EXPLODE.contains(flare)) continue block7;
                    this.DO_NOT_EXPLODE.add(flare);
                    MS_shamashFlaresFlakEffect.burstFlakExplode(flare, loc, this.engine);
                    continue block7;
                }
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }
}

