/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class CustomMissileTargetingTool {
    public static CombatEntityAPI assignTarget(MissileAPI missile, Integer randomTarget, boolean antiFighter, boolean assault, Float maxRange, Float maxSearchRange, Float searchCone) {
        ShipAPI theTarget;
        block22: {
            List closeTargets;
            ShipAPI currentTarget;
            ShipAPI source;
            block23: {
                theTarget = null;
                source = missile.getSource();
                currentTarget = source != null && source.getShipTarget() != null && source.getShipTarget() instanceof ShipAPI && source.getShipTarget().getOwner() != missile.getOwner() ? source.getShipTarget() : null;
                if (randomTarget <= 0) break block23;
                Vector2f location = missile.getLocation();
                if (randomTarget < 2) {
                    if (currentTarget != null && currentTarget.isAlive() && MathUtils.isWithinRange((CombatEntityAPI)missile, (CombatEntityAPI)currentTarget, (float)maxRange.floatValue())) {
                        location = currentTarget.getLocation();
                    } else if (source != null && source.getMouseTarget() != null) {
                        location = source.getMouseTarget();
                    }
                }
                theTarget = antiFighter ? CustomMissileTargetingTool.getRandomFighterTarget(location, missile, maxRange, searchCone) : (assault ? CustomMissileTargetingTool.getRandomLargeTarget(location, missile, maxRange, searchCone) : CustomMissileTargetingTool.getAnyTarget(location, missile, maxRange, searchCone));
                break block22;
            }
            if (source != null) {
                if (!(currentTarget == null || !currentTarget.isAlive() || currentTarget.getOwner() == missile.getOwner() || antiFighter && (!currentTarget.isDrone() || !currentTarget.isFighter()) || assault && (currentTarget.isDrone() || currentTarget.isFighter()) || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)currentTarget.getLocation())) > searchCone.floatValue() / 2.0f)) {
                    theTarget = currentTarget;
                } else {
                    List mouseTargets = CombatUtils.getShipsWithinRange((Vector2f)source.getMouseTarget(), (float)100.0f);
                    if (!mouseTargets.isEmpty()) {
                        Collections.sort(mouseTargets, new CollectionUtils.SortEntitiesByDistance(source.getMouseTarget()));
                        for (ShipAPI tmp : mouseTargets) {
                            if (!tmp.isAlive() || tmp.getOwner() == missile.getOwner() || antiFighter && (!tmp.isDrone() || !tmp.isFighter()) || assault && (tmp.isDrone() || tmp.isFighter() || tmp.isFrigate()) || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > searchCone.floatValue() / 2.0f) continue;
                            theTarget = tmp;
                            break;
                        }
                    }
                }
            }
            if (theTarget != null || (closeTargets = AIUtils.getNearbyEnemies((CombatEntityAPI)missile, (float)maxSearchRange.floatValue())).isEmpty()) break block22;
            Collections.sort(closeTargets, new CollectionUtils.SortEntitiesByDistance(missile.getLocation()));
            if (assault) {
                for (ShipAPI tmp : closeTargets) {
                    if (!tmp.isAlive() || tmp.getOwner() == missile.getOwner() || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > searchCone.floatValue() / 2.0f) continue;
                    if (tmp.isCapital() || tmp.isCruiser()) {
                        theTarget = tmp;
                    } else if (tmp.isDestroyer() && Math.random() > 0.5) {
                        theTarget = tmp;
                    } else if (tmp.isDestroyer() && Math.random() > 0.75) {
                        theTarget = tmp;
                    } else {
                        if (tmp.isDrone() || tmp.isFighter() || !(Math.random() > 0.95)) continue;
                        theTarget = tmp;
                    }
                    break;
                }
            } else if (antiFighter) {
                for (ShipAPI tmp : closeTargets) {
                    if (!tmp.isAlive() || tmp.getOwner() == missile.getOwner() || !tmp.isDrone() && !tmp.isFighter() || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > searchCone.floatValue() / 2.0f) continue;
                    theTarget = tmp;
                    break;
                }
            } else {
                for (ShipAPI tmp : closeTargets) {
                    if (!tmp.isAlive() || tmp.getOwner() == missile.getOwner() || tmp.isDrone() || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > searchCone.floatValue() / 2.0f) continue;
                    theTarget = tmp;
                    break;
                }
            }
        }
        return theTarget;
    }

    public static ShipAPI getRandomFighterTarget(Vector2f location, MissileAPI missile, Float maxRange, Float searchCone) {
        ShipAPI select = null;
        HashMap<Integer, ShipAPI> PRIORITYLIST = new HashMap<Integer, ShipAPI>();
        HashMap<Integer, ShipAPI> OTHERSLIST = new HashMap<Integer, ShipAPI>();
        int i = 1;
        int u = 1;
        List potentialTargets = CombatUtils.getShipsWithinRange((Vector2f)location, (float)maxRange.floatValue());
        if (!potentialTargets.isEmpty()) {
            for (ShipAPI tmp : potentialTargets) {
                if (!tmp.isAlive() || tmp.getOwner() == missile.getOwner() || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > searchCone.floatValue() / 2.0f) continue;
                if (tmp.isFighter() || tmp.isDrone()) {
                    PRIORITYLIST.put(i, tmp);
                    ++i;
                    continue;
                }
                OTHERSLIST.put(u, tmp);
                ++u;
            }
            if (!PRIORITYLIST.isEmpty()) {
                int chooser = Math.round((float)Math.random() * (float)(i - 1) + 0.5f);
                select = (ShipAPI)PRIORITYLIST.get(chooser);
            } else if (!OTHERSLIST.isEmpty()) {
                int chooser = Math.round((float)Math.random() * (float)(u - 1) + 0.5f);
                select = (ShipAPI)OTHERSLIST.get(chooser);
            }
        }
        return select;
    }

    public static ShipAPI getRandomLargeTarget(Vector2f location, MissileAPI missile, Float maxRange, Float searchCone) {
        ShipAPI select = null;
        HashMap<Integer, ShipAPI> PRIORITY1 = new HashMap<Integer, ShipAPI>();
        HashMap<Integer, ShipAPI> PRIORITY2 = new HashMap<Integer, ShipAPI>();
        HashMap<Integer, ShipAPI> PRIORITY3 = new HashMap<Integer, ShipAPI>();
        HashMap<Integer, ShipAPI> PRIORITY4 = new HashMap<Integer, ShipAPI>();
        HashMap<Integer, ShipAPI> OTHERSLIST = new HashMap<Integer, ShipAPI>();
        int i = 1;
        int u = 1;
        int v = 1;
        int x = 1;
        int y = 1;
        List potentialTargets = CombatUtils.getShipsWithinRange((Vector2f)location, (float)maxRange.floatValue());
        if (!potentialTargets.isEmpty()) {
            for (ShipAPI tmp : potentialTargets) {
                if (!tmp.isAlive() || tmp.getOwner() == missile.getOwner() || tmp.isDrone() || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > searchCone.floatValue() / 2.0f) continue;
                if (tmp.isCapital()) {
                    PRIORITY1.put(i, tmp);
                    ++i;
                    PRIORITY2.put(u, tmp);
                    ++u;
                    PRIORITY3.put(x, tmp);
                    ++x;
                    PRIORITY4.put(v, tmp);
                    ++v;
                    OTHERSLIST.put(y, tmp);
                    ++y;
                    continue;
                }
                if (tmp.isCruiser()) {
                    PRIORITY2.put(u, tmp);
                    ++u;
                    PRIORITY3.put(x, tmp);
                    ++x;
                    PRIORITY4.put(v, tmp);
                    ++v;
                    OTHERSLIST.put(y, tmp);
                    ++y;
                    continue;
                }
                if (tmp.isDestroyer()) {
                    PRIORITY3.put(x, tmp);
                    ++x;
                    PRIORITY4.put(v, tmp);
                    ++v;
                    OTHERSLIST.put(y, tmp);
                    ++y;
                    continue;
                }
                if (tmp.isFrigate()) {
                    PRIORITY4.put(v, tmp);
                    ++v;
                    OTHERSLIST.put(y, tmp);
                    ++y;
                    continue;
                }
                OTHERSLIST.put(y, tmp);
                ++y;
            }
            if (!PRIORITY1.isEmpty() && Math.random() > (double)0.8f) {
                int chooser = Math.round((float)Math.random() * (float)(i - 1) + 0.5f);
                select = (ShipAPI)PRIORITY1.get(chooser);
            } else if (!PRIORITY2.isEmpty() && Math.random() > (double)0.8f) {
                int chooser = Math.round((float)Math.random() * (float)(u - 1) + 0.5f);
                select = (ShipAPI)PRIORITY2.get(chooser);
            } else if (!PRIORITY3.isEmpty() && Math.random() > (double)0.8f) {
                int chooser = Math.round((float)Math.random() * (float)(x - 1) + 0.5f);
                select = (ShipAPI)PRIORITY3.get(chooser);
            } else if (!PRIORITY4.isEmpty() && Math.random() > (double)0.8f) {
                int chooser = Math.round((float)Math.random() * (float)(v - 1) + 0.5f);
                select = (ShipAPI)PRIORITY4.get(chooser);
            } else if (!OTHERSLIST.isEmpty()) {
                int chooser = Math.round((float)Math.random() * (float)(y - 1) + 0.5f);
                select = (ShipAPI)OTHERSLIST.get(chooser);
            }
        }
        return select;
    }

    public static ShipAPI getAnyTarget(Vector2f location, MissileAPI missile, Float maxRange, Float searchCone) {
        ShipAPI select = null;
        HashMap<Integer, ShipAPI> TARGETLIST = new HashMap<Integer, ShipAPI>();
        int i = 1;
        List potentialTargets = CombatUtils.getShipsWithinRange((Vector2f)location, (float)maxRange.floatValue());
        if (!potentialTargets.isEmpty()) {
            for (ShipAPI tmp : potentialTargets) {
                if (!tmp.isAlive() || tmp.getOwner() == missile.getOwner() || searchCone.floatValue() > 0.0f && MathUtils.getShortestRotation((float)missile.getFacing(), (float)VectorUtils.getAngle((Vector2f)missile.getLocation(), (Vector2f)tmp.getLocation())) > searchCone.floatValue() / 2.0f || tmp.isDrone()) continue;
                TARGETLIST.put(i, tmp);
                ++i;
            }
            if (!TARGETLIST.isEmpty()) {
                int chooser = Math.round((float)Math.random() * (float)(i - 1) + 0.5f);
                select = (ShipAPI)TARGETLIST.get(chooser);
            }
        }
        return select;
    }
}

