/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import data.scripts.ShadowyardsModPlugin;
import db.twiglib.TwigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_Utils {
    static final float SAFE_DISTANCE = 600.0f;
    static final float DEFAULT_DAMAGE_WINDOW = 3.0f;

    public static float estimateIncomingDamage(ShipAPI ship) {
        return MS_Utils.estimateIncomingDamage(ship, 3.0f);
    }

    public static float estimateIncomingDamage(ShipAPI ship, float damageWindowSeconds) {
        float accumulator = 0.0f;
        accumulator += MS_Utils.estimateIncomingBeamDamage(ship, damageWindowSeconds);
        for (DamagingProjectileAPI proj : Global.getCombatEngine().getProjectiles()) {
            if (proj.getOwner() == ship.getOwner()) continue;
            Vector2f endPoint = new Vector2f((ReadableVector2f)proj.getVelocity());
            endPoint.scale(damageWindowSeconds);
            Vector2f.add((Vector2f)endPoint, (Vector2f)proj.getLocation(), (Vector2f)endPoint);
            if (ship.getShield() != null && ship.getShield().isWithinArc(proj.getLocation()) || !CollisionUtils.getCollides((Vector2f)proj.getLocation(), (Vector2f)endPoint, (Vector2f)new Vector2f((ReadableVector2f)ship.getLocation()), (float)ship.getCollisionRadius())) continue;
            accumulator += proj.getDamageAmount() + proj.getEmpAmount();
        }
        return accumulator;
    }

    public static float estimateIncomingBeamDamage(ShipAPI ship, float damageWindowSeconds) {
        float accumulator = 0.0f;
        for (BeamAPI beam : Global.getCombatEngine().getBeams()) {
            if (beam.getDamageTarget() != ship) continue;
            float dps = beam.getWeapon().getDerivedStats().getDamageOver30Sec() / 30.0f;
            float emp = beam.getWeapon().getDerivedStats().getEmpPerSecond();
            accumulator += (dps + emp) * damageWindowSeconds;
        }
        return accumulator;
    }

    public static float estimateIncomingMissileDamage(ShipAPI ship) {
        float accumulator = 0.0f;
        for (DamagingProjectileAPI missile : Global.getCombatEngine().getMissiles()) {
            if (missile.getOwner() == ship.getOwner()) continue;
            float safeDistance = 600.0f + ship.getCollisionRadius();
            float threat = missile.getDamageAmount() + missile.getEmpAmount();
            if (ship.getShield() != null && ship.getShield().isWithinArc(missile.getLocation())) continue;
            accumulator = (float)((double)accumulator + (double)threat * Math.max(0.0, Math.min(1.0, Math.pow(1.0f - MathUtils.getDistance((CombatEntityAPI)missile, (CombatEntityAPI)ship) / safeDistance, 2.0))));
        }
        return accumulator;
    }

    public static float getActualDistance(Vector2f from, CombatEntityAPI target, boolean considerShield) {
        ShipAPI ship;
        ShieldAPI shield;
        if (considerShield && target instanceof ShipAPI && (shield = (ship = (ShipAPI)target).getShield()) != null && shield.isOn() && shield.isWithinArc(from)) {
            return MathUtils.getDistance((Vector2f)from, (Vector2f)shield.getLocation()) - shield.getRadius();
        }
        return MathUtils.getDistance((Vector2f)from, (Vector2f)target.getLocation()) - Misc.getTargetingRadius((Vector2f)from, (CombatEntityAPI)target, (boolean)false);
    }

    public static List<ShipAPI> getSortedAreaList(Vector2f loc, List<ShipAPI> list) {
        ArrayList<Object> out;
        if (ShadowyardsModPlugin.hasTwigLib) {
            ArrayList<ShipAPI> temp = new ArrayList<ShipAPI>(list);
            Collections.sort(temp, new SortShipsByDistance(loc));
            out = new ArrayList(list.size());
            while (temp.size() > 0) {
                ShipAPI ship = (ShipAPI)temp.get(0);
                if (TwigUtils.isMultiShip((ShipAPI)ship)) {
                    out.add(ship);
                    TwigUtils.filterConnections((ShipAPI)ship, temp);
                    continue;
                }
                out.add(ship);
                temp.remove(0);
            }
        } else {
            out = new ArrayList<ShipAPI>(list);
            Collections.sort(out, new SortShipsByDistance(loc));
        }
        return out;
    }

    private static class SortShipsByDistance
    implements Comparator<ShipAPI> {
        private final Vector2f loc;

        SortShipsByDistance(Vector2f loc) {
            this.loc = loc;
        }

        @Override
        public int compare(ShipAPI s1, ShipAPI s2) {
            float dist2;
            float dist1;
            if (s1.getShield() != null && s1.getShield().isOn() && s1.getShield().isWithinArc(this.loc)) {
                dist1 = MathUtils.getDistance((Vector2f)s1.getLocation(), (Vector2f)this.loc) - s1.getShield().getRadius();
                dist1 *= dist1;
            } else {
                dist1 = MathUtils.getDistanceSquared((Vector2f)s1.getLocation(), (Vector2f)this.loc);
            }
            if (s2.getShield() != null && s2.getShield().isOn() && s2.getShield().isWithinArc(this.loc)) {
                dist2 = MathUtils.getDistance((Vector2f)s2.getLocation(), (Vector2f)this.loc) - s2.getShield().getRadius();
                dist2 *= dist1;
            } else {
                dist2 = MathUtils.getDistanceSquared((Vector2f)s2.getLocation(), (Vector2f)this.loc);
            }
            return Float.compare(dist1, dist2);
        }
    }
}

