/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_effectsHook
extends BaseEveryFrameCombatPlugin {
    private static final float CONCUSSION_SHOCKWAVE_DURATION = 0.25f;
    private static final float CONCUSSION_SHOCKWAVE_MAX_SCALE = 1.5f;
    private static final float CONCUSSION_SHOCKWAVE_MIN_SCALE = 0.25f;
    private static final String DATA_KEY = "MS_effectsHook";
    private static final float FLAK_SHOCKWAVE_DURATION = 0.2f;
    private static final float FLAK_SHOCKWAVE_MAX_SCALE = 0.8f;
    private static final float FLAK_SHOCKWAVE_MIN_SCALE = 0.15f;
    private static final float GAP_DURATION = 0.2f;
    private static final float GAP_MAX_SCALE = 0.8f;
    private static final float GAP_MIN_SCALE = 0.15f;
    private static final float PING_DURATION = 3.0f;
    private static final float PING_MAX_SCALE = 3.5f;
    private static final float PING_MIN_SCALE = 0.75f;
    private static final float PULSE_DURATION = 1.25f;
    private static final float PULSE_MAX_SCALE = 2.5f;
    private static final float PULSE_MIN_SCALE = 0.5f;
    private static final int SHOCKWAVE_SIZE = 256;
    private CombatEngineAPI engine;

    public static void createFlakShockwave(Vector2f location) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }
        List<Shockwave> shockwaves = localData.shockwaves;
        shockwaves.add(new Shockwave(location, 0.2f, 0.8f, 0.15f));
    }

    public static void createShockwave(Vector2f location) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }
        List<Shockwave> shockwaves = localData.shockwaves;
        shockwaves.add(new Shockwave(location, 0.25f, 1.5f, 0.25f));
    }

    public static void createPing(Vector2f location, Vector2f velocity) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }
        List<tagPing> pings = localData.pings;
        pings.add(new tagPing(location, velocity, 3.0f, 3.5f, 0.75f));
    }

    public static void createPulse(Vector2f location) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }
        List<swacsPulse> pulses = localData.pulses;
        pulses.add(new swacsPulse(location, 1.25f, 2.5f, 0.5f));
    }

    public static void createRift(Vector2f location) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }
        List<Rift> rifts = localData.rifts;
        rifts.add(new Rift(location, 0.2f, 0.8f, 0.15f));
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        List<Shockwave> shockwaves = localData.shockwaves;
        Iterator<Shockwave> iter = shockwaves.iterator();
        while (iter.hasNext()) {
            Shockwave wave = iter.next();
            wave.lifespan -= amount;
            if (wave.lifespan <= 0.0f) {
                iter.remove();
                continue;
            }
            wave.alpha = wave.lifespan / wave.maxLifespan;
            wave.scale = wave.minScale + (wave.maxLifespan - wave.lifespan) / wave.maxLifespan * (wave.maxScale - wave.minScale);
        }
        List<tagPing> pings = localData.pings;
        Iterator<tagPing> iterB = pings.iterator();
        while (iterB.hasNext()) {
            tagPing ping = iterB.next();
            ping.lifespan -= amount;
            if (ping.lifespan <= 0.0f) {
                iterB.remove();
                continue;
            }
            ping.alpha = ping.lifespan / ping.maxLifespan;
            ping.scale = ping.minScale + (ping.maxLifespan - ping.lifespan) / ping.maxLifespan * (ping.maxScale - ping.minScale);
        }
        List<swacsPulse> pulses = localData.pulses;
        Iterator<swacsPulse> iterC = pulses.iterator();
        while (iterC.hasNext()) {
            swacsPulse pulse = iterC.next();
            pulse.lifespan -= amount;
            if (pulse.lifespan <= 0.0f) {
                iterC.remove();
                continue;
            }
            pulse.alpha = pulse.lifespan / pulse.maxLifespan;
            pulse.scale = pulse.minScale + (pulse.maxLifespan - pulse.lifespan) / pulse.maxLifespan * (pulse.maxScale - pulse.minScale);
        }
        List<Rift> rifts = localData.rifts;
        Iterator<Rift> iterD = rifts.iterator();
        while (iterD.hasNext()) {
            Rift rift = iterD.next();
            rift.lifespan -= amount;
            if (rift.lifespan <= 0.0f) {
                iterD.remove();
                continue;
            }
            rift.alpha = rift.lifespan / rift.maxLifespan;
            rift.scale = rift.maxScale - (rift.maxLifespan - rift.lifespan) / rift.maxLifespan * (rift.maxScale - rift.minScale);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        engine.getCustomData().put(DATA_KEY, new LocalData());
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
        SpriteAPI waveSprite;
        if (this.engine == null) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        List<Shockwave> shockwaves = localData.shockwaves;
        List<tagPing> pings = localData.pings;
        List<swacsPulse> pulses = localData.pulses;
        List<Rift> rifts = localData.rifts;
        for (Shockwave wave : shockwaves) {
            waveSprite = Global.getSettings().getSprite("concussion", "flareFlakWave");
            if (waveSprite == null) continue;
            waveSprite.setAlphaMult(wave.alpha);
            waveSprite.setAdditiveBlend();
            waveSprite.setAngle(wave.facing);
            waveSprite.setSize(wave.scale * 256.0f, wave.scale * 256.0f);
            waveSprite.renderAtCenter(wave.location.x, wave.location.y);
        }
        for (tagPing ping : pings) {
            waveSprite = Global.getSettings().getSprite("ping", "tagPing");
            if (waveSprite == null) continue;
            waveSprite.setAlphaMult(ping.alpha);
            waveSprite.setAdditiveBlend();
            waveSprite.setAngle(ping.facing);
            waveSprite.setSize(ping.scale * 256.0f, ping.scale * 256.0f);
            waveSprite.renderAtCenter(ping.location.x, ping.location.y);
        }
        for (swacsPulse pulse : pulses) {
            waveSprite = Global.getSettings().getSprite("ping", "swacsPing");
            if (waveSprite == null) continue;
            waveSprite.setAlphaMult(pulse.alpha);
            waveSprite.setAdditiveBlend();
            waveSprite.setAngle(pulse.facing);
            waveSprite.setSize(pulse.scale * 256.0f, pulse.scale * 256.0f);
            waveSprite.renderAtCenter(pulse.location.x, pulse.location.y);
        }
        for (Rift rift : rifts) {
            SpriteAPI eventHorizonSprite = Global.getSettings().getSprite("misc", "ms_eventHorizon");
            SpriteAPI gapSprite = Global.getSettings().getSprite("misc", "ms_phaseSpaceRift" + MathUtils.getRandomNumberInRange((int)1, (int)5));
            SpriteAPI flareSprite = Global.getSettings().getSprite("flare", "nidhoggr_ALF");
            if (eventHorizonSprite != null) {
                eventHorizonSprite.setAlphaMult(rift.alpha);
                eventHorizonSprite.setAdditiveBlend();
                eventHorizonSprite.setAngle(rift.facing);
                eventHorizonSprite.setSize(150.0f, 150.0f);
                eventHorizonSprite.renderAtCenter(rift.location.x, rift.location.y);
            }
            if (gapSprite != null) {
                gapSprite.setAlphaMult(0.8f);
                gapSprite.setAdditiveBlend();
                gapSprite.setAngle(rift.facing);
                gapSprite.setSize(rift.scale * 256.0f, rift.scale * 256.0f);
                gapSprite.renderAtCenter(rift.location.x, rift.location.y);
            }
            if (flareSprite == null) continue;
            flareSprite.setAlphaMult(rift.alpha);
            flareSprite.setAdditiveBlend();
            flareSprite.setAngle(0.0f);
            flareSprite.renderAtCenter(rift.location.x, rift.location.y);
        }
    }

    static class Rift {
        float alpha;
        final float facing;
        float lifespan;
        final Vector2f location;
        float maxLifespan;
        float maxScale;
        float minScale;
        float scale;

        Rift(Vector2f location, float duration, float maxScale, float minScale) {
            this.location = new Vector2f((ReadableVector2f)location);
            this.alpha = 1.0f;
            this.facing = (float)Math.random() * 360.0f;
            this.lifespan = this.maxLifespan = duration;
            this.maxScale = maxScale;
            this.minScale = minScale;
            this.scale = minScale;
        }
    }

    static class swacsPulse {
        float alpha;
        final float facing;
        float lifespan;
        final Vector2f location;
        float maxLifespan;
        float maxScale;
        float minScale;
        float scale;

        swacsPulse(Vector2f location, float duration, float maxScale, float minScale) {
            this.location = new Vector2f((ReadableVector2f)location);
            this.alpha = 1.0f;
            this.facing = (float)Math.random() * 360.0f;
            this.lifespan = this.maxLifespan = duration;
            this.maxScale = maxScale;
            this.minScale = minScale;
            this.scale = minScale;
        }
    }

    static class tagPing {
        float alpha;
        final float facing;
        float lifespan;
        final Vector2f location;
        final Vector2f velocity;
        float maxLifespan;
        float maxScale;
        float minScale;
        float scale;

        tagPing(Vector2f location, Vector2f velocity, float duration, float maxScale, float minScale) {
            this.location = new Vector2f((ReadableVector2f)location);
            this.velocity = new Vector2f((ReadableVector2f)velocity);
            this.alpha = 1.0f;
            this.facing = (float)Math.random() * 360.0f;
            this.lifespan = this.maxLifespan = duration;
            this.maxScale = maxScale;
            this.minScale = minScale;
            this.scale = minScale;
        }
    }

    static class Shockwave {
        float alpha;
        final float facing;
        float lifespan;
        final Vector2f location;
        float maxLifespan;
        float maxScale;
        float minScale;
        float scale;

        Shockwave(Vector2f location, float duration, float maxScale, float minScale) {
            this.location = new Vector2f((ReadableVector2f)location);
            this.alpha = 1.0f;
            this.facing = (float)Math.random() * 360.0f;
            this.lifespan = this.maxLifespan = duration;
            this.maxScale = maxScale;
            this.minScale = minScale;
            this.scale = minScale;
        }
    }

    private static final class LocalData {
        final List<Shockwave> shockwaves = new LinkedList<Shockwave>();
        final List<tagPing> pings = new LinkedList<tagPing>();
        final List<swacsPulse> pulses = new LinkedList<swacsPulse>();
        final List<Rift> rifts = new LinkedList<Rift>();

        private LocalData() {
        }
    }
}

