/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.AnimationAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_MimirAnimateMainSequence
implements EveryFrameWeaponEffectPlugin {
    private WeaponAPI theWeapon;
    private WeaponAPI theMuzzle;
    private AnimationAPI theCharge;
    private AnimationAPI theSparkles;
    private AnimationAPI theHeat;
    private AnimationAPI theFlash;
    private ShipAPI ship;
    private final List<WeaponAPI> theFlare = new ArrayList<WeaponAPI>();
    private final IntervalUtil anim = new IntervalUtil(0.03f, 0.03f);
    private int frameC = 0;
    private int maxFrameC = 0;
    private int frameZ = 0;
    private int maxFrameZ = 0;
    private int frameM = 0;
    private int maxFrameM = 0;
    private float heat;
    private float charge;
    private float lastCharge = 0.0f;
    private float pFacing = 0.0f;
    private static final float CHARGEDOWN_RATIO = 10.0f;
    private static final float COOLING_RATIO = 0.25f;
    private boolean runOnce = false;
    private boolean fired = false;
    private boolean firing = false;
    private boolean chargeUp = false;
    private boolean chargeDown = false;
    private boolean reset = true;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (engine.isPaused()) {
            return;
        }
        if (!this.runOnce || this.ship == null) {
            this.runOnce = true;
            this.theFlare.clear();
            this.ship = weapon.getShip();
            for (WeaponAPI w : this.ship.getAllWeapons()) {
                switch (w.getSlot().getId()) {
                    case "MAIN": {
                        this.theWeapon = w;
                        break;
                    }
                    case "CHARGE": {
                        this.theCharge = w.getAnimation();
                        this.maxFrameC = this.theCharge.getNumFrames() - 1;
                        break;
                    }
                    case "HEAT": {
                        w.getAnimation().setFrame(1);
                        this.theHeat = w.getAnimation();
                        this.theHeat.setAlphaMult(0.0f);
                        break;
                    }
                    case "ZAP": {
                        this.theSparkles = w.getAnimation();
                        this.maxFrameZ = this.theSparkles.getNumFrames();
                        break;
                    }
                    case "MUZZLE": {
                        this.theMuzzle = w;
                        this.theFlash = w.getAnimation();
                        this.maxFrameM = this.theFlash.getNumFrames();
                    }
                }
            }
            return;
        }
        float newCharge = weapon.getChargeLevel();
        if (newCharge > 0.0f || this.firing) {
            this.anim.advance(amount);
            if (newCharge > this.lastCharge) {
                this.firing = true;
                this.chargeUp = true;
                this.chargeDown = false;
                if (this.reset) {
                    this.reset = false;
                    this.charge = 1.0f;
                    this.frameC = 0;
                    this.frameZ = 0;
                }
            } else {
                this.chargeUp = false;
                this.chargeDown = true;
                this.reset = true;
            }
            this.lastCharge = newCharge;
            if (newCharge == 0.0f && this.heat == 0.0f && this.charge == 0.0f) {
                this.firing = false;
            }
            if (this.frameZ != 0 && this.anim.intervalElapsed()) {
                ++this.frameZ;
                if (this.frameZ == this.maxFrameZ) {
                    this.frameZ = 0;
                }
            }
            this.heat = Math.max(this.heat - amount * 0.25f, 0.0f);
            if (this.chargeDown && this.charge > 0.0f) {
                this.charge = Math.min(1.0f, Math.max(0.0f, this.charge - this.charge * amount * 10.0f + ((float)Math.random() - 0.5f) / 20.0f));
            }
            if (this.chargeUp && this.frameC != this.maxFrameC && this.anim.intervalElapsed()) {
                this.charge = 1.0f;
                ++this.frameC;
            }
            if (newCharge == 1.0f && this.theWeapon.getAmmo() == 0) {
                this.fired = true;
                this.heat = 1.0f;
                this.frameZ = 1;
                engine.addSmoothParticle(this.theWeapon.getLocation(), this.ship.getVelocity(), (float)MathUtils.getRandomNumberInRange((int)125, (int)150), 0.25f, 1.0f, new Color(50, 255, 100));
                engine.addHitParticle(this.theWeapon.getLocation(), this.ship.getVelocity(), (float)MathUtils.getRandomNumberInRange((int)50, (int)75), 1.0f, 0.1f, new Color(200, 255, 200));
                for (DamagingProjectileAPI p : engine.getProjectiles()) {
                    if (p.getWeapon() != weapon) continue;
                    this.pFacing = p.getFacing();
                    engine.removeEntity((CombatEntityAPI)p);
                    break;
                }
                Vector2f muzzle_location = new Vector2f((ReadableVector2f)this.theWeapon.getLocation());
                Vector2f ship_velocity = new Vector2f((ReadableVector2f)this.theWeapon.getShip().getVelocity());
                engine.spawnProjectile(this.ship, weapon, "ms_rhpbc_replacement", muzzle_location, this.pFacing, ship_velocity);
            }
            if ((this.fired || this.frameM != 0) && this.anim.intervalElapsed()) {
                this.fired = false;
                ++this.frameM;
                if (this.frameM == this.maxFrameM) {
                    this.frameM = 0;
                }
            }
            this.theCharge.setFrame(this.frameC);
            this.theCharge.setAlphaMult(this.charge);
            this.theFlash.setFrame(this.frameM);
            this.theHeat.setAlphaMult(this.heat);
            this.theHeat.setFrame(1);
            this.theSparkles.setFrame(this.frameZ);
        }
    }
}

