/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_MurtiSoundPlugin
implements EveryFrameWeaponEffectPlugin {
    private static final Color CHARGEUP_PARTICLE_COLOR = new Color(130, 190, 160, 100);
    private static final float CHARGEUP_PARTICLE_DISTANCE_MIN = 4.0f;
    private static final float CHARGEUP_PARTICLE_DISTANCE_MAX = 60.0f;
    private static final float CHARGEUP_PARTICLE_SIZE_MIN = 1.0f;
    private static final float CHARGEUP_PARTICLE_SIZE_MAX = 4.0f;
    private static final float CHARGEUP_PARTICLE_ANGLE_SPREAD = 180.0f;
    private static final float CHARGEUP_PARTICLE_DURATION = 0.2f;
    private static final float CHARGEUP_PARTICLE_COUNT_FACTOR = 5.0f;
    private static final float CHARGEUP_PARTICLE_BRIGHTNESS = 0.7f;
    private static final Vector2f ZERO = new Vector2f();
    public static final float MAX_OFFSET = 10.0f;
    public static final float SWEEP_INTERVAL = 0.95f;
    private List<Float> ANGLES = new ArrayList<Float>();
    protected float currOffset = 0.0f;
    protected float timer = 0.0f;
    protected int dir = 1;
    private float last_charge_level = 0.0f;
    private boolean charging = false;
    private boolean firing = false;
    private boolean restart = true;
    private boolean runOnce = false;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        int i;
        if (engine.isPaused()) {
            return;
        }
        Vector2f point1 = new Vector2f((ReadableVector2f)weapon.getLocation());
        Vector2f offset1 = new Vector2f();
        if (weapon.getSlot().isTurret()) {
            offset1 = new Vector2f(17.0f, 9.0f);
        } else if (weapon.getSlot().isHardpoint()) {
            offset1 = new Vector2f(20.0f, 9.0f);
        }
        VectorUtils.rotate((Vector2f)offset1, (float)weapon.getCurrAngle(), (Vector2f)offset1);
        Vector2f.add((Vector2f)offset1, (Vector2f)point1, (Vector2f)point1);
        Vector2f point2 = new Vector2f((ReadableVector2f)weapon.getLocation());
        Vector2f offset2 = new Vector2f();
        if (weapon.getSlot().isTurret()) {
            offset2 = new Vector2f(17.0f, -9.0f);
        } else if (weapon.getSlot().isHardpoint()) {
            offset2 = new Vector2f(20.0f, -9.0f);
        }
        VectorUtils.rotate((Vector2f)offset2, (float)weapon.getCurrAngle(), (Vector2f)offset2);
        Vector2f.add((Vector2f)offset2, (Vector2f)point2, (Vector2f)point2);
        float charge_level = weapon.getChargeLevel();
        if (!this.runOnce) {
            this.runOnce = true;
            this.ANGLES = new ArrayList<Float>(weapon.getSpec().getTurretAngleOffsets());
            weapon.ensureClonedSpec();
        }
        if (this.restart) {
            for (i = 0; i < weapon.getSpec().getTurretAngleOffsets().size(); ++i) {
                weapon.getSpec().getHardpointAngleOffsets().set(i, this.ANGLES.get(i));
                weapon.getSpec().getTurretAngleOffsets().set(i, this.ANGLES.get(i));
                weapon.getSpec().getHiddenAngleOffsets().set(i, this.ANGLES.get(i));
            }
        }
        if (weapon.getChargeLevel() >= 0.99f) {
            this.restart = false;
            this.timer += amount * 0.95f;
            for (i = 0; i < weapon.getSpec().getTurretAngleOffsets().size(); ++i) {
                weapon.getSpec().getHardpointAngleOffsets().set(i, Float.valueOf((float)(-1 + 2 * i) * 10.0f * -1.0f * (float)FastTrig.cos((double)this.timer)));
                weapon.getSpec().getTurretAngleOffsets().set(i, Float.valueOf((float)(-1 + 2 * i) * 10.0f * -1.0f * (float)FastTrig.cos((double)this.timer)));
                weapon.getSpec().getHiddenAngleOffsets().set(i, Float.valueOf((float)(-1 + 2 * i) * 10.0f * -1.0f * (float)FastTrig.cos((double)this.timer)));
            }
        } else if (!this.restart) {
            this.timer = 0.0f;
            this.restart = true;
        }
        if (this.charging) {
            if (this.firing && weapon.getCooldownRemaining() <= 0.0f && weapon.getChargeLevel() < 1.0f) {
                this.charging = false;
                this.firing = false;
            } else if (weapon.getChargeLevel() < 1.0f && weapon.getCooldownRemaining() <= 0.0f) {
                if (charge_level > this.last_charge_level && charge_level > this.last_charge_level && weapon.isFiring()) {
                    int particle_count = (int)(5.0f * charge_level);
                    for (int i2 = 0; i2 < particle_count; ++i2) {
                        float distance = MathUtils.getRandomNumberInRange((float)4.0f, (float)60.0f);
                        float size = MathUtils.getRandomNumberInRange((float)1.0f, (float)4.0f);
                        float angle = MathUtils.getRandomNumberInRange((float)-90.0f, (float)90.0f);
                        Vector2f spawn_location1 = MathUtils.getPointOnCircumference((Vector2f)point1, (float)distance, (float)(angle + weapon.getCurrAngle()));
                        Vector2f spawn_location2 = MathUtils.getPointOnCircumference((Vector2f)point2, (float)distance, (float)(angle + weapon.getCurrAngle() + 45.0f));
                        float speed = distance / 0.2f;
                        Vector2f particle_velocity = MathUtils.getPointOnCircumference((Vector2f)weapon.getShip().getVelocity(), (float)speed, (float)(180.0f + angle + weapon.getCurrAngle()));
                        engine.addHitParticle(spawn_location1, particle_velocity, size, 0.7f, 0.2f, CHARGEUP_PARTICLE_COLOR);
                        engine.addHitParticle(spawn_location2, particle_velocity, size, 0.7f, 0.2f, CHARGEUP_PARTICLE_COLOR);
                    }
                }
            } else {
                this.firing = true;
                this.restart = false;
                if (weapon.isFiring()) {
                    Global.getCombatEngine().addHitParticle(point1, ZERO, (float)Math.random() * 8.0f + 8.0f * weapon.getChargeLevel(), weapon.getChargeLevel() * 0.3f, 0.2f, new Color(MathUtils.getRandomNumberInRange((int)200, (int)255), MathUtils.getRandomNumberInRange((int)150, (int)200), MathUtils.getRandomNumberInRange((int)50, (int)150), 255));
                    Global.getCombatEngine().addHitParticle(point2, ZERO, (float)Math.random() * 8.0f + 8.0f * weapon.getChargeLevel(), weapon.getChargeLevel() * 0.3f, 0.2f, new Color(MathUtils.getRandomNumberInRange((int)200, (int)255), MathUtils.getRandomNumberInRange((int)150, (int)200), MathUtils.getRandomNumberInRange((int)50, (int)150), 255));
                }
            }
        } else if (weapon.getChargeLevel() > 0.0f && weapon.getCooldownRemaining() <= 0.0f) {
            this.charging = true;
            Global.getSoundPlayer().playSound("ms_slowBeamH_charge", 1.0f, 1.0f, point1, weapon.getShip().getVelocity());
        }
        this.last_charge_level = charge_level;
    }
}

