/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_PandoraEmitter
implements EveryFrameWeaponEffectPlugin {
    private static final String WEAPON_ID = "ms_pandora";
    private static final String TARGET_ID = "ms_pandoraEmitterTarg";
    private static final float EMITTER_THICKNESS = 8.0f;
    private static final Color EMITTER_FRINGE = new Color(125, 155, 115, 150);
    private static final Color EMITTER_CORE = new Color(165, 215, 145, 255);
    private boolean hasChecked = false;
    private boolean hasEye = false;
    private WeaponAPI firingEye = null;
    private WeaponAPI closestEye = null;
    private FollowWeaponCombatEntity eyeFollower = null;
    private CombatEntityAPI activeArc = null;

    public boolean checkForSeeingEye(WeaponAPI emitter) {
        ShipAPI ship = emitter.getShip();
        List weapons = ship.getAllWeapons();
        float closestDistance = Float.MAX_VALUE;
        for (WeaponAPI weapon : weapons) {
            if (TARGET_ID.equals(weapon.getId()) && (this.closestEye == null || MathUtils.getDistanceSquared((Vector2f)weapon.getLocation(), (Vector2f)emitter.getLocation()) < closestDistance)) {
                this.closestEye = weapon;
                closestDistance = MathUtils.getDistanceSquared((Vector2f)emitter.getLocation(), (Vector2f)weapon.getLocation());
            }
            if (!WEAPON_ID.equals(weapon.getId()) || this.firingEye != null) continue;
            this.firingEye = weapon;
        }
        if (this.closestEye != null && this.firingEye != null) {
            this.eyeFollower = new FollowWeaponCombatEntity(this.closestEye);
            return true;
        }
        return false;
    }

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (!this.hasChecked) {
            this.hasEye = this.checkForSeeingEye(weapon);
            this.hasChecked = true;
        }
        if (!this.hasEye || engine.isPaused() || this.activeArc != null && engine.isEntityInPlay(this.activeArc)) {
            return;
        }
        if (this.firingEye.isFiring() && (double)this.firingEye.getChargeLevel() <= 5.5) {
            this.activeArc = engine.spawnEmpArc(weapon.getShip(), weapon.getLocation(), (CombatEntityAPI)weapon.getShip(), (CombatEntityAPI)this.eyeFollower, DamageType.OTHER, 0.0f, 0.0f, 5000.0f, null, 8.0f, EMITTER_FRINGE, EMITTER_CORE);
        }
    }

    public static class FollowWeaponCombatEntity
    implements CombatEntityAPI {
        private final WeaponAPI weapon;

        public FollowWeaponCombatEntity(WeaponAPI weapon) {
            this.weapon = weapon;
        }

        public Vector2f getLocation() {
            return this.weapon.getLocation();
        }

        public Vector2f getVelocity() {
            return null;
        }

        public float getFacing() {
            return this.weapon.getArcFacing();
        }

        public void setFacing(float facing) {
        }

        public float getAngularVelocity() {
            return 0.0f;
        }

        public void setAngularVelocity(float angVel) {
        }

        public int getOwner() {
            return this.weapon.getShip().getOwner();
        }

        public void setOwner(int owner) {
        }

        public float getCollisionRadius() {
            return 0.0f;
        }

        public CollisionClass getCollisionClass() {
            return null;
        }

        public void setCollisionClass(CollisionClass collisionClass) {
        }

        public float getMass() {
            return 0.0f;
        }

        public void setMass(float mass) {
        }

        public BoundsAPI getExactBounds() {
            return null;
        }

        public ShieldAPI getShield() {
            return null;
        }

        public float getHullLevel() {
            return 0.0f;
        }

        public float getHitpoints() {
            return 0.0f;
        }

        public float getMaxHitpoints() {
            return 0.0f;
        }

        public void setCollisionRadius(float f) {
        }
    }
}

