/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_WavebeamOnHitEffect
implements OnHitEffectPlugin {
    private static final String SOUND_ID = "disabled_large_crit";
    private static final DamageType[] TYPES = new DamageType[]{DamageType.ENERGY};
    private static final float EXTRA_DAMAGE_CHANCE = 0.3f;
    private static final Color EXPLOSION_COLOR = new Color(125, 155, 115, 255);
    private static final Color PARTICLE_COLOR = new Color(125, 155, 115, 255);
    private static final int NUM_PARTICLES = 14;
    private static final float MIN_EXTRA_DAMAGE = 200.0f;
    private static final float MAX_EXTRA_DAMAGE = 300.0f;

    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, CombatEngineAPI engine) {
        if (target instanceof ShipAPI && !shieldHit && Math.random() <= (double)0.3f) {
            engine.applyDamage(target, point, MathUtils.getRandomNumberInRange((float)200.0f, (float)300.0f), TYPES[(int)(Math.random() * (double)TYPES.length)], 0.0f, false, true, (Object)projectile.getSource());
            engine.spawnExplosion(point, (Vector2f)new Vector2f((ReadableVector2f)target.getVelocity()).scale(0.48f), EXPLOSION_COLOR, 39.0f, 1.0f);
            float speed = projectile.getVelocity().length();
            float facing = 400.0f;
            for (int x = 0; x < 14; ++x) {
                engine.addHitParticle(point, MathUtils.getPointOnCircumference(null, (float)MathUtils.getRandomNumberInRange((float)(speed * 0.007f), (float)(speed * 0.17f)), (float)MathUtils.getRandomNumberInRange((float)(facing - 180.0f), (float)(facing + 180.0f))), 5.0f, 1.0f, 1.6f, PARTICLE_COLOR);
            }
            Global.getSoundPlayer().playSound(SOUND_ID, 1.1f, 0.5f, target.getLocation(), target.getVelocity());
        }
    }
}

