/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_thrustPlugin
implements EveryFrameWeaponEffectPlugin {
    private float target = 0.0f;
    private boolean runOnce = false;
    private static ShipAPI ship;
    private static ShipEngineControllerAPI engines;
    private static ShipEngineControllerAPI.ShipEngineAPI bindEngine;
    private static ShipSystemAPI shipSystem;
    private static int shipSystemAccDir;
    private static int shipSystemAcc;
    private float checkDrive = 25.0f;
    private final float tinX = 6.0f;
    private final float smallX = 10.0f;
    private final float midX = 18.0f;
    private final float bigX = 26.0f;
    private float throttle = 100.0f;
    private float lengthMult;
    private final float widthMult = 1.25f;
    float maxOutput;
    float aim;
    private final Color NoColor = new Color(0, 0, 0, 0);
    private Color NormalColor = new Color(255, 185, 155, 255);
    private static final Map<ShipAPI.HullSize, Float> tinY;
    private static final Map<ShipAPI.HullSize, Float> smallY;
    private static final Map<ShipAPI.HullSize, Float> midY;
    private static final Map<ShipAPI.HullSize, Float> bigY;
    private static final Set<String> accShipSystems;
    private static final Set<String> accBackShipSystems;
    private final Map<Integer, SpriteAPI> THRUST = new HashMap<Integer, SpriteAPI>();

    public MS_thrustPlugin() {
        this.THRUST.put(1, Global.getSettings().getSprite("thrusts", "SRA_Vectored_Thrust01"));
        this.THRUST.put(2, Global.getSettings().getSprite("thrusts", "SRA_Vectored_Thrust02"));
        this.THRUST.put(3, Global.getSettings().getSprite("thrusts", "SRA_Vectored_Thrust03"));
    }

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        SpriteAPI theSprite = weapon.getSprite();
        if (engine.isPaused()) {
            return;
        }
        if (!this.runOnce) {
            ship = weapon.getShip();
            engines = ship.getEngineController();
            List shipEngines = ship.getEngineController().getShipEngines();
            for (ShipEngineControllerAPI.ShipEngineAPI shipEngine : shipEngines) {
                Vector2f shipEngineLocation = shipEngine.getLocation();
                float distanceSq = MathUtils.getDistanceSquared((Vector2f)shipEngineLocation, (Vector2f)weapon.getLocation());
                if (!(distanceSq <= this.checkDrive)) continue;
                bindEngine = shipEngine;
                this.checkDrive = distanceSq;
            }
            shipSystem = ship.getSystem();
            if (shipSystem != null) {
                if (accShipSystems.contains(ship.getSystem().getId())) {
                    shipSystemAccDir = 1;
                }
                if (accBackShipSystems.contains(ship.getSystem().getId())) {
                    shipSystemAccDir = -1;
                }
            }
            if (ship.getVariant().getHullMods().contains("safetyoverrides")) {
                this.NormalColor = new Color(255, 200, 225, 255);
            }
            this.runOnce = true;
        }
        float maxThrottleDelta = 0.85f;
        float maxReturnToIdleDelta = 2.0f;
        float idleThrottle = 26.5f;
        shipSystemAcc = shipSystemAccDir != 0 && shipSystem.isActive() ? shipSystemAccDir : 0;
        if (ship.getTravelDrive().isActive()) {
            shipSystemAcc = 1;
        }
        if (bindEngine.isDisabled() || !ship.isAlive()) {
            float angle = weapon.getCurrAngle();
            weapon.setCurrAngle(angle);
            if (weapon.getSlot().getId().contains("THRUST")) {
                theSprite.setColor(this.NoColor);
            }
        } else if (!bindEngine.isDisabled()) {
            theSprite.setColor(this.NormalColor);
            float angle = weapon.getCurrAngle();
            float arcFacing = weapon.getArcFacing();
            float arc = weapon.getArc();
            float shipFacing = ship.getFacing();
            if (!engine.isPaused() && weapon.getSlot().getId().contains("THRUST") && Math.random() > (double)0.1f) {
                weapon.getAnimation().setFrame(MathUtils.getRandomNumberInRange((int)1, (int)3));
            }
            if (weapon.getSlot().getId().contains("MAIN_CL")) {
                if (!(!engines.isAccelerating() || !engines.isStrafingLeft() && !engines.isTurningRight() || engines.isAcceleratingBackwards() && engines.isDecelerating() && engines.isStrafingRight() && engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.75f;
                        if (this.throttle < 75.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (!(!engines.isAccelerating() || !engines.isStrafingRight() && !engines.isTurningLeft() || engines.isAcceleratingBackwards() && engines.isDecelerating() && engines.isStrafingLeft() && engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.75f;
                        if (this.throttle < 75.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (!((!engines.isAccelerating() || engines.isStrafingRight() && engines.isStrafingRight() && engines.isStrafingLeft() && engines.isTurningLeft() && engines.isAcceleratingBackwards() && engines.isDecelerating()) && shipSystemAcc != 1)) {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.9f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("MAIN_STBD")) {
                if (!engines.isAccelerating() && (engines.isStrafingLeft() || engines.isTurningRight()) || (engines.isDecelerating() || engines.isAcceleratingBackwards()) && (engines.isStrafingLeft() || engines.isTurningRight() || engines.isStrafingLeft() && engines.isTurningRight())) {
                    this.aim = shipFacing - 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (engines.isStrafingLeft() || engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() || shipSystemAcc == 1) {
                    this.aim = shipFacing + arcFacing - arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("MAIN_PORT")) {
                if (!engines.isAccelerating() && (engines.isStrafingRight() || engines.isTurningLeft()) || (engines.isDecelerating() || engines.isAcceleratingBackwards()) && (engines.isStrafingRight() || engines.isTurningLeft() || engines.isStrafingRight() && engines.isTurningLeft())) {
                    this.aim = shipFacing + 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (engines.isStrafingRight() || engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() || shipSystemAcc == 1) {
                    this.aim = shipFacing + arcFacing + arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("RETRO_CL")) {
                if (!(!engines.isAcceleratingBackwards() && !engines.isDecelerating() || !engines.isStrafingLeft() && !engines.isTurningRight() || engines.isAccelerating() && engines.isStrafingRight() && engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.75f;
                        if (this.throttle < 75.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (!(!engines.isAcceleratingBackwards() && !engines.isDecelerating() || !engines.isStrafingRight() && !engines.isTurningLeft() || engines.isAccelerating() && engines.isStrafingLeft() && engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.75f;
                        if (this.throttle < 75.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (!((!engines.isAcceleratingBackwards() && !engines.isDecelerating() || engines.isStrafingRight() && engines.isStrafingRight() && engines.isStrafingLeft() && engines.isTurningLeft() && engines.isAccelerating()) && shipSystemAcc != -1)) {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.9f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("RETRO_STBD")) {
                if ((!engines.isAcceleratingBackwards() || !engines.isDecelerating()) && (engines.isStrafingLeft() || engines.isTurningLeft()) || engines.isAccelerating() && (engines.isStrafingLeft() || engines.isTurningLeft() || engines.isStrafingLeft() && engines.isTurningLeft())) {
                    this.aim = shipFacing - 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (engines.isStrafingLeft() || engines.isTurningLeft() || engines.isStrafingLeft() && engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (!engines.isStrafingLeft() || !engines.isTurningLeft()) || shipSystemAcc == -1) {
                    this.aim = shipFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("RETRO_PORT")) {
                if ((!engines.isAcceleratingBackwards() || !engines.isDecelerating()) && (engines.isStrafingRight() || engines.isTurningRight()) || engines.isAccelerating() && (engines.isStrafingRight() || engines.isTurningRight() || engines.isStrafingRight() && engines.isTurningRight())) {
                    this.aim = shipFacing + 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (engines.isStrafingRight() || engines.isTurningRight() || engines.isStrafingRight() && engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (!engines.isStrafingRight() || !engines.isTurningRight()) || shipSystemAcc == -1) {
                    this.aim = shipFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("MR_SF")) {
                if ((!engines.isAccelerating() || !engines.isAcceleratingBackwards() || !engines.isDecelerating()) && (engines.isStrafingLeft() || engines.isTurningLeft() || engines.isStrafingLeft() && engines.isTurningLeft())) {
                    this.aim = shipFacing - 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (engines.isStrafingLeft() || engines.isTurningLeft() || engines.isStrafingLeft() && engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (engines.isStrafingLeft() || engines.isTurningLeft() || engines.isStrafingLeft() && engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                } else if (engines.isAccelerating() && (!engines.isStrafingLeft() || !engines.isTurningLeft() || !engines.isStrafingLeft() && !engines.isTurningLeft()) || shipSystemAcc == 1) {
                    this.aim = shipFacing + arcFacing + arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (!engines.isStrafingLeft() || !engines.isTurningLeft() || !engines.isStrafingLeft() && !engines.isTurningLeft()) || shipSystemAcc == -1) {
                    this.aim = shipFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("MR_PF")) {
                if ((!engines.isAccelerating() || !engines.isAcceleratingBackwards() || !engines.isDecelerating()) && (engines.isStrafingRight() || engines.isTurningRight() || engines.isStrafingRight() && engines.isTurningRight())) {
                    this.aim = shipFacing - 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (engines.isStrafingRight() || engines.isTurningRight() || engines.isStrafingRight() && engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (engines.isStrafingRight() || engines.isTurningRight() || engines.isStrafingRight() && engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (!engines.isStrafingRight() || !engines.isTurningRight() || !engines.isStrafingRight() && !engines.isTurningRight()) || shipSystemAcc == 1) {
                    this.aim = shipFacing + arcFacing - arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (!engines.isStrafingRight() || !engines.isTurningRight() || !engines.isStrafingRight() && !engines.isTurningRight()) || shipSystemAcc == -1) {
                    this.aim = shipFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("MR_SA")) {
                if ((!engines.isAccelerating() || !engines.isAcceleratingBackwards() || !engines.isDecelerating()) && (engines.isStrafingLeft() || engines.isTurningRight() || engines.isStrafingLeft() && engines.isTurningRight())) {
                    this.aim = shipFacing - 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (engines.isStrafingLeft() || engines.isTurningRight() || engines.isStrafingLeft() && engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (engines.isStrafingLeft() || engines.isTurningRight() || engines.isStrafingLeft() && engines.isTurningRight())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (!engines.isStrafingLeft() || !engines.isTurningRight() || !engines.isStrafingLeft() && !engines.isTurningRight()) || shipSystemAcc == 1) {
                    this.aim = shipFacing + arcFacing - arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (!engines.isStrafingLeft() || !engines.isTurningRight() || !engines.isStrafingLeft() && !engines.isTurningRight()) || shipSystemAcc == -1) {
                    this.aim = shipFacing + arcFacing + arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            if (weapon.getSlot().getId().contains("MR_PA")) {
                if ((!engines.isAccelerating() || !engines.isAcceleratingBackwards() || !engines.isDecelerating()) && (engines.isStrafingRight() || engines.isTurningLeft() || engines.isStrafingRight() && engines.isTurningLeft())) {
                    this.aim = shipFacing + 90.0f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (engines.isStrafingRight() || engines.isTurningLeft() || engines.isStrafingRight() && engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing + arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (engines.isStrafingRight() || engines.isTurningLeft() || engines.isStrafingRight() && engines.isTurningLeft())) {
                    this.aim = shipFacing + arcFacing - arc * 0.25f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.5f;
                        if (this.throttle < 60.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if (engines.isAccelerating() && (!engines.isStrafingRight() || !engines.isTurningLeft() || !engines.isStrafingRight() && !engines.isTurningLeft()) || shipSystemAcc == 1) {
                    this.aim = shipFacing + arcFacing + arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else if ((engines.isAcceleratingBackwards() || engines.isDecelerating()) && (!engines.isStrafingRight() || !engines.isTurningLeft() || !engines.isStrafingRight() && !engines.isTurningLeft()) || shipSystemAcc == -1) {
                    this.aim = shipFacing + arcFacing - arc * 0.5f;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.8f;
                        if (this.throttle <= 99.0f) {
                            this.throttle += maxThrottleDelta;
                        }
                    }
                } else {
                    this.aim = shipFacing + arcFacing;
                    if (weapon.getSlot().getId().contains("THRUST")) {
                        this.maxOutput = 0.3f;
                        if (this.throttle >= idleThrottle) {
                            this.throttle -= maxReturnToIdleDelta;
                        }
                    }
                }
            }
            this.target = angle + MathUtils.getShortestRotation((float)angle, (float)this.aim);
            int size = weapon.getSlot().getId().contains("LCAP") || weapon.getSlot().getId().contains("LTHRUST") ? 24 : (weapon.getSlot().getId().contains("MCAP") || weapon.getSlot().getId().contains("MTHRUST") ? 12 : (weapon.getSlot().getId().contains("SCAP") || weapon.getSlot().getId().contains("STHRUST") ? 6 : 3));
            weapon.setCurrAngle(angle + amount * (float)size * (this.target - angle));
            if (engines.isAccelerating() && this.throttle >= 99.0f) {
                this.throttle = 100.0f;
            }
            if (!(engines.isAccelerating() && engines.isAcceleratingBackwards() && engines.isDecelerating() || !(this.throttle <= idleThrottle))) {
                this.throttle = idleThrottle;
            }
            float thrust = this.throttle / 100.0f;
            this.lengthMult = ship.getVariant().getHullMods().contains("safetyoverrides") ? (shipSystemAcc != 0 || ship.getTravelDrive().isActive() ? 4.0f : 2.25f) : (shipSystemAcc != 0 || ship.getTravelDrive().isActive() ? 3.25f : 1.65f);
            float alphaMult = this.lengthMult - 0.5f > 1.0f ? 0.85f : this.lengthMult - 0.5f;
            float offset = Math.abs(MathUtils.getShortestRotation((float)weapon.getCurrAngle(), (float)this.target));
            float randScale = MathUtils.getRandomNumberInRange((float)0.9f, (float)1.1f);
            if (weapon.getSlot().getId().contains("TTHRUST")) {
                weapon.getSprite().setHeight(tinY.get(ship.getHullSize()).floatValue() * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getSprite().setWidth(60.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale);
                weapon.getSprite().setCenter(30.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale, tinY.get(ship.getHullSize()).floatValue() / 2.0f * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getAnimation().setAlphaMult(alphaMult);
            }
            if (weapon.getSlot().getId().contains("STHRUST")) {
                weapon.getSprite().setHeight(smallY.get(ship.getHullSize()).floatValue() * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getSprite().setWidth(100.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale);
                weapon.getSprite().setCenter(50.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale, smallY.get(ship.getHullSize()).floatValue() / 2.0f * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getAnimation().setAlphaMult(alphaMult);
            }
            if (weapon.getSlot().getId().contains("MTHRUST")) {
                weapon.getSprite().setHeight(midY.get(ship.getHullSize()).floatValue() * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getSprite().setWidth(180.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale);
                weapon.getSprite().setCenter(90.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale, midY.get(ship.getHullSize()).floatValue() / 2.0f * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getAnimation().setAlphaMult(alphaMult);
            }
            if (weapon.getSlot().getId().contains("LTHRUST")) {
                weapon.getSprite().setHeight(bigY.get(ship.getHullSize()).floatValue() * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getSprite().setWidth(260.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale);
                weapon.getSprite().setCenter(130.0f / (offset + 10.0f) * this.maxOutput * 1.25f * randScale, bigY.get(ship.getHullSize()).floatValue() / 2.0f * 10.0f / (offset + 10.0f) * thrust * this.lengthMult * randScale);
                weapon.getAnimation().setAlphaMult(alphaMult);
            }
        }
    }

    static {
        shipSystemAccDir = 0;
        shipSystemAcc = 0;
        tinY = new HashMap<ShipAPI.HullSize, Float>();
        tinY.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(15.0f));
        tinY.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(25.0f));
        tinY.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(35.0f));
        tinY.put(ShipAPI.HullSize.CRUISER, Float.valueOf(55.0f));
        tinY.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(75.0f));
        smallY = new HashMap<ShipAPI.HullSize, Float>();
        smallY.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(50.0f));
        smallY.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(60.0f));
        smallY.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(80.0f));
        smallY.put(ShipAPI.HullSize.CRUISER, Float.valueOf(90.0f));
        smallY.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(100.0f));
        midY = new HashMap<ShipAPI.HullSize, Float>();
        midY.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.0f));
        midY.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(80.0f));
        midY.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(110.0f));
        midY.put(ShipAPI.HullSize.CRUISER, Float.valueOf(140.0f));
        midY.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(180.0f));
        bigY = new HashMap<ShipAPI.HullSize, Float>();
        bigY.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.0f));
        bigY.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(100.0f));
        bigY.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(140.0f));
        bigY.put(ShipAPI.HullSize.CRUISER, Float.valueOf(180.0f));
        bigY.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(260.0f));
        accShipSystems = new HashSet<String>();
        accShipSystems.add("ms_RRSDrive");
        accBackShipSystems = new HashSet<String>();
        accBackShipSystems.add("ms_woopDrive");
    }
}

