/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.anar;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import data.scripts.world.AddMarketplace;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public class Anar {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Anar");
        system.getLocation().set(-9000.0f, 3400.0f);
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/anarbg.jpg");
        PlanetAPI anar = system.initStar("anar", "star_yellow", 600.0f, 350.0f, 11.0f, 1.3f, 2.0f);
        PlanetAPI anar1 = system.addPlanet("lambence", (SectorEntityToken)anar, "Lambence", "barren", 155.0f, 55.0f, 1200.0f, 53.0f);
        anar1.setFaction("shadow_industry");
        anar1.setCustomDescriptionId("planet_lambence");
        AddMarketplace.addMarketplace("shadow_industry", (SectorEntityToken)anar1, null, "Lambence", 3, new ArrayList<String>(Arrays.asList("no_atmosphere", "hot", "ms_supersolar", "hydroponics_complex", "population_3", "low_gravity")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        PlanetAPI anar2 = system.addPlanet("wallow", (SectorEntityToken)anar, "Wallow", "toxic", 20.0f, 180.0f, 2500.0f, 222.0f);
        PlanetAPI euripides = system.addPlanet("euripides", (SectorEntityToken)anar, "Euripides", "planet_euripides", 245.0f, 160.0f, 3900.0f, 381.0f);
        PlanetAPI anar3a = system.addPlanet("aeschylus", (SectorEntityToken)euripides, "Aeschylus", "cryovolcanic", 235.0f, 40.0f, 500.0f, 62.0f);
        system.addRingBand((SectorEntityToken)euripides, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 550.0f, 40.0f);
        system.addRingBand((SectorEntityToken)euripides, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 650.0f, 60.0f);
        system.addRingBand((SectorEntityToken)euripides, "ringsMod", "dusty", 1024.0f, 2, Color.white, 1024.0f, 700.0f, 80.0f);
        euripides.setCustomDescriptionId("planet_euripides");
        anar3a.setCustomDescriptionId("planet_aeschylus");
        euripides.getSpec().setGlowTexture(Global.getSettings().getSpriteName("hab_glows", "euripides"));
        euripides.getSpec().setGlowColor(new Color(255, 255, 255, 255));
        euripides.getSpec().setUseReverseLightForGlow(true);
        euripides.applySpecChanges();
        euripides.setFaction("shadow_industry");
        euripides.setInteractionImage("illustrations", "nanshe_desert");
        CustomCampaignEntityAPI station_pranaVayu = system.addCustomEntity("prana_vayu", "Prana Vayu \u8239\u575e", "station_shi_prana", "shadow_industry");
        station_pranaVayu.setCircularOrbitPointingDown(system.getEntityById("euripides"), 45.0f, 400.0f, 50.0f);
        station_pranaVayu.setCustomDescriptionId("station_prana");
        AddMarketplace.addMarketplace("shadow_industry", (SectorEntityToken)euripides, new ArrayList<SectorEntityToken>(Arrays.asList(station_pranaVayu)), "Euripides", 8, new ArrayList<String>(Arrays.asList("ms_semiArid", "habitable", "farmland_adequate", "ore_moderate", "rare_ore_sparse", "orbital_station", "ore_complex", "ore_refining_complex", "ore_refining_complex", "ore_refining_complex", "light_industrial_complex", "ms_modularFac", "ms_modularFac", "ms_modularFac", "ms_medCenter", "regional_capital", "population_8")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        CustomCampaignEntityAPI relay = system.addCustomEntity("anar_relay", "Anar \u901a\u8baf\u5668", "comm_relay", "shadow_industry");
        relay.setCircularOrbit(system.getEntityById("anar"), 300.0f, 3750.0f, 381.0f);
        SectorEntityToken neb1 = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("   xx x x  xxx xx   x xx   xxx   x ", 5, 7, "terrain", "nebula_anar", 4, 4, "Anar Drifts"));
        neb1.getLocation().set(euripides.getLocation().x + 1800.0f, euripides.getLocation().y + 300.0f);
        neb1.setCircularOrbit((SectorEntityToken)anar, 160.0f, 5200.0f, 520.0f);
        SectorEntityToken neb2 = system.addTerrain("nebula", (Object)new BaseTiledTerrain.TileParams("    xxx    xxx xxxx    xxxxxxxxxxx xxx  x       xx", 10, 5, "terrain", "nebula_anar", 4, 4, "Anar Drifts"));
        neb2.getLocation().set(euripides.getLocation().x + 1800.0f, euripides.getLocation().y + 300.0f);
        neb2.setCircularOrbit((SectorEntityToken)anar, 250.0f, 10400.0f, 520.0f);
        PlanetAPI anar4 = system.addPlanet("calleach", (SectorEntityToken)anar, "Calleach", "ice_giant", 235.0f, 300.0f, 12000.0f, 766.0f);
        anar4.setCustomDescriptionId("planet_calleach");
        system.addRingBand((SectorEntityToken)anar4, "ringsMod", "dusty", 1024.0f, 1, Color.white, 1024.0f, 1650.0f, 40.0f);
        system.addRingBand((SectorEntityToken)anar4, "ringsMod", "rocky", 1024.0f, 1, Color.white, 1024.0f, 1750.0f, 60.0f);
        system.addRingBand((SectorEntityToken)anar4, "misc", "rings_ice0", 256.0f, 2, Color.white, 128.0f, 1750.0f, 80.0f);
        system.addRingBand((SectorEntityToken)anar4, "misc", "rings_dust0", 256.0f, 1, Color.white, 128.0f, 1800.0f, 120.0f);
        PlanetAPI anar4a = system.addPlanet("cinderbox", (SectorEntityToken)anar4, "Cinderbox", "lava", 300.0f, 60.0f, 700.0f, 88.0f);
        anar4a.setCustomDescriptionId("planet_cinderbox");
        PlanetAPI theramin = system.addPlanet("theramin", (SectorEntityToken)anar4, "Theramin", "terran", 240.0f, 120.0f, 1200.0f, 246.0f);
        theramin.setCustomDescriptionId("planet_theramin");
        theramin.setFaction("shadow_industry");
        PlanetAPI melancholia = system.addPlanet("melancholia", (SectorEntityToken)anar4, "Melancholia", "cryovolcanic", 200.0f, 80.0f, 2100.0f, 492.0f);
        ProcgenUsedNames.notifyUsed((String)"Melancholia");
        melancholia.setCustomDescriptionId("planet_melancholia");
        melancholia.setFaction("independent");
        CustomCampaignEntityAPI station_gravitas = system.addCustomEntity("gravitas", "Gravitas \u7814\u7a76\u7ad9", "station_shi_med", "shadow_industry");
        station_gravitas.setCircularOrbitPointingDown(system.getEntityById("theramin"), 45.0f, 300.0f, 50.0f);
        SectorEntityToken calleach_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(anar4.getRadius() + 300.0f, (anar4.getRadius() + 300.0f) / 2.0f, (SectorEntityToken)anar4, anar4.getRadius() + 50.0f, anar4.getRadius() + 50.0f + 300.0f, new Color(100, 20, 50, 40), 0.7f, new Color[]{new Color(235, 100, 140), new Color(210, 110, 180), new Color(140, 190, 150), new Color(140, 190, 210), new Color(170, 200, 90), new Color(65, 230, 160), new Color(70, 220, 20)}));
        calleach_field.setCircularOrbit((SectorEntityToken)anar4, 0.0f, 0.0f, 100.0f);
        AddMarketplace.addMarketplace("shadow_industry", (SectorEntityToken)theramin, new ArrayList<SectorEntityToken>(Arrays.asList(station_gravitas)), "Theramin", 6, new ArrayList<String>(Arrays.asList("ms_partTerranPartRad", "habitable", "extreme_weather", "orbital_station", "military_base", "headquarters", "organics_complex", "farmland_rich", "shipbreaking_center", "ms_radiationAbsorbers", "volatiles_depot", "population_6")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market", "generic_military")), 0.3f);
        AddMarketplace.addMarketplace("independent", (SectorEntityToken)melancholia, null, "Melancholia", 3, new ArrayList<String>(Arrays.asList("ice", "thin_atmosphere", "frontier", "volatiles_complex", "vice_demand", "population_3")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        system.addAsteroidBelt((SectorEntityToken)anar, 600, 18000.0f, 1400.0f, 600.0f, 400.0f, "asteroid_belt", "Dusk Line");
        system.addRingBand((SectorEntityToken)anar, "ringsMod", "dusty", 512.0f, 3, Color.white, 512.0f, 20000.0f, 260.0f);
        system.addRingBand((SectorEntityToken)anar, "ringsMod", "rocky", 512.0f, 3, Color.white, 512.0f, 20000.0f, 260.0f);
        system.addAsteroidBelt((SectorEntityToken)anar, 200, 14000.0f, 1400.0f, 200.0f, 300.0f, "asteroid_belt", "Ergan Belt");
        CustomCampaignEntityAPI berins_stash = system.addCustomEntity("berins_stash", "Berins \u7684\u85cf\u533f\u5904", "station_shi_hiddenPirateBase", "pirates");
        berins_stash.setCircularOrbitPointingDown(system.getEntityById("anar"), 72.0f, 20100.0f, 260.0f);
        berins_stash.setCustomDescriptionId("berins_stash");
        SectorEntityToken hideaway = system.addTerrain("asteroid_field", (Object)new AsteroidFieldTerrainPlugin.AsteroidFieldParams(600.0f, 900.0f, 22, 35, 4.0f, 16.0f, "Gliese Field"));
        hideaway.setCircularOrbit(system.getEntityById("anar"), 72.0f, 14100.0f, 260.0f);
        SectorEntityToken a3 = system.getEntityById("euripides");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("euripides_gate", "Euripides \u8df3\u8dc3\u70b9");
        jumpPoint.setCircularOrbit(system.getEntityById("anar"), 180.0f, 3750.0f, 381.0f);
        jumpPoint.setRelatedPlanet(a3);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        system.autogenerateHyperspaceJumpPoints(true, true);
        this.cleanup(system);
    }

    void cleanup(StarSystemAPI system) {
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor((BaseTiledTerrain)plugin);
        float minRadius = plugin.getTileSize() * 2.0f;
        float radius = system.getMaxRadiusInHyperspace();
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius * 0.5f, 0.0f, 360.0f);
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius, 0.0f, 360.0f, 0.25f);
    }
}

