/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.gigas;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import data.scripts.world.AddMarketplace;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class Gigas {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Gigas");
        system.getLocation().set(-6500.0f, -1550.0f);
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/velkabg.jpg");
        PlanetAPI vel = system.initStar("Gigas", "star_red_supergiant", 800.0f, 600.0f, 17.0f, 2.0f, 3.5f);
        system.setLightColor(new Color(255, 220, 200));
        PlanetAPI vel1 = system.addPlanet("rubicante", (SectorEntityToken)vel, "Rubicante", "lava_minor", 160.0f, 150.0f, 2400.0f, 210.0f);
        vel1.setCustomDescriptionId("planet_rubicante");
        CustomCampaignEntityAPI auris_grip = system.addCustomEntity("auris_grip", "Auris \u7a7a\u95f4\u7ad9", "station_pirate_type", "pirates");
        auris_grip.setCircularOrbitPointingDown(system.getEntityById("rubicante"), 45.0f, 400.0f, 50.0f);
        auris_grip.setCustomDescriptionId("station_auris");
        AddMarketplace.addMarketplace("pirates", (SectorEntityToken)auris_grip, null, "Auris \u7a7a\u95f4\u7ad9", 5, new ArrayList<String>(Arrays.asList("orbital_station", "ore_complex", "free_market", "organized_crime", "population_5")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        DebrisFieldTerrainPlugin.DebrisFieldParams params = new DebrisFieldTerrainPlugin.DebrisFieldParams(500.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = 250L;
        SectorEntityToken rubicanteDebrisField = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        rubicanteDebrisField.setSensorProfile(null);
        rubicanteDebrisField.setDiscoverable(null);
        rubicanteDebrisField.setCircularOrbit((SectorEntityToken)vel, 170.0f, 2200.0f, 210.0f);
        system.addAsteroidBelt((SectorEntityToken)vel, 400, 4500.0f, 1400.0f, 600.0f, 400.0f, "asteroid_belt", "Clashed \u7a7a\u95f4\u7ad9");
        system.addAsteroidBelt((SectorEntityToken)vel, 400, 4900.0f, 1400.0f, 600.0f, 400.0f, "asteroid_belt", "Clashed \u7a7a\u95f4\u7ad9");
        system.addAsteroidBelt((SectorEntityToken)vel, 400, 5300.0f, 1400.0f, 600.0f, 400.0f, "asteroid_belt", "Clashed \u7a7a\u95f4\u7ad9");
        system.addAsteroidBelt((SectorEntityToken)vel, 400, 5700.0f, 1400.0f, 600.0f, 400.0f, "asteroid_belt", "Clashed \u7a7a\u95f4\u7ad9");
        system.addRingBand((SectorEntityToken)vel, "ringsMod", "rocky", 1024.0f, 1, Color.white, 1024.0f, 4550.0f, 60.0f);
        system.addRingBand((SectorEntityToken)vel, "ringsMod", "cloudy", 1024.0f, 1, Color.white, 1024.0f, 4550.0f, 60.0f);
        system.addRingBand((SectorEntityToken)vel, "ringsMod", "rocky", 1024.0f, 1, Color.white, 1024.0f, 4950.0f, 60.0f);
        system.addRingBand((SectorEntityToken)vel, "ringsMod", "cloudy", 1024.0f, 1, Color.white, 1024.0f, 4950.0f, 60.0f);
        system.addRingBand((SectorEntityToken)vel, "ringsMod", "rocky", 1024.0f, 1, Color.white, 1024.0f, 5350.0f, 60.0f);
        system.addRingBand((SectorEntityToken)vel, "ringsMod", "cloudy", 1024.0f, 1, Color.white, 1024.0f, 5350.0f, 60.0f);
        params = new DebrisFieldTerrainPlugin.DebrisFieldParams(500.0f, 1.0f, 1.0E7f, 0.0f);
        params.source = DebrisFieldTerrainPlugin.DebrisFieldSource.MIXED;
        params.baseSalvageXP = 250L;
        SectorEntityToken belterDebrisField = Misc.addDebrisField((LocationAPI)system, (DebrisFieldTerrainPlugin.DebrisFieldParams)params, (Random)StarSystemGenerator.random);
        belterDebrisField.setSensorProfile(Float.valueOf(100.0f));
        belterDebrisField.setDiscoverable(Boolean.valueOf(true));
        belterDebrisField.setCircularOrbit((SectorEntityToken)vel, 30.0f, 4600.0f, 180.0f);
        this.addDerelict(system, (SectorEntityToken)vel, "ms_enlil_Standard", ShipRecoverySpecial.ShipCondition.BATTERED, 4613.0f, false);
        this.addDerelict(system, (SectorEntityToken)vel, "kite_Standard", ShipRecoverySpecial.ShipCondition.BATTERED, 4545.0f, false);
        this.addDerelict(system, (SectorEntityToken)vel, "wolf_d_pirates_Attack", ShipRecoverySpecial.ShipCondition.WRECKED, 4877.0f, false);
        PlanetAPI vel2 = system.addPlanet("leviathan", (SectorEntityToken)vel, "Leviathan", "gas_giant", 92.0f, 400.0f, 8600.0f, 170.0f);
        SectorEntityToken levi_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(vel2.getRadius() + 100.0f, (vel2.getRadius() + 100.0f) / 2.0f, (SectorEntityToken)vel2, vel2.getRadius() + 10.0f, vel2.getRadius() + 10.0f + 90.0f, new Color(50, 20, 100, 40), 0.3f, new Color[]{new Color(140, 100, 235), new Color(180, 110, 210), new Color(150, 140, 190), new Color(140, 190, 210), new Color(90, 200, 170), new Color(65, 230, 160), new Color(20, 220, 70)}));
        levi_field.setCircularOrbit((SectorEntityToken)vel2, 0.0f, 0.0f, 100.0f);
        PlanetAPI vel2a = system.addPlanet("sturmvald", (SectorEntityToken)vel2, "Sturmvald", "rocky_unstable", 92.0f, 80.0f, 800.0f, 170.0f);
        vel2a.setCustomDescriptionId("planet_sturmvald");
        PlanetAPI stillness = system.addPlanet("stillness", (SectorEntityToken)vel2, "Stillness", "rocky_ice", 110.0f, 120.0f, 1200.0f, 210.0f);
        stillness.setCustomDescriptionId("planet_stillness");
        stillness.setFaction("shadow_industry");
        AddMarketplace.addMarketplace("shadow_industry", (SectorEntityToken)stillness, null, "Stillness", 5, new ArrayList<String>(Arrays.asList("ice", "thin_atmosphere", "spaceport", "ore_refining_complex", "ore_refining_complex", "volatiles_complex", "light_industrial_complex", "large_refugee_population", "population_5")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        this.addDerelict(system, (SectorEntityToken)vel, "ms_sargasso_Assault", ShipRecoverySpecial.ShipCondition.AVERAGE, 11000.0f, true);
        PlanetAPI vel3 = system.addPlanet("kain", (SectorEntityToken)vel, "Kain", "frozen", 211.0f, 110.0f, 14500.0f, 243.0f);
        CustomCampaignEntityAPI lance_base = system.addCustomEntity("lance_base", "Lance \u524d\u54e8\u7ad9", "station_side02", "hegemony");
        lance_base.setCircularOrbitPointingDown(system.getEntityById("kain"), 45.0f, 400.0f, 50.0f);
        lance_base.setCustomDescriptionId("station_lance");
        AddMarketplace.addMarketplace("hegemony", (SectorEntityToken)lance_base, null, "Lance \u524d\u54e8\u7ad9", 3, new ArrayList<String>(Arrays.asList("frontier", "orbital_station", "military_base", "outpost", "population_3")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        CustomCampaignEntityAPI relay = system.addCustomEntity("gigas_relay", "Gigas \u901a\u8baf\u5668", "comm_relay", "shadow_industry");
        relay.setCircularOrbit(system.getEntityById("gigas"), 220.0f, 1900.0f, 210.0f);
        SectorEntityToken v = system.getEntityById("gigas");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("gigas_gate", "Gigas \u8df3\u8dc3\u70b9");
        jumpPoint.setCircularOrbit(v, 100.0f, 1900.0f, 210.0f);
        jumpPoint.setRelatedPlanet((SectorEntityToken)vel1);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        StarSystemGenerator.addSystemwideNebula((StarSystemAPI)system, (StarAge)StarAge.OLD);
        system.autogenerateHyperspaceJumpPoints(true, true);
        this.cleanup(system);
    }

    void cleanup(StarSystemAPI system) {
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor((BaseTiledTerrain)plugin);
        float minRadius = plugin.getTileSize() * 2.0f;
        float radius = system.getMaxRadiusInHyperspace();
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius * 0.5f, 0.0f, 360.0f);
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius, 0.0f, 360.0f, 0.25f);
    }

    protected void addDerelict(StarSystemAPI system, SectorEntityToken focus, String variantId, ShipRecoverySpecial.ShipCondition condition, float orbitRadius, boolean recoverable) {
        DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData(variantId, condition), false);
        SectorEntityToken ship = BaseThemeGenerator.addSalvageEntity((LocationAPI)system, (String)"wreck", (String)"neutral", (Object)params);
        ship.setDiscoverable(Boolean.valueOf(true));
        float orbitDays = orbitRadius / (10.0f + (float)Math.random() * 5.0f);
        ship.setCircularOrbit(focus, (float)Math.random() * 360.0f, orbitRadius, orbitDays);
        if (recoverable) {
            SalvageSpecialAssigner.ShipRecoverySpecialCreator creator = new SalvageSpecialAssigner.ShipRecoverySpecialCreator(null, 0, 0, false, null, null);
            Misc.setSalvageSpecial((SectorEntityToken)ship, (Object)creator.createSpecial(ship, null));
        }
    }
}

