/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.yajna;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import data.scripts.world.AddMarketplace;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public class Yajna {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Yajna");
        system.getLocation().set(-3600.0f, -200.0f);
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/yajnabg.jpg");
        PlanetAPI yaj = system.initStar("Yajna", "star_orange", 600.0f, 400.0f, 17.0f, 2.0f, 3.5f);
        system.setLightColor(new Color(255, 230, 220));
        system.addRingBand((SectorEntityToken)yaj, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 800.0f, 40.0f, null, null);
        PlanetAPI yaj1 = system.addPlanet("udgatri", (SectorEntityToken)yaj, "Udgatri", "ice_giant", 20.0f, 500.0f, 2100.0f, 120.0f);
        CustomCampaignEntityAPI pillager = system.addCustomEntity("pillager", "\u63a0\u593a\u8005\u636e\u70b9", "station_side06", "pirates");
        pillager.setCircularOrbitPointingDown((SectorEntityToken)yaj1, 55.0f, 800.0f, 100.0f);
        pillager.setCustomDescriptionId("pillager_point");
        AddMarketplace.addMarketplace("pirates", (SectorEntityToken)pillager, null, "\u63a0\u593a\u8005\u636e\u70b9", 5, new ArrayList<String>(Arrays.asList("orbital_station", "military_base", "volatiles_complex", "hydroponics_complex", "organized_crime", "free_market", "population_5")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market", "generic_military")), 0.3f);
        PlanetAPI yaj2 = system.addPlanet("adhvaryu", (SectorEntityToken)yaj, "Adhvaryu", "barren_castiron", 175.0f, 28.0f, 3000.0f, 144.0f);
        PlanetAPI yaj2a = system.addPlanet("saptapadi", (SectorEntityToken)yaj2, "Saptapadi", "barren_castiron", 35.0f, 18.0f, 200.0f, 22.0f);
        PlanetAPI jnana = system.addPlanet("jnana", (SectorEntityToken)yaj, "Jnana", "desert1", 218.0f, 85.0f, 4800.0f, 270.0f);
        PlanetAPI yaj3a = system.addPlanet("kanda", (SectorEntityToken)jnana, "Kanda", "barren3", 235.0f, 30.0f, 500.0f, 90.0f);
        jnana.setCustomDescriptionId("planet_jnana");
        AddMarketplace.addMarketplace("shadow_industry", (SectorEntityToken)jnana, null, "Jnana", 5, new ArrayList<String>(Arrays.asList("desert", "inimical_biosphere", "habitable", "military_base", "ms_modularFac", "spaceport", "hydroponics_complex", "ore_refining_complex", "antimatter_fuel_production", "population_5")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market", "generic_military")), 0.3f);
        PlanetAPI hotri = system.addPlanet("hotri", (SectorEntityToken)yaj, "Hotri", "terran-eccentric", 110.0f, 90.0f, 5500.0f, 295.0f);
        CustomCampaignEntityAPI hotri_port = system.addCustomEntity("hotri_port", "Hotri \u8d38\u6613\u6e2f\u53e3", "station_sporeship_derelict", "independent");
        hotri_port.setCircularOrbitPointingDown((SectorEntityToken)hotri, 60.0f, 400.0f, 100.0f);
        hotri.setCustomDescriptionId("planet_hotri");
        hotri_port.setCustomDescriptionId("hotri_port");
        AddMarketplace.addMarketplace("independent", (SectorEntityToken)hotri, new ArrayList<SectorEntityToken>(Arrays.asList(hotri_port)), "Hotri", 4, new ArrayList<String>(Arrays.asList("arid", "mild_climate", "habitable", "orbital_station", "farmland_rich", "rare_ore_abundant", "ore_moderate", "cottage_industry", "ruins_scattered", "rural_polity", "population_4")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        PlanetAPI yaj5 = system.addPlanet("brahmin", (SectorEntityToken)yaj, "Brahmin", "irradiated", 155.0f, 110.0f, 7000.0f, 680.0f);
        SectorEntityToken yaj5_field = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(yaj5.getRadius() + 300.0f, (yaj5.getRadius() + 250.0f) / 2.0f, (SectorEntityToken)yaj5, yaj5.getRadius() + 50.0f, yaj5.getRadius() + 50.0f + 300.0f, new Color(100, 20, 50, 40), 0.7f, new Color[]{new Color(235, 100, 140), new Color(210, 110, 180), new Color(140, 190, 150), new Color(140, 190, 210), new Color(170, 200, 90), new Color(65, 230, 160), new Color(70, 220, 20)}));
        yaj5_field.setCircularOrbit((SectorEntityToken)yaj5, 0.0f, 0.0f, 100.0f);
        system.addRingBand((SectorEntityToken)yaj, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 7700.0f, 40.0f, null, null);
        system.addRingBand((SectorEntityToken)yaj, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 7900.0f, 40.0f, null, null);
        system.addRingBand((SectorEntityToken)yaj, "misc", "rings_asteroids0", 256.0f, 1, Color.white, 256.0f, 8100.0f, 40.0f, null, null);
        system.addAsteroidBelt((SectorEntityToken)yaj, 600, 7900.0f, 1400.0f, 600.0f, 400.0f, "asteroid_belt", "Center Belt");
        PlanetAPI mantra = system.addPlanet("mantra", (SectorEntityToken)yaj, "Mantra", "toxic_cold", 70.0f, 100.0f, 8500.0f, 470.0f);
        PlanetAPI yaj6a = system.addPlanet("soma", (SectorEntityToken)mantra, "Soma", "frozen", 190.0f, 35.0f, 450.0f, 100.0f);
        PlanetAPI yaj6b = system.addPlanet("havir", (SectorEntityToken)mantra, "Havir", "frozen3", 70.0f, 15.0f, 700.0f, 60.0f);
        CustomCampaignEntityAPI mandala_station = system.addCustomEntity("mandala_station", "Mandala \u7a7a\u95f4\u7ad9", "station_side03", "persean");
        mandala_station.setCircularOrbitPointingDown((SectorEntityToken)mantra, 75.0f, 400.0f, 100.0f);
        mantra.setCustomDescriptionId("planet_mantra");
        AddMarketplace.addMarketplace("persean", (SectorEntityToken)mantra, new ArrayList<SectorEntityToken>(Arrays.asList(mandala_station)), "Mantra", 6, new ArrayList<String>(Arrays.asList("toxic_atmosphere", "cold", "orbital_station", "organics_trace", "volatiles_diffuse", "volatiles_complex", "light_industrial_complex", "population_6")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        PlanetAPI karma = system.addPlanet("karma", (SectorEntityToken)yaj, "Karma", "rocky_unstable", 95.0f, 60.0f, 9750.0f, 1180.0f);
        karma.setCustomDescriptionId("planet_karma");
        AddMarketplace.addMarketplace("shadow_industry", (SectorEntityToken)karma, null, "Karma", 4, new ArrayList<String>(Arrays.asList("thin_atmosphere", "cold", "rare_ore_sparse", "ore_moderate", "ore_complex", "hydroponics_complex", "spaceport", "population_4")), new ArrayList<String>(Arrays.asList("storage", "black_market", "open_market")), 0.3f);
        CustomCampaignEntityAPI relay = system.addCustomEntity("yajna_relay", "Yajna \u901a\u8baf\u5668", "comm_relay", "shadow_industry");
        relay.setCircularOrbit(system.getEntityById("yajna"), 278.0f, 4800.0f, 270.0f);
        SectorEntityToken v = system.getEntityById("yajna");
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("yajna_gate", "Yajna \u8df3\u8dc3\u70b9");
        jumpPoint.setCircularOrbit(v, 158.0f, 4800.0f, 270.0f);
        jumpPoint.setRelatedPlanet((SectorEntityToken)jnana);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        StarSystemGenerator.addSystemwideNebula((StarSystemAPI)system, (StarAge)StarAge.YOUNG);
        system.autogenerateHyperspaceJumpPoints(true, true);
        this.cleanup(system);
    }

    void cleanup(StarSystemAPI system) {
        HyperspaceTerrainPlugin plugin = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor((BaseTiledTerrain)plugin);
        float minRadius = plugin.getTileSize() * 2.0f;
        float radius = system.getMaxRadiusInHyperspace();
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius * 0.5f, 0.0f, 360.0f);
        editor.clearArc(system.getLocation().x, system.getLocation().y, 0.0f, radius + minRadius, 0.0f, 360.0f, 0.25f);
    }
}

