/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.AnimationAPI;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_mimirSlideDrive
implements ShipSystemStatsScript {
    private AnimationAPI theInvert;
    private AnimationAPI theLight;
    private final List<WeaponAPI> theBlack = new ArrayList<WeaponAPI>();
    private final IntervalUtil anim = new IntervalUtil(0.03f, 0.03f);
    private int frameL = 0;
    private int maxFrameL = 0;
    private float invert;
    private static final String DATA_KEY = "ms_RRSDrive";
    private boolean runOnce = false;
    private boolean started = false;

    public static float effectLevel(ShipAPI ship) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return 0.0f;
        }
        Map<ShipAPI, Float> acting = localData.acting;
        if (acting.containsKey(ship)) {
            return acting.get(ship).floatValue();
        }
        return 0.0f;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (!engine.getCustomData().containsKey(DATA_KEY)) {
            engine.getCustomData().put(DATA_KEY, new LocalData());
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        List allWeapons = ship.getAllWeapons();
        if (!this.runOnce) {
            this.runOnce = true;
            this.theBlack.clear();
            for (WeaponAPI w : allWeapons) {
                switch (w.getSlot().getId()) {
                    case "INVERT": {
                        w.getAnimation().setFrame(1);
                        this.theInvert = w.getAnimation();
                        this.theInvert.setAlphaMult(0.0f);
                        break;
                    }
                    case "LIGHTER": {
                        this.theLight = w.getAnimation();
                        this.maxFrameL = this.theLight.getNumFrames();
                    }
                }
            }
            return;
        }
        float amount = engine.getElapsedInLastFrame();
        if (engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)engine.getCustomData().get(DATA_KEY);
        Map<ShipAPI, Float> acting = localData.acting;
        if (ship.isAlive()) {
            if (effectLevel > 0.0f) {
                acting.put(ship, Float.valueOf(effectLevel));
                this.anim.advance(amount);
                if (this.anim.intervalElapsed() && state != ShipSystemStatsScript.State.OUT) {
                    this.frameL = MathUtils.getRandomNumberInRange((int)0, (int)(this.maxFrameL - 1));
                }
                this.invert = MathUtils.getRandomNumberInRange((float)0.9f, (float)1.0f);
                if (state == ShipSystemStatsScript.State.OUT) {
                    this.invert = Math.max(this.invert - (float)Math.cos(Math.PI * (double)effectLevel), 0.0f);
                    this.frameL = 0;
                }
                this.theInvert.setAlphaMult(this.invert);
                this.theInvert.setFrame(1);
                this.theLight.setFrame(this.frameL);
            }
            if (state == ShipSystemStatsScript.State.IN) {
                float speed;
                if (!this.started) {
                    this.started = true;
                }
                if ((speed = ship.getVelocity().length()) <= 0.1f) {
                    ship.getVelocity().set((ReadableVector2f)VectorUtils.getDirectionalVector((Vector2f)ship.getLocation(), (Vector2f)ship.getVelocity()));
                }
                if (speed < 900.0f) {
                    ship.getVelocity().normalise();
                    ship.getVelocity().scale(speed + amount * 3600.0f);
                }
            } else if (state == ShipSystemStatsScript.State.ACTIVE) {
                float speed = ship.getVelocity().length();
                if (speed < 900.0f) {
                    ship.getVelocity().normalise();
                    ship.getVelocity().scale(speed + amount * 3600.0f);
                }
                stats.getArmorDamageTakenMult().modifyPercent(id, 0.5f);
                stats.getHullDamageTakenMult().modifyPercent(id, 0.5f);
            } else {
                float speed = ship.getVelocity().length();
                if (speed > ship.getMutableStats().getMaxSpeed().getModifiedValue()) {
                    ship.getVelocity().normalise();
                    ship.getVelocity().scale(speed - amount * 3600.0f);
                }
            }
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        this.started = false;
        if (ship != null) {
            LocalData localData;
            if (!Global.getCombatEngine().getCustomData().containsKey(DATA_KEY)) {
                Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
            }
            if ((localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY)) != null) {
                Map<ShipAPI, Float> acting = localData.acting;
                acting.remove(ship);
            }
        }
        stats.getArmorDamageTakenMult().unmodify();
        stats.getHullDamageTakenMult().unmodify();
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("\u77e2\u91cf\u9501\u5b9a", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("\u88c5\u7532\u9501\u5b9a", false);
        }
        return null;
    }

    private static final class LocalData {
        final Map<ShipAPI, Float> acting = new HashMap<ShipAPI, Float>(50);

        private LocalData() {
        }
    }
}

