/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_swacs
extends BaseShipSystemScript {
    private CombatEngineAPI engine;
    public static final Object KEY_JITTER = new Object();
    private static final Color COLOR1 = new Color(210, 125, 105, 155);
    public static final Color JITTER_UNDER_COLOR = new Color(255, 50, 0, 125);
    public static final Color JITTER_COLOR = new Color(255, 50, 0, 75);
    public static final float ACCURACY_BONUS = 20.0f;
    public static final float RANGE_BONUS = 10.0f;
    public static final float DAMAGE_BOOST = 33.0f;
    public static final float AGILITY_BONUS = 15.0f;
    private static final Vector2f ZERO = new Vector2f();
    private static final Map<ShipAPI, ShipAPI> receiving = new HashMap<ShipAPI, ShipAPI>();

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (this.engine != Global.getCombatEngine()) {
            this.engine = Global.getCombatEngine();
            receiving.clear();
        }
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        if (effectLevel > 0.0f) {
            float jitterLevel = effectLevel;
            float maxRangeBonus = 5.0f;
            float jitterRangeBonus = jitterLevel * maxRangeBonus;
            for (ShipAPI fighter : this.getFighters(ship)) {
                if (fighter.isHulk()) continue;
                MutableShipStatsAPI fStats = fighter.getMutableStats();
                fStats.getBallisticWeaponDamageMult().modifyPercent(id, 1.0f + 0.32999998f * effectLevel);
                fStats.getEnergyWeaponDamageMult().modifyPercent(id, 1.0f + 0.32999998f * effectLevel);
                fStats.getMissileWeaponDamageMult().modifyPercent(id, 1.0f + 0.32999998f * effectLevel);
                fStats.getAutofireAimAccuracy().modifyPercent(id, 20.0f);
                fStats.getBallisticWeaponRangeBonus().modifyPercent(id, 10.0f);
                fStats.getEnergyWeaponRangeBonus().modifyPercent(id, 10.0f);
                fStats.getBeamWeaponRangeBonus().modifyPercent(id, 10.0f);
                fStats.getMaxSpeed().modifyPercent(id, 15.0f);
                fStats.getAcceleration().modifyPercent(id, 15.0f);
                fStats.getDeceleration().modifyPercent(id, 15.0f);
                fStats.getMaxTurnRate().modifyPercent(id, 15.0f);
                fStats.getTurnAcceleration().modifyPercent(id, 15.0f);
                if (!(jitterLevel > 0.0f)) continue;
                fighter.setWeaponGlow(effectLevel, Misc.setAlpha((Color)JITTER_UNDER_COLOR, (int)255), EnumSet.allOf(WeaponAPI.WeaponType.class));
                fighter.setJitterUnder(KEY_JITTER, JITTER_COLOR, jitterLevel, 5, 0.0f, jitterRangeBonus);
                fighter.setJitter(KEY_JITTER, JITTER_UNDER_COLOR, jitterLevel, 2, 0.0f, 0.0f + jitterRangeBonus * 1.0f);
                Global.getSoundPlayer().playLoop("system_targeting_feed_loop", (Object)ship, 1.0f, 1.0f, fighter.getLocation(), fighter.getVelocity());
                for (ShipEngineControllerAPI.ShipEngineAPI engines : fighter.getEngineController().getShipEngines()) {
                    if (engines.isDisabled()) continue;
                    for (int i = 0; i < 5; ++i) {
                        float size = MathUtils.getRandomNumberInRange((float)8.0f, (float)2.0f);
                        Vector2f spawn = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)ship.getCollisionRadius());
                        if (!(Math.random() > 0.9) || this.engine.isPaused()) continue;
                        this.engine.addSmoothParticle(spawn, ZERO, size, (float)Math.random() * 1.0f, 1.0f, COLOR1);
                    }
                }
            }
        }
    }

    private List<ShipAPI> getFighters(ShipAPI carrier) {
        ArrayList<ShipAPI> result = new ArrayList<ShipAPI>();
        for (ShipAPI ship : Global.getCombatEngine().getShips()) {
            if (!ship.isFighter() || ship.getWing() == null || ship.getWing().getSourceShip() != carrier) continue;
            result.add(ship);
        }
        return result;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        for (ShipAPI fighter : this.getFighters(ship)) {
            if (fighter.isHulk()) continue;
            MutableShipStatsAPI fStats = fighter.getMutableStats();
            fStats.getBallisticWeaponDamageMult().unmodify(id);
            fStats.getEnergyWeaponDamageMult().unmodify(id);
            fStats.getMissileWeaponDamageMult().unmodify(id);
            fStats.getAutofireAimAccuracy().unmodify(id);
            fStats.getBallisticWeaponRangeBonus().unmodify(id);
            fStats.getEnergyWeaponRangeBonus().unmodify(id);
            fStats.getMaxSpeed().unmodify(id);
            fStats.getAcceleration().unmodify(id);
            fStats.getDeceleration().unmodify(id);
            fStats.getTurnAcceleration().unmodify(id);
            fStats.getMaxTurnRate().unmodify(id);
        }
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("" + Misc.getRoundedValueMaxOneAfterDecimal((float)(1.0f + 33.0f * effectLevel * 0.01f)) + "x \u6218\u673a\u4f24\u5bb3", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("" + Misc.getRoundedValueMaxOneAfterDecimal((float)(1.0f + 15.0f * effectLevel * 0.01f)) + "x \u6218\u673a\u822a\u901f", false);
        }
        return null;
    }

    public void init(CombatEngineAPI engine, ShipAPI host) {
        this.engine = engine;
    }
}

