/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.util.HashMap;
import java.util.Map;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_woopDrive
implements ShipSystemStatsScript {
    private static final String DATA_KEY = "ms_woopDrive";
    private boolean started = false;

    public static float effectLevel(ShipAPI ship) {
        CladeData cladeData = (CladeData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (cladeData == null) {
            return 0.0f;
        }
        Map<ShipAPI, Float> acting = cladeData.acting;
        if (acting.containsKey(ship)) {
            return acting.get(ship).floatValue();
        }
        return 0.0f;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine.isPaused()) {
            return;
        }
        CladeData localData = (CladeData)engine.getCustomData().get(DATA_KEY);
        Map<ShipAPI, Float> acting = localData.acting;
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (ship.isAlive()) {
            if (effectLevel > 0.0f) {
                acting.put(ship, Float.valueOf(effectLevel));
            }
            Vector2f point = new Vector2f(-50.0f, 0.0f);
            VectorUtils.rotate((Vector2f)point, (float)ship.getFacing(), (Vector2f)point);
            Vector2f.add((Vector2f)point, (Vector2f)ship.getLocation(), (Vector2f)point);
            Vector2f dir = (Vector2f)VectorUtils.getDirectionalVector((Vector2f)ship.getLocation(), (Vector2f)point).scale(50.0f);
            Vector2f.add((Vector2f)ship.getVelocity(), (Vector2f)dir, (Vector2f)ship.getVelocity());
            if (state == ShipSystemStatsScript.State.OUT) {
                stats.getMaxSpeed().unmodify(id);
                ship.getEngineController().isDecelerating();
                float speed = ship.getVelocity().length();
                if (speed < 300.0f) {
                    ship.getVelocity().normalise();
                    ship.getVelocity().scale(stats.getMaxSpeed().modified);
                }
            } else {
                if (!this.started) {
                    this.started = true;
                }
                stats.getMaxSpeed().modifyFlat(id, 145.0f * effectLevel);
                stats.getAcceleration().modifyFlat(id, 200.0f * effectLevel);
                ship.getEngineController().isAcceleratingBackwards();
                float speed = ship.getVelocity().length();
                if (speed <= 0.1f) {
                    ship.getVelocity().set((ReadableVector2f)VectorUtils.getDirectionalVector((Vector2f)ship.getLocation(), (Vector2f)dir)).scale(stats.getMaxSpeed().modified);
                }
                if (speed < 300.0f) {
                    ship.getVelocity().normalise();
                    ship.getVelocity().scale(stats.getMaxSpeed().modified);
                }
            }
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        this.started = false;
        if (ship != null) {
            CladeData localData;
            if (!Global.getCombatEngine().getCustomData().containsKey(DATA_KEY)) {
                Global.getCombatEngine().getCustomData().put(DATA_KEY, new CladeData());
            }
            if ((localData = (CladeData)Global.getCombatEngine().getCustomData().get(DATA_KEY)) != null) {
                Map<ShipAPI, Float> acting = localData.acting;
                acting.remove(ship);
            }
        }
        stats.getAcceleration().unmodify(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return new ShipSystemStatsScript.StatusData("\u56de\u907f\u9a71\u52a8\u5668\u6fc0\u6d3b", false);
    }

    private static final class CladeData {
        final Map<ShipAPI, Float> acting = new HashMap<ShipAPI, Float>(50);

        private CladeData() {
        }
    }
}

