/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Collection;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_afterburnerAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private IntervalUtil tracker = new IntervalUtil(0.1f, 0.5f);
    private float range = 800.0f;
    private final CollectionUtils.CollectionFilter filterGoals = new CollectionUtils.CollectionFilter(){

        public boolean accept(Object t) {
            CombatEntityAPI entity = (CombatEntityAPI)t;
            if (entity instanceof DamagingProjectileAPI || entity instanceof MissileAPI) {
                return false;
            }
            return entity == MS_afterburnerAI.this.ship.getShipTarget() || entity instanceof BattleObjectiveAPI;
        }
    };

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
    }

    public void advance(float amount, Vector2f position, Vector2f collisionDanger, ShipAPI target) {
        this.tracker.advance(amount);
        Vector2f shipLoc = this.ship.getLocation();
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            boolean shouldUseSystem = true;
            List goalThings = CombatUtils.getEntitiesWithinRange((Vector2f)shipLoc, (float)this.range);
            goalThings = CollectionUtils.filter((Collection)goalThings, (CollectionUtils.CollectionFilter)this.filterGoals);
            goalThings.addAll(AIUtils.getEnemiesOnMap((CombatEntityAPI)this.ship));
            if (!goalThings.isEmpty()) {
                shouldUseSystem = false;
            }
            if (shouldUseSystem) {
                this.ship.useSystem();
            }
        }
    }
}

