/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Collection;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_drivechargerai
implements ShipSystemAIScript {
    private static final float SECONDS_TO_LOOK_AHEAD = 3.0f;
    private float THRESHHOLD;
    private ShipAPI ship;
    private CombatEngineAPI engine;
    private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.2f);
    private final CollectionUtils.CollectionFilter<DamagingProjectileAPI> filterMisses = new CollectionUtils.CollectionFilter<DamagingProjectileAPI>(){

        public boolean accept(DamagingProjectileAPI proj) {
            MissileAPI missile;
            if (!(proj.getOwner() != MS_drivechargerai.this.ship.getOwner() || proj instanceof MissileAPI && ((MissileAPI)proj).isFizzling())) {
                return false;
            }
            if (proj instanceof MissileAPI && (missile = (MissileAPI)proj).isFlare()) {
                return false;
            }
            return CollisionUtils.getCollides((Vector2f)proj.getLocation(), (Vector2f)Vector2f.add((Vector2f)proj.getLocation(), (Vector2f)((Vector2f)new Vector2f((ReadableVector2f)proj.getVelocity()).scale(3.0f)), null), (Vector2f)MS_drivechargerai.this.ship.getLocation(), (float)MS_drivechargerai.this.ship.getCollisionRadius()) && Math.abs(MathUtils.getShortestRotation((float)proj.getFacing(), (float)VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)MS_drivechargerai.this.ship.getLocation()))) <= 90.0f;
        }
    };

    private static float damageReader(ShipAPI ship, float damageWindowSeconds) {
        float accumulator = 0.0f;
        float shipFace = ship.getFacing();
        accumulator += MS_drivechargerai.beamReader(ship, damageWindowSeconds);
        for (DamagingProjectileAPI proj : Global.getCombatEngine().getProjectiles()) {
            if (proj.getOwner() == ship.getOwner()) continue;
            Vector2f endPoint = new Vector2f((ReadableVector2f)proj.getVelocity());
            endPoint.scale(damageWindowSeconds);
            Vector2f.add((Vector2f)endPoint, (Vector2f)proj.getLocation(), (Vector2f)endPoint);
            if (ship.getShield() != null && ship.getShield().isWithinArc(proj.getLocation()) || !CollisionUtils.getCollides((Vector2f)proj.getLocation(), (Vector2f)endPoint, (Vector2f)new Vector2f((ReadableVector2f)ship.getLocation()), (float)ship.getCollisionRadius()) || !(shipFace - 45.0f <= Math.abs(MathUtils.getShortestRotation((float)proj.getFacing(), (float)VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)ship.getLocation())))) && !(shipFace + 45.0f >= Math.abs(MathUtils.getShortestRotation((float)proj.getFacing(), (float)VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)ship.getLocation()))))) continue;
            accumulator += proj.getDamageAmount() + proj.getEmpAmount();
        }
        return accumulator;
    }

    private static float beamReader(ShipAPI ship, float damageWindowSeconds) {
        float accumulator = 0.0f;
        float shipFace = ship.getFacing();
        for (BeamAPI beam : Global.getCombatEngine().getBeams()) {
            float beamY;
            float beamX;
            float beamLoc;
            if (beam.getDamageTarget() != ship || !(shipFace - 45.0f <= Math.abs(MathUtils.getShortestRotation((float)(beamLoc = (beamX = beam.getFrom().x) + (beamY = beam.getFrom().y)), (float)VectorUtils.getAngle((Vector2f)beam.getFrom(), (Vector2f)ship.getLocation())))) && !(shipFace + 45.0f >= Math.abs(MathUtils.getShortestRotation((float)beamLoc, (float)VectorUtils.getAngle((Vector2f)beam.getFrom(), (Vector2f)ship.getLocation()))))) continue;
            float dps = beam.getWeapon().getDerivedStats().getDamageOver30Sec() / 30.0f;
            float emp = beam.getWeapon().getDerivedStats().getEmpPerSecond();
            accumulator += (dps + emp) * damageWindowSeconds;
        }
        return accumulator;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.engine = engine;
    }

    public void advance(float amount, Vector2f position, Vector2f collisionDanger, ShipAPI target) {
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        Vector2f shipLoc = new Vector2f((ReadableVector2f)this.ship.getLocation());
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            float incoming = MS_drivechargerai.damageReader(this.ship, 3.0f);
            this.THRESHHOLD = this.ship.getHitpoints() * 0.1f;
            float hitRad = Math.max(this.ship.getCollisionRadius(), 1250.0f);
            List nearbyThreats = CombatUtils.getProjectilesWithinRange((Vector2f)shipLoc, (float)hitRad);
            for (DamagingProjectileAPI tmp : this.engine.getProjectiles()) {
                if (!MathUtils.isWithinRange((Vector2f)tmp.getLocation(), (Vector2f)this.ship.getLocation(), (float)(this.ship.getCollisionRadius() + hitRad)) || !(tmp.getDamage().getDamage() > 400.0f)) continue;
                nearbyThreats.add(tmp);
            }
            nearbyThreats = CollectionUtils.filter((Collection)nearbyThreats, this.filterMisses);
            List nearbyMissiles = AIUtils.getNearbyEnemyMissiles((CombatEntityAPI)this.ship, (float)(this.ship.getCollisionRadius() + hitRad));
            for (MissileAPI missile : nearbyMissiles) {
                if (!missile.getEngineController().isTurningLeft() && !missile.getEngineController().isTurningRight() && missile.getDamage().getDamage() > 400.0f) continue;
                nearbyThreats.add(missile);
            }
            if ((this.ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.HAS_INCOMING_DAMAGE) || this.ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.MANEUVER_TARGET) || this.ship.isRetreating()) && !nearbyThreats.isEmpty() && this.THRESHHOLD * MathUtils.getRandomNumberInRange((float)0.8f, (float)1.2f) < incoming) {
                this.ship.useSystem();
            }
        }
    }
}

