/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_fighterFlareAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private ShipSystemAPI system;
    private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.2f);

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            if (this.system.isActive() || this.system.getCooldownRemaining() > 0.0f || this.system.getAmmo() <= 0 || this.ship.getFluxTracker().isOverloadedOrVenting()) {
                return;
            }
            float missilesNearby = 0.0f;
            List missiles = CombatUtils.getMissilesWithinRange((Vector2f)this.ship.getLocation(), (float)450.0f);
            for (MissileAPI missile : missiles) {
                if (missile.getOwner() == this.ship.getOwner() || missile.isFlare()) continue;
                WeaponAPI weapon = missile.getWeapon();
                if (weapon == null) {
                    if (MathUtils.getShortestRotation((float)missile.getFacing(), (float)Vector2f.angle((Vector2f)missile.getLocation(), (Vector2f)this.ship.getLocation())) > 135.0f) continue;
                    missilesNearby += 1.5f * missile.getDamageAmount() / 100.0f;
                    continue;
                }
                if (weapon.hasAIHint(WeaponAPI.AIHints.ANTI_FTR) || weapon.hasAIHint(WeaponAPI.AIHints.HEATSEEKER)) {
                    missilesNearby += 2.0f * missile.getDamageAmount() / 100.0f;
                    continue;
                }
                if (weapon.hasAIHint(WeaponAPI.AIHints.DO_NOT_AIM)) {
                    if (MathUtils.getShortestRotation((float)missile.getFacing(), (float)Vector2f.angle((Vector2f)missile.getLocation(), (Vector2f)this.ship.getLocation())) > 135.0f) continue;
                    missilesNearby += 1.5f * missile.getDamageAmount() / 100.0f;
                    continue;
                }
                if (!weapon.hasAIHint(WeaponAPI.AIHints.GUIDED_POOR) || MathUtils.getShortestRotation((float)missile.getFacing(), (float)Vector2f.angle((Vector2f)missile.getLocation(), (Vector2f)this.ship.getLocation())) > 90.0f) continue;
                missilesNearby += missile.getDamageAmount() / 100.0f;
            }
            if (missilesNearby >= 30.0f) {
                this.ship.useSystem();
            }
        }
    }
}

