/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.MS_Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_mimirSlideDriveAI
implements ShipSystemAIScript {
    private static final float SECONDS_FOR_PATH = 1.5f;
    private static final float SECONDS_TO_LOOK_AHEAD = 3.0f;
    private float bashNum = 0.0f;
    private final CollectionUtils.CollectionFilter<DamagingProjectileAPI> filterMisses = new CollectionUtils.CollectionFilter<DamagingProjectileAPI>(){

        public boolean accept(DamagingProjectileAPI proj) {
            MissileAPI missile;
            if (!(proj.getOwner() != MS_mimirSlideDriveAI.this.ship.getOwner() || proj instanceof MissileAPI && ((MissileAPI)proj).isFizzling())) {
                return false;
            }
            if (proj instanceof MissileAPI && (missile = (MissileAPI)proj).isFlare()) {
                return false;
            }
            return CollisionUtils.getCollides((Vector2f)proj.getLocation(), (Vector2f)Vector2f.add((Vector2f)proj.getLocation(), (Vector2f)((Vector2f)new Vector2f((ReadableVector2f)proj.getVelocity()).scale(3.0f)), null), (Vector2f)MS_mimirSlideDriveAI.this.ship.getLocation(), (float)MS_mimirSlideDriveAI.this.ship.getCollisionRadius()) && Math.abs(MathUtils.getShortestRotation((float)proj.getFacing(), (float)VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)MS_mimirSlideDriveAI.this.ship.getLocation()))) <= 90.0f;
        }
    };
    private static final Map<ShipAPI.HullSize, Float> mag = new HashMap<ShipAPI.HullSize, Float>();
    private String name;
    private CombatEngineAPI engine;
    private ShipAPI ship;
    private PersonAPI officer;
    private final boolean mission = false;
    private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.2f);

    private static Vector2f intercept(Vector2f point, float speed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - speed * speed;
        float b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        float c = difference.x * difference.x + difference.y * difference.y;
        Vector2f solutionSet = MS_mimirSlideDriveAI.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    private static Vector2f quad(float a, float b, float c) {
        Vector2f solution = null;
        if (Float.compare(Math.abs(a), 0.0f) == 0) {
            solution = Float.compare(Math.abs(b), 0.0f) == 0 ? (Float.compare(Math.abs(c), 0.0f) == 0 ? new Vector2f(0.0f, 0.0f) : null) : new Vector2f(-c / b, -c / b);
        } else {
            float d = b * b - 4.0f * a * c;
            if (d >= 0.0f) {
                d = (float)Math.sqrt(d);
                float e = 2.0f * a;
                solution = new Vector2f((-b - d) / e, (-b + d) / e);
            }
        }
        return solution;
    }

    protected String getPersonality(FleetMemberAPI member) {
        PersonAPI captain = member.getCaptain();
        if (captain != null) {
            switch (captain.getPersonalityAPI().getId()) {
                case "timid": {
                    this.name = "timid";
                    break;
                }
                case "cautious": {
                    this.name = "cautious";
                    break;
                }
                case "steady": {
                    this.name = "steady";
                    break;
                }
                case "aggressive": {
                    this.name = "aggressive";
                }
            }
        }
        return this.name;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        Vector2f shipLoc = new Vector2f((ReadableVector2f)this.ship.getLocation());
        Vector2f shipDir = new Vector2f((ReadableVector2f)this.ship.getVelocity());
        if (this.tracker.intervalElapsed()) {
            CombatFleetManagerAPI.AssignmentInfo assignment;
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            float incoming = MS_Utils.estimateIncomingDamage(this.ship);
            boolean shouldUseSystem = false;
            float hitRad = Math.max(this.ship.getCollisionRadius(), 50.0f);
            List nearbyThreats = CombatUtils.getProjectilesWithinRange((Vector2f)shipLoc, (float)hitRad);
            for (Object tmp : this.engine.getProjectiles()) {
                if (!MathUtils.isWithinRange((Vector2f)tmp.getLocation(), (Vector2f)this.ship.getLocation(), (float)(this.ship.getCollisionRadius() + hitRad))) continue;
                nearbyThreats.add(tmp);
            }
            nearbyThreats = CollectionUtils.filter((Collection)nearbyThreats, this.filterMisses);
            List nearbyMissiles = AIUtils.getNearbyEnemyMissiles((CombatEntityAPI)this.ship, (float)(this.ship.getCollisionRadius() + hitRad));
            for (MissileAPI missile : nearbyMissiles) {
                if (!missile.getEngineController().isTurningLeft() && !missile.getEngineController().isTurningRight()) continue;
                nearbyThreats.add(missile);
            }
            float crashRad = Math.max(this.ship.getCollisionRadius(), 1750.0f);
            List willCrash = CombatUtils.getShipsWithinRange((Vector2f)shipLoc, (float)crashRad);
            if (!willCrash.isEmpty()) {
                if (shipDir.lengthSquared() <= 0.01f) {
                    shipDir = VectorUtils.getDirectionalVector((Vector2f)shipLoc, (Vector2f)new Vector2f((ReadableVector2f)this.ship.getVelocity()));
                    Vector2f.sub((Vector2f)shipDir, (Vector2f)this.ship.getLocation(), (Vector2f)shipDir);
                    if (shipDir.lengthSquared() <= 0.01f) {
                        shipDir = new Vector2f(1.0f, 0.0f);
                    }
                }
                shipDir.normalise();
                shipDir.scale(crashRad);
                Vector2f.add((Vector2f)shipDir, (Vector2f)this.ship.getLocation(), (Vector2f)shipDir);
                Collections.sort(willCrash, new CollectionUtils.SortEntitiesByDistance(this.ship.getLocation()));
                ListIterator iter = willCrash.listIterator();
                while (iter.hasNext()) {
                    ShipAPI tmp = (ShipAPI)iter.next();
                    if (tmp == this.ship || this.ship.getCollisionClass() == CollisionClass.NONE || tmp.isFighter() || tmp.isDrone()) continue;
                    Vector2f bash = MS_mimirSlideDriveAI.intercept(this.ship.getLocation(), 1750.0f, tmp.getLocation(), tmp.getVelocity());
                    if (bash == null) {
                        Vector2f projection = new Vector2f((ReadableVector2f)tmp.getVelocity());
                        float scalar = MathUtils.getDistance((Vector2f)tmp.getLocation(), (Vector2f)this.ship.getLocation()) / 1500.0f;
                        projection.scale(scalar);
                        Vector2f.add((Vector2f)tmp.getLocation(), (Vector2f)projection, (Vector2f)bash);
                    }
                    if (bash == null || this.ship.getLocation() == null) continue;
                    float areaChange = 1.0f;
                    float aMass = this.ship.getMass();
                    float bMass = tmp.getMass();
                    if (!CollisionUtils.getCollides((Vector2f)this.ship.getLocation(), (Vector2f)shipDir, (Vector2f)bash, (float)(tmp.getCollisionRadius() * 0.5f + this.ship.getCollisionRadius() * 0.75f * areaChange))) continue;
                    if (tmp.getOwner() == this.ship.getOwner()) {
                        this.bashNum = bMass + aMass * 2.0f;
                        continue;
                    }
                    this.bashNum = bMass + aMass;
                }
            }
            Vector2f targetSpot = (assignment = this.engine.getFleetManager(this.ship.getOwner()).getTaskManager(false).getAssignmentFor(this.ship)) != null && assignment.getTarget() != null ? assignment.getTarget().getLocation() : null;
            if (!nearbyThreats.isEmpty() && this.bashNum == 0.0f || !nearbyThreats.isEmpty() && this.bashNum * MathUtils.getRandomNumberInRange((float)0.8f, (float)1.2f) < incoming || nearbyThreats.isEmpty() && this.bashNum == 0.0f && targetSpot == null && Math.random() > 0.5) {
                shouldUseSystem = true;
            }
            if (this.ship.getSystem().isActive() ^ shouldUseSystem) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.engine = engine;
        this.ship = ship;
    }

    static {
        mag.put(ShipAPI.HullSize.FIGHTER, Float.valueOf(0.0f));
        mag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(0.4f));
        mag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(0.6f));
        mag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(0.8f));
        mag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(1.0f));
    }
}

