/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_minosPingAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private ShipSystemAPI system;
    private final IntervalUtil tracker = new IntervalUtil(0.35f, 0.6f);
    private CombatEngineAPI engine;

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        Vector2f shipLoc = new Vector2f((ReadableVector2f)this.ship.getLocation());
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            List friends = AIUtils.getAlliesOnMap((CombatEntityAPI)this.ship);
            List enemies = AIUtils.getEnemiesOnMap((CombatEntityAPI)this.ship);
            float totalFriends = 0.0f;
            float allyECM = 0.0f;
            float enemyECM = 0.0f;
            for (ShipAPI friend : friends) {
                if (friend.isHulk() && friend.isFighter()) continue;
                totalFriends += 1.0f;
                allyECM += friend.getMutableStats().getEccmChance().base;
            }
            for (ShipAPI enemy : enemies) {
                if (enemy.isHulk() && enemy.isFighter()) continue;
                enemyECM += enemy.getMutableStats().getEccmChance().base;
            }
            float sensorRange = this.ship.getMutableStats().getSensorStrength().base;
            List detected = AIUtils.getNearbyEnemies((CombatEntityAPI)this.ship, (float)sensorRange);
            if (detected.isEmpty() && !this.system.isActive() || enemyECM > allyECM && allyECM + totalFriends > enemyECM && !this.system.isActive()) {
                this.ship.useSystem();
            }
        }
    }
}

