/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_pmineAI
implements ShipSystemAIScript {
    private static final String MINE_ID = "ms_pmine";
    private static final float MINE_WITHIN_RANGE = 500.0f;
    private static final int MAX_MINES_PER_OBJECTIVE = 2;
    private ShipAPI ship;

    private static int getMinesAroundObjective(BattleObjectiveAPI objective, int owner) {
        int totalMines = 0;
        for (DamagingProjectileAPI tmp : CombatUtils.getProjectilesWithinRange((Vector2f)objective.getLocation(), (float)500.0f)) {
            if (tmp.getOwner() != owner || !MINE_ID.equals(tmp.getProjectileSpecId())) continue;
            ++totalMines;
        }
        return totalMines;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
            return;
        }
        BattleObjectiveAPI nearestObjective = AIUtils.getNearestObjective((CombatEntityAPI)this.ship);
        if (nearestObjective == null) {
            return;
        }
        if (MathUtils.getDistance((Vector2f)this.ship.getLocation(), (Vector2f)nearestObjective.getLocation()) < 500.0f && MS_pmineAI.getMinesAroundObjective(nearestObjective, this.ship.getOwner()) < 2) {
            this.ship.useSystem();
        }
    }
}

