/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_reisAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private ShipSystemAPI system;
    private CombatEngineAPI engine;
    private boolean runOnce = false;
    private boolean allyBlock = false;
    private List<WeaponAPI> weapons;
    private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.2f);
    private static final float LOOK_AHEAD_TIME = 0.067f;

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
        this.engine = engine;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine.isPaused() || this.engine == null) {
            return;
        }
        if (!this.runOnce) {
            this.weapons = this.ship.getAllWeapons();
            this.runOnce = true;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            boolean shouldUseSystem = false;
            for (WeaponAPI w : this.weapons) {
                if (!w.getId().equals("ms_stopper1")) continue;
                List nearbyShips = CombatUtils.getShipsWithinRange((Vector2f)this.ship.getLocation(), (float)800.0f);
                for (ShipAPI drive : nearbyShips) {
                    if (drive.isFighter() || drive.isHulk()) continue;
                    Vector2f loc = drive.getLocation();
                    Vector2f ahead = new Vector2f((ReadableVector2f)loc).translate(drive.getVelocity().getX() * 0.067f, drive.getVelocity().getY() * 0.067f);
                    this.allyBlock = drive.getOwner() == this.ship.getOwner() && MathUtils.getShortestRotation((float)w.getArcFacing(), (float)Vector2f.angle((Vector2f)w.getLocation(), (Vector2f)ahead)) < 10.0f && MathUtils.getDistance((Vector2f)ahead, (Vector2f)w.getLocation()) < 600.0f;
                    List shipEngines = drive.getEngineController().getShipEngines();
                    for (ShipEngineControllerAPI.ShipEngineAPI shipEngine : shipEngines) {
                        if (drive.getOwner() == this.ship.getOwner() || shipEngine.isDisabled() || !(MathUtils.getShortestRotation((float)w.getArcFacing(), (float)Vector2f.angle((Vector2f)w.getLocation(), (Vector2f)ahead)) < 10.0f) || !(MathUtils.getDistance((Vector2f)ahead, (Vector2f)w.getLocation()) < 600.0f) || this.allyBlock) continue;
                        shouldUseSystem = true;
                    }
                }
            }
            if (this.ship.getSystem().isActive() ^ shouldUseSystem) {
                this.ship.useSystem();
            }
        }
    }
}

