/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class MS_siegemodeAI
implements ShipSystemAIScript {
    private ShipSystemAPI system;
    private ShipAPI ship;
    private ShipwideAIFlags flags;
    private float siegeModeTrigger;
    private float siegeModeTriggerMin;
    private float siegeModeTriggerMax;

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
        this.flags = flags;
        if (ship.getShield().getType() == ShieldAPI.ShieldType.FRONT) {
            this.siegeModeTrigger = 265.0f;
            this.siegeModeTriggerMin = 120.0f;
            this.siegeModeTriggerMax = 240.0f;
        } else if (ship.getShield().getType() == ShieldAPI.ShieldType.OMNI) {
            this.siegeModeTrigger = 60.0f;
            this.siegeModeTriggerMin = 30.0f;
            this.siegeModeTriggerMax = 330.0f;
        } else {
            this.siegeModeTrigger = 999.0f;
            this.siegeModeTriggerMin = 999.0f;
            this.siegeModeTriggerMax = 0.0f;
        }
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        boolean shieldExtensionNeeded = false;
        if (this.ship.getShield().getActiveArc() > this.siegeModeTrigger) {
            float relativeFacing;
            float facing = this.ship.getShield().getFacing();
            if (missileDangerDir != null) {
                for (CombatEntityAPI entity : AIUtils.getNearbyEnemyMissiles((CombatEntityAPI)this.ship, (float)800.0f)) {
                    relativeFacing = MathUtils.clampAngle((float)(VectorUtils.getFacing((Vector2f)VectorUtils.getDirectionalVector((Vector2f)this.ship.getLocation(), (Vector2f)entity.getLocation())) - facing));
                    if (!(relativeFacing < this.siegeModeTriggerMax) || !(relativeFacing > this.siegeModeTriggerMin)) continue;
                    shieldExtensionNeeded = true;
                    break;
                }
            }
            if (!shieldExtensionNeeded) {
                for (ShipAPI shp : AIUtils.getNearbyEnemies((CombatEntityAPI)this.ship, (float)1600.0f)) {
                    if (shp.getFluxTracker().isOverloaded() && shp.getFluxTracker().getOverloadTimeRemaining() > 1.8f || shp.getFluxTracker().isVenting() && shp.getFluxTracker().getTimeToVent() > 1.8f || !((relativeFacing = MathUtils.clampAngle((float)(VectorUtils.getFacing((Vector2f)VectorUtils.getDirectionalVector((Vector2f)this.ship.getLocation(), (Vector2f)shp.getLocation())) - facing))) < this.siegeModeTriggerMax) || !(relativeFacing > this.siegeModeTriggerMin)) continue;
                    shieldExtensionNeeded = true;
                    break;
                }
            }
        }
        if (shieldExtensionNeeded || this.flags.hasFlag(ShipwideAIFlags.AIFlags.TURN_QUICKLY)) {
            this.activateSystem();
        } else {
            this.deactivateSystem();
        }
    }

    private void deactivateSystem() {
        if (this.system.isOn()) {
            this.ship.useSystem();
        }
    }

    private void activateSystem() {
        if (!this.system.isOn()) {
            this.ship.useSystem();
        }
    }
}

