/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.FluxTrackerAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_tagAI
implements ShipSystemAIScript {
    private static final float RANGE = 800.0f;
    private static final float RANGE_CHECK = 1000.0f;
    private static final float ANGLE_TOLERANCE = 10.0f;
    private static final float RANDOM_USE_CHANCE = 0.9f;
    private static final float FLUX_TOLERANCE = 0.9f;
    private static final float PRESENCE_CAP = 100.0f;
    private static final float PRESENCE_FLOOR = 0.0f;
    private static final float FIGHTER_WEIGHT = 1.0f;
    private static final float FRIGATE_WEIGHT = 4.0f;
    private static final float DESTROYER_WEIGHT = 8.0f;
    private static final float CRUISER_WEIGHT = 16.0f;
    private static final float CAPITAL_WEIGHT = 32.0f;
    private final IntervalUtil tracker = new IntervalUtil(0.25f, 0.5f);
    private float priority = 0.0f;
    private ShipAPI ship;
    private ShipSystemAPI system;

    private static Vector2f intercept(Vector2f point, float speed, Vector2f target, Vector2f targetVel) {
        Vector2f difference = new Vector2f(target.x - point.x, target.y - point.y);
        float a = targetVel.x * targetVel.x + targetVel.y * targetVel.y - speed * speed;
        float b = 2.0f * (targetVel.x * difference.x + targetVel.y * difference.y);
        float c = difference.x * difference.x + difference.y * difference.y;
        Vector2f solutionSet = MS_tagAI.quad(a, b, c);
        Vector2f intercept = null;
        if (solutionSet != null) {
            float bestFit = Math.min(solutionSet.x, solutionSet.y);
            if (bestFit < 0.0f) {
                bestFit = Math.max(solutionSet.x, solutionSet.y);
            }
            if (bestFit > 0.0f) {
                intercept = new Vector2f(target.x + targetVel.x * bestFit, target.y + targetVel.y * bestFit);
            }
        }
        return intercept;
    }

    private static Vector2f quad(float a, float b, float c) {
        Vector2f solution = null;
        if (Float.compare(Math.abs(a), 0.0f) == 0) {
            solution = Float.compare(Math.abs(b), 0.0f) == 0 ? (Float.compare(Math.abs(c), 0.0f) == 0 ? new Vector2f(0.0f, 0.0f) : null) : new Vector2f(-c / b, -c / b);
        } else {
            float d = b * b - 4.0f * a * c;
            if (d >= 0.0f) {
                d = (float)Math.sqrt(d);
                float e = 2.0f * a;
                solution = new Vector2f((-b - d) / e, (-b + d) / e);
            }
        }
        return solution;
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (Global.getCombatEngine().isPaused() || Global.getCombatEngine() == null) {
            return;
        }
        this.tracker.advance(amount);
        Vector2f shipLoc = new Vector2f((ReadableVector2f)this.ship.getLocation());
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            boolean shouldUseSystem = false;
            List nearbyShips = CombatUtils.getShipsWithinRange((Vector2f)shipLoc, (float)800.0f);
            for (ShipAPI tracking : nearbyShips) {
                float usageChance;
                if (tracking.getOwner() == this.ship.getOwner()) continue;
                Vector2f track = MS_tagAI.intercept(this.ship.getLocation(), 1000.0f, tracking.getLocation(), tracking.getVelocity());
                if (track != null && this.ship.getLocation() != null) {
                    this.priority = MathUtils.getRandomNumberInRange((float)0.3f, (float)0.6f);
                }
                float angle = MathUtils.getShortestRotation((float)this.ship.getFacing(), (float)Vector2f.angle((Vector2f)this.ship.getLocation(), (Vector2f)tracking.getLocation()));
                ShieldAPI shield = tracking.getShield();
                FluxTrackerAPI fluxer = tracking.getFluxTracker();
                if (tracking.getCollisionClass() != CollisionClass.NONE && angle < 10.0f && (usageChance = (float)(Math.random() - (double)(this.getAlliedPresence(tracking, 800.0f) / 100.0f))) < 0.9f) {
                    shouldUseSystem = true;
                }
                if (!(this.ship.getSystem().isActive() ^ shouldUseSystem)) continue;
                this.ship.useSystem();
            }
        }
    }

    public float getAlliedPresence(ShipAPI target, float range) {
        List allies = AIUtils.getNearbyAllies((CombatEntityAPI)this.ship, (float)range);
        float presence = 0.0f;
        for (ShipAPI ally : allies) {
            if (ally.isRetreating()) continue;
            switch (ally.getHullSize()) {
                case FIGHTER: {
                    presence += 1.0f;
                    break;
                }
                case FRIGATE: {
                    presence += 4.0f;
                    break;
                }
                case DESTROYER: {
                    presence += 8.0f;
                    break;
                }
                case CRUISER: {
                    presence += 16.0f;
                    break;
                }
                case CAPITAL_SHIP: {
                    presence += 32.0f;
                }
            }
        }
        if (presence > 100.0f) {
            return 100.0f;
        }
        if (presence < 0.0f) {
            return 0.0f;
        }
        return presence;
    }
}

