/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_telemetryAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipSystemAPI system;
    private float nominalRange = 0.0f;
    private float activeRange = 0.0f;
    private final IntervalUtil tracker = new IntervalUtil(0.35f, 0.6f);
    private boolean runOnce = false;

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
        this.system = system;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine.isPaused() || this.ship.getShipAI() == null) {
            return;
        }
        if (!this.runOnce) {
            this.runOnce = true;
            List weapons = this.ship.getAllWeapons();
            int i = 0;
            for (WeaponAPI w : weapons) {
                if (w.getType() != WeaponAPI.WeaponType.ENERGY && w.getType() != WeaponAPI.WeaponType.BALLISTIC && w.getType() == WeaponAPI.WeaponType.MISSILE || !(w.getRange() > 200.0f) || w.hasAIHint(WeaponAPI.AIHints.PD)) continue;
                this.nominalRange += w.getRange();
                ++i;
            }
            this.nominalRange /= (float)i;
            this.activeRange = this.nominalRange * 1.33f;
        }
        this.tracker.advance(amount);
        Vector2f shipLoc = new Vector2f((ReadableVector2f)this.ship.getLocation());
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            if (target == null) {
                return;
            }
            boolean shouldUseSystem = false;
            List nearbyShips = CombatUtils.getShipsWithinRange((Vector2f)shipLoc, (float)this.activeRange);
            for (ShipAPI tracking : nearbyShips) {
                float closestDistance = Float.MAX_VALUE;
                for (ShipAPI tmp : AIUtils.getNearbyEnemies((CombatEntityAPI)this.ship, (float)this.activeRange)) {
                    float distance = MathUtils.getDistance((CombatEntityAPI)tmp, (Vector2f)this.ship.getLocation());
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                }
                if (tracking.getOwner() == this.ship.getOwner() || tracking.isHulk() || tracking.isFighter() || !nearbyShips.isEmpty() && closestDistance < this.nominalRange || nearbyShips.isEmpty() || nearbyShips.isEmpty() || !(closestDistance > this.nominalRange) || !(closestDistance < this.activeRange)) continue;
                shouldUseSystem = true;
            }
            if (this.ship.getSystem().isActive() ^ shouldUseSystem) {
                this.ship.useSystem();
            }
        }
    }
}

