/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts.ai;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.FluxTrackerAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.MS_Utils;
import java.util.Collection;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MS_woopDriveAI
implements ShipSystemAIScript {
    private static final float SECONDS_TO_LOOK_AHEAD = 3.0f;
    private static final float RANGE_TO_CHECK = 2500.0f;
    private static final float EDGE_CHECK = 700.0f;
    private final CollectionUtils.CollectionFilter<DamagingProjectileAPI> filterMisses = new CollectionUtils.CollectionFilter<DamagingProjectileAPI>(){

        public boolean accept(DamagingProjectileAPI proj) {
            MissileAPI missile;
            if (!(proj.getOwner() != MS_woopDriveAI.this.ship.getOwner() || proj instanceof MissileAPI && ((MissileAPI)proj).isFizzling())) {
                return false;
            }
            if (proj instanceof MissileAPI && (missile = (MissileAPI)proj).isFlare()) {
                return false;
            }
            return CollisionUtils.getCollides((Vector2f)proj.getLocation(), (Vector2f)Vector2f.add((Vector2f)proj.getLocation(), (Vector2f)((Vector2f)new Vector2f((ReadableVector2f)proj.getVelocity()).scale(3.0f)), null), (Vector2f)MS_woopDriveAI.this.ship.getLocation(), (float)MS_woopDriveAI.this.ship.getCollisionRadius()) && Math.abs(MathUtils.getShortestRotation((float)proj.getFacing(), (float)VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)MS_woopDriveAI.this.ship.getLocation()))) <= 90.0f;
        }
    };
    private float mapX;
    private float mapY;
    private ShipAPI ship;
    private boolean runOnce = false;
    private final IntervalUtil tracker = new IntervalUtil(0.1f, 0.2f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine == null || engine.isPaused()) {
            return;
        }
        if (!this.runOnce) {
            this.runOnce = true;
            this.mapX = engine.getMapWidth();
            this.mapY = engine.getMapHeight();
        }
        FluxTrackerAPI fluxer = this.ship.getFluxTracker();
        this.tracker.advance(amount);
        Vector2f shipLoc = new Vector2f((ReadableVector2f)this.ship.getLocation());
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            float incoming = MS_Utils.estimateIncomingDamage(this.ship);
            boolean shouldUseSystem = false;
            boolean clear = true;
            float hitRad = Math.max(this.ship.getCollisionRadius(), 100.0f);
            List nearbyThreats = CombatUtils.getProjectilesWithinRange((Vector2f)shipLoc, (float)hitRad);
            for (Object tmp : engine.getProjectiles()) {
                if (!MathUtils.isWithinRange((Vector2f)tmp.getLocation(), (Vector2f)this.ship.getLocation(), (float)(this.ship.getCollisionRadius() + hitRad))) continue;
                nearbyThreats.add(tmp);
            }
            nearbyThreats = CollectionUtils.filter((Collection)nearbyThreats, this.filterMisses);
            List nearbyMissiles = AIUtils.getNearbyEnemyMissiles((CombatEntityAPI)this.ship, (float)(this.ship.getCollisionRadius() + hitRad));
            for (MissileAPI missile : nearbyMissiles) {
                if (!missile.getEngineController().isTurningLeft() && !missile.getEngineController().isTurningRight()) continue;
                nearbyThreats.add(missile);
            }
            List ships = CombatUtils.getShipsWithinRange((Vector2f)shipLoc, (float)700.0f);
            for (ShipAPI s : ships) {
                if (!MathUtils.isWithinRange((Vector2f)s.getLocation(), (Vector2f)shipLoc, (float)700.0f) || !(VectorUtils.getAngle((Vector2f)s.getLocation(), (Vector2f)shipLoc) > 170.0f)) continue;
                clear = false;
            }
            if (this.ship.getLocation().x + 700.0f > this.mapX || this.ship.getLocation().y + 700.0f > this.mapY || this.ship.getLocation().x - 700.0f < this.mapX || this.ship.getLocation().y - 700.0f < this.mapY) {
                clear = false;
            }
            if (!nearbyThreats.isEmpty() && this.ship.getShield().isOn() && fluxer.getCurrFlux() >= fluxer.getMaxFlux() * 0.8f && incoming >= fluxer.getMaxFlux() * 0.2f || !nearbyThreats.isEmpty() && this.ship.getShield().isOff() && incoming >= this.ship.getHitpoints() * 0.25f || this.ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.RUN_QUICKLY) && !AIUtils.getNearbyEnemies((CombatEntityAPI)this.ship, (float)2500.0f).isEmpty() && clear) {
                shouldUseSystem = true;
            }
            if (this.ship.getSystem().isActive() ^ shouldUseSystem) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
    }
}

