local os = GLOBAL.os

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS

STRINGS.NAMES.SCIMITAR = "䵶"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SCIMITAR = "Ƹ֮Դ"

local player_name = "wili"

PrefabFiles = {
	"wili",
	"scimitar",
}

local attack_name = {"bee", "killerbee", "flies", "mosquito", "frog", "beefalo", "lightninggoat", "pigman", "pigguard",
 "bunnyman", "merm", "spider_hider", "spider_spitter", "spider", "spider_warrior", "spiderqueen", "spider_dropper", "hound",
 "firehound", "icehound", "tentacle", "leif", "leif_sparse", "walrus", "teenbird", "tallbird", "koalefant_summer",
 "koalefant_winDter", "penguin", "slurtle", "snurtle", "bat", "rocky", "monkey", "slurper", "buzzard", "knight", "bishop",
 "rook", "crawlinghorror", "terrorbeak", "deerclops", "minotaur", "worm", "abigail", "ghost", "shadowwaxwell", "krampus",
 "glommer", "lureplant", "eyeplant", "moose", "mossling", "dragonfly", "warg", "bearger", "birchnutdrake"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/wili.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wili.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wili.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wili.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wili_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wili_silho.xml" ),
	
	Asset("IMAGE", "images/wili.tex"),
	Asset("ATLAS", "images/wili.xml"),

    Asset( "IMAGE", "bigportraits/wili.tex" ),
    Asset( "ATLAS", "bigportraits/wili.xml" ),
	
	--scimitar--
	Asset("ANIM", "anim/scimitar.zip"),
	Asset("ANIM", "anim/swap_scimitar.zip"),
	Asset("ATLAS", "images/inventoryimages/scimitar.xml"),

}

AddMinimapAtlas("images/wili.xml")

--˽кȡ
local getrandom = function()
	math.randomseed(tostring(os.time()):reverse():sub(1, 6))
	math.random(100)
	math.random(100)
	math.random(100)
	math.random(100)
	return math.random(100)
end

AddModCharacter(player_name)
function wiliPostInit(inst)
	local scimitarRecipe = GLOBAL.Recipe("scimitar", {Ingredient("nightmarefuel", 2),Ingredient("goldnugget", 2),Ingredient("walrus_tusk", 1)}, RECIPETABS.WAR, {SCIENCE =0} )
	scimitarRecipe.atlas = "images/inventoryimages/scimitar.xml"
	
end
--䵶Ʒ
AddSimPostInit(function(inst)
	if inst.prefab == player_name then
		wiliPostInit(inst)
	end
end)
--д˽ʳ
local function PigOnGetItemFromPlayer(inst, giver, item)
    
    --I eat food
    if item.components.edible then
        --meat makes us friends (unless I'm a guard)
        if item.components.edible.foodtype == "MEAT" or item.components.edible.foodtype == "HORRIBLE" then
            if inst.components.combat.target and inst.components.combat.target == giver then
                inst.components.combat:SetTarget(nil)
            elseif giver.components.leader and not inst:HasTag("guard") then
				--inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
				--giver.components.leader:AddFollower(inst)
                --inst.components.follower:AddLoyaltyTime(item.components.edible:GetHunger() * TUNING.PIG_LOYALTY_PER_HUNGER)
            end
        end
        if inst.components.sleeper:IsAsleep() then
            inst.components.sleeper:WakeUp()
        end
    end

    
    --I wear hats
    if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if current then
            inst.components.inventory:DropItem(current)
        end
        
        inst.components.inventory:Equip(item)
        inst.AnimState:Show("hat")
    end
end
--д˽Ʒ
local function BunnyOnGetItemFromPlayer(inst, giver, item)
    
    --I eat food
    if item.components.edible then
        if (item.prefab == "carrot" or item.prefab == "carrot_cooked") then
            if inst.components.combat.target and inst.components.combat.target == giver then
                inst.components.combat:SetTarget(nil)
            elseif giver.components.leader then
				--inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
				--giver.components.leader:AddFollower(inst)
                --inst.components.follower:AddLoyaltyTime(TUNING.RABBIT_CARROT_LOYALTY)
            end
        end

        if inst.components.sleeper:IsAsleep() then
            inst.components.sleeper:WakeUp()
        end
    end

    
    --I wear hats
    if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if current then
            inst.components.inventory:DropItem(current)
        end
        
        inst.components.inventory:Equip(item)
        inst.AnimState:Show("hat")
    end
end
--дʯϺƷ
local function RockyOnGetItemFromPlayer(inst, giver, item)
    if item.components.edible and item.components.edible.foodtype == "ELEMENTAL" then
            if inst.components.combat.target and inst.components.combat.target == giver then
                inst.components.combat:SetTarget(nil)
            elseif giver.components.leader then
                --inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
                --giver.components.leader:AddFollower(inst)
                --inst.components.follower:AddLoyaltyTime(TUNING.ROCKY_LOYALTY)
                --inst.sg:GoToState("rocklick")
            end
    end

    if inst.components.sleeper:IsAsleep() then
        inst.components.sleeper:WakeUp()
    end
end
--˲ܳΪѻ
local function pigmanfriend(inst)
	local GetPlayer = GLOBAL.GetPlayer
	if GetPlayer().prefab == player_name then
		inst.components.trader.onaccept = PigOnGetItemFromPlayer
	end
end
--˲ܳΪѻ
local function bunnymanfriend(inst)
	local GetPlayer = GLOBAL.GetPlayer
	if GetPlayer().prefab == player_name then
		inst.components.trader.onaccept = BunnyOnGetItemFromPlayer
	end
end
--ʯϺܳΪѻ
local function rockyfriend(inst)
	local GetPlayer = GLOBAL.GetPlayer
	if GetPlayer().prefab == player_name then
		inst.components.trader.onaccept = RockyOnGetItemFromPlayer
	end
end
--ܼܼ
local function onattack(inst, data)
	--data.target.components.talker:Say(tostring(inst.components.combat.tempdamage))
	if data.target.prefab == player_name then
		if getrandom() <= 35 then
			inst.components.combat:SetDefaultDamage(0)
		else
			inst.components.combat:SetDefaultDamage(inst.components.combat.tempdamage)
		end
	else
		inst.components.combat:SetDefaultDamage(inst.components.combat.tempdamage)
	end
end
--ܼܻ
local function dodge(inst)
	local GetPlayer = GLOBAL.GetPlayer
	if GetPlayer().prefab == player_name and inst.components.combat then
		inst.components.combat.tempdamage = inst.components.combat.defaultdamage
		inst:ListenForEvent("onattackother", onattack)
	end
end

--main--
--ΪбϵӹΪ0˹ܼܣ
for k,v in pairs(attack_name) do
	AddPrefabPostInit (v, dodge)
end
--ˡˡʯϺܳΪ
AddPrefabPostInit ('pigman', pigmanfriend)
AddPrefabPostInit ('bunnyman', bunnymanfriend)
AddPrefabPostInit ('rocky', rockyfriend)

local function init_flower(inst)
	if GLOBAL.GetPlayer().prefab == player_name then
		local function onpickedfn(inst, picker)
			inst:Remove()
		end
		inst.components.pickable.onpickedfn = onpickedfn
	end
end
local function WritheMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "wili" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
			delay = 0,
            appearsound = "dontstarve/maxwell/appear_adventure",
			voice = "dontstarve/maxwell/talk_LP",
			appearanim = "appear",
			idleanim= "idle",
			dialogpreanim = "dialog_pre",
			dialoganim="dial_loop",
			dialogpostanim = "dialog_pst",
			disappearanim = "disappear",
            disableplayer = true,
            skippable = false,
            {
                string = "    һ    ",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "Ҫ        Щ     ",
                wait = 3,
                anim = nil,
                sound = nil,
            }
		}
    end
end
--񻨲ظԲ
AddPrefabPostInit ('flower', init_flower)
--д˹ΤֶԻ
AddPrefabPostInit("maxwellintro", WritheMaxwellIntro)
local function init_chester(inst)
	if GLOBAL.GetPlayer().prefab == player_name then
		inst:AddTag("notarget")
		--table.remove(inst.components.health)
		inst:RemoveComponent("combat")
	end
end
AddPrefabPostInit("chester", init_chester)