local assets =
{	
	Asset("ANIM", "anim/scimitar.zip"),
	Asset("ANIM", "anim/swap_scimitar.zip"),
	Asset ("ATLAS", "images/inventoryimages/scimitar.xml")
}

local gem = {
	"redgem", "bluegem", "purplegem", "greengem", "orangegem", "yellowgem"
}

local getrandom = function()
	math.randomseed(tostring(os.time()):reverse():sub(1, 6))
	math.random(600)
	math.random(600)
	math.random(600)
	math.random(600)
	return math.random(600)
end

local function onfinished(inst)
	inst:Remove()
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_scimitar", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onattack(inst, owner, target)
	local x,y,z = inst.Transform:GetWorldPosition()
	local a,b,c = target.Transform:GetWorldPosition()
	if (x-a)*(x-a) + (y-b)*(y-b) + (z-c)*(z-c) > 4.0 then
		owner.Transform:SetPosition(target.Transform:GetWorldPosition())
	end
	--owner.Transform:SetPosition(target.Transform:GetWorldPosition())
	local num = getrandom()
	if num <= 6 then
		local pt = target:GetPosition()
        local st_pt =  FindWalkableOffset(pt or owner:GetPosition(), math.random()*2*PI, 2, 3)
        if st_pt then
            st_pt = st_pt + pt
			local st = SpawnPrefab(gem[num])
			st.Transform:SetPosition(st_pt.x, st_pt.y, st_pt.z)
        end
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()	
    MakeInventoryPhysics(inst)
    
    anim:SetBank("nightmaresword")
    anim:SetBuild("scimitar")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)
	inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE, TUNING.BOOMERANG_DISTANCE+2)
	inst.components.weapon.onattack = onattack

    -------
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/scimitar.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip)
	

    
    return inst
end

return Prefab( "common/inventory/scimitar", fn, assets)