
local MakePlayerCharacter = require "prefabs/player_common"

local weapon_name = {"axe", "goldenaxe", "hammer", "pickaxe", "goldenpickaxe", "shovel", "goldenshovel", "bugnet",
 "fishingrod", "multitool_axe_pickaxe", "cane", "umbrella", "grass_umbrella", "torch", "lantern", "spear",
 "tentaclespike", "hambat", "nightsword"
} --"batbat", "ruins_bat",

local start_inv = {
	"scimitar",
}

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
		
		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/wili.zip" ),
		Asset("SOUNDPACKAGE", "sound/wili.fev"),
		Asset("SOUND", "sound/wili_bank00.fsb"),
		--Asset( "ANIM", "anim/wili_fed.zip" ),
		--Asset( "ANIM", "anim/wili_starved.zip" ),
		--Asset( "ANIM", "anim/wili_sunlight.zip" ),
		--Asset( "ANIM", "anim/wili_nightmare.zip" ),
}
local prefabs = {}


--starregen parameters: first parameter = tick size. second parameter = tick frequency

local getrandom = function()
	math.randomseed(tostring(os.time()):reverse():sub(1, 6))
	math.random(100)
	math.random(100)
	math.random(100)
	math.random(100)
	return math.random(100)
end

--test function. It's useless.
local testkey = function(inst, data)
	local say = ""
	for k,v in pairs(data) do
		say = say.."|"..tostring(k)
	end
	inst.components.talker:Say(say)
end
--ɱܺ
local changedamage = function(inst, data)
	if getrandom() > 95 then
		inst.SoundEmitter:PlaySound("wili/skill/coup_de_grace")
		inst.components.combat.damagemultiplier = 9999--
		inst.components.talker:Say("!")
	else
		inst.components.combat.damagemultiplier = 1
	end
end
--ͻϮܹͨ
local function onattack(inst, owner, target)
	local x,y,z = inst.Transform:GetWorldPosition()
	local a,b,c = target.Transform:GetWorldPosition()
	if (x-a)*(x-a) + (y-b)*(y-b) + (z-c)*(z-c) > 4.0 then
		owner.Transform:SetPosition(target.Transform:GetWorldPosition())
	end
end

--ͻϮѪ
local function batbat_attack(inst, owner, target)
	onattack(inst, owner, target)
    if owner.components.health and owner.components.health:GetPercent() < 1 and not target:HasTag("wall") then
        owner.components.health:DoDelta(TUNING.BATBAT_DRAIN,false,"batbat")
        owner.components.sanity:DoDelta(-TUNING.BATBAT_DRAIN * 0.5)
    end
end
--ͻϮԶŰ
local function ruins_bat_attack(inst, owner, target)
	onattack(inst, owner, target)
    if math.random() < summonchance then
        local pt = target:GetPosition()
        local st_pt =  FindWalkableOffset(pt or owner:GetPosition(), math.random()*2*PI, 2, 3)
        if st_pt then
            inst.SoundEmitter:PlaySound("dontstarve/common/shadowTentacleAttack_1")
            inst.SoundEmitter:PlaySound("dontstarve/common/shadowTentacleAttack_2")            
            st_pt = st_pt + pt
            local st = SpawnPrefab("shadowtentacle")
            st.Transform:SetPosition(st_pt.x, st_pt.y, st_pt.z)
            st.components.combat:SetTarget(target)
        end
    end
end
--˽кжϱǷvalue
local function table_contains(value)
	for k,v in pairs(weapon_name) do
		if v == value then
			return true
		end
	end
	return false
end
--ͻϮ
local function changeweapon(inst)
	local hand = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	if  hand and hand.components.weapon then
		hand.components.weapon.temp_attack = hand.components.weapon.onattack--洢ԭʼװʱع
		local thename = hand.prefab
		if thename == "batbat" then
			hand.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE, TUNING.BOOMERANG_DISTANCE + 1)
			hand.components.weapon.onattack = batbat_attack
		elseif thename == "ruins_bat" then
			hand.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE, TUNING.BOOMERANG_DISTANCE + 1)
			hand.components.weapon.onattack = ruins_bat_attack
		elseif table_contains(thename) then --ͨ
			hand.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE, TUNING.BOOMERANG_DISTANCE + 1)
			hand.components.weapon.onattack = onattack
		end
	end
end

--ͻϮܻع
local function recoverweapon(inst, data)
	local item = data.item
	local thename = item.prefab
	if item.components.weapon  and (thename == "batbat" or thename == "ruins_bat" or table_contains(thename))then
		item.components.weapon.onattack = item.components.weapon.temp_attack
		item.components.weapon:SetRange(nil)
	end
end

local self_com = {}
--д¶ȸº
local function OnUpdate(self, dt, applyhealthdelta)
	
	if self.settemp then return end

	if applyhealthdelta == nil then
		applyhealthdelta = true
	end
	
	if (self.inst.components.health and self.inst.components.health.invincible == true) or self.inst.is_teleporting == true then
		return
	end

    local last = self.current

    local seasonmgr = GetSeasonManager()
	local ambient_delta = ((seasonmgr and seasonmgr:GetCurrentTemperature() or TUNING.STARTING_TEMP) - self.current) or 0

	ambient_delta = ambient_delta - self:GetMoisturePenalty()

	if seasonmgr and self.inst.components.inventory then
		for k,v in pairs (self.inst.components.inventory.equipslots) do
			if v.components.heater then
				local heat = v.components.heater:GetEquippedHeat()
				if heat ~= nil and heat > self.current then
					ambient_delta = ambient_delta + (heat - self.current)
				elseif heat ~= nil and heat < self.current then
					ambient_delta = ambient_delta - (self.current - heat)
				end
			end
		end
		for k,v in pairs(self.inst.components.inventory.itemslots) do
			if v.components.heater then
				local carrieddelta = v.components.heater:GetCarriedHeat()
				if carrieddelta ~= nil then
					ambient_delta = ambient_delta + carrieddelta
				end
			end
		end
		if self.inst.components.inventory.overflow and self.inst.components.inventory.overflow.components.container then
			for k,v in pairs(self.inst.components.inventory.overflow.components.container.slots) do
				if v.components.heater then
					local carrieddelta = v.components.heater:GetCarriedHeat()
					if carrieddelta ~= nil then
						ambient_delta = ambient_delta + carrieddelta
					end
				end
			end
		end
		-- Recently eaten temperatured food is inherently equipped heat/cold
		if self.inst.recent_temperatured_food and self.inst.recent_temperatured_food ~= 0 then
			ambient_delta = ambient_delta + self.inst.recent_temperatured_food
		end
	end

	-- If very hot (basically only when have overheating screen effect showing) and under shelter, cool slightly
    if self.current > TUNING.TREE_SHADE_COOLING_THRESHOLD and self.sheltered then
		ambient_delta = ambient_delta - (self.current - TUNING.TREE_SHADE_COOLER)
	end

	--now figure out the temperature where we are standing
	local x,y,z = self.inst.Transform:GetWorldPosition()
	
	local ZERO_DISTANCE = 10
	local ZERO_DISTSQ = ZERO_DISTANCE*ZERO_DISTANCE

	local ents = TheSim:FindEntities(x,y,z, ZERO_DISTANCE, {"HASHEATER"})
	local area_heat = 0
	local num_area_heat_sources = 0
    for k,v in pairs(ents) do 
		if v.components.heater and v ~= self.inst and not v:IsInLimbo() then
			local heat = v.components.heater:GetHeat(self.inst)
			local distsq = self.inst:GetDistanceSqToInst(v)

			-- This produces a gentle falloff from 1 to zero.
			local heatfactor = ((-1/ZERO_DISTSQ)*distsq) + 1
			local mm = GetWorld().components.moisturemanager
	        if mm and ((not mm:IsEntityDry(self.inst)) or (mm:IsWorldWet() and not GetPlayer().components.inventory:IsWaterproof())) then
	            heatfactor = heatfactor * TUNING.WET_HEAT_FACTOR_PENALTY
	        end

			if heat*heatfactor > self.current then
				if heat > 0 then
					area_heat = area_heat + (heat*heatfactor - self.current)
					num_area_heat_sources = num_area_heat_sources + 1
				end
			elseif heat*heatfactor < self.current then
				if heat < 0 then
					area_heat = area_heat - (self.current - heat*heatfactor)
					num_area_heat_sources = num_area_heat_sources + 1
				end
			end
		end
    end	
    if num_area_heat_sources > 0 then
    	ambient_delta = ambient_delta + (area_heat / num_area_heat_sources)
    end
	
	local winterInsulation, summerInsulation = self:GetInsulation()

	local delta = ambient_delta
	self.last_real_delta = delta
	local freezeTime = TUNING.SEG_TIME + winterInsulation
	local overheatTime = TUNING.SEG_TIME + summerInsulation 
	-- local freeze_or_overheat_time = TUNING.SEG_TIME + total_insulation

	if seasonmgr then
		if self:IsCooling() and self:IsCool() then
			if seasonmgr:GetCurrentTemperature() >= TUNING.STARTING_TEMP then --cooling down, obj is cold, world is hot
				self.rate = math.max(delta, -TUNING.WARM_DEGREES_PER_SEC)
			else --cooling down, obj is cold, world is cold
				self.rate = math.max(delta, -TUNING.SEG_TIME / freezeTime) 
			end
		elseif self:IsWarming() and self:IsCool() then 
			if seasonmgr:GetCurrentTemperature() >= TUNING.STARTING_TEMP then --warming up, obj is cold and world is hot
				self.rate = math.min(delta, TUNING.SEG_TIME / overheatTime)
			else --warming up, obj is cold and world is cold
				self.rate = math.min(delta, self.current <= 0 and TUNING.THAW_DEGREES_PER_SEC or TUNING.WARM_DEGREES_PER_SEC)
			end
		elseif self:IsCooling() and self:IsWarm() then
			if seasonmgr:GetCurrentTemperature() >= TUNING.STARTING_TEMP then --cooling down, obj is warm and world is hot
				self.rate = math.max(delta, self.current >= self.overheattemp and -TUNING.THAW_DEGREES_PER_SEC or -TUNING.WARM_DEGREES_PER_SEC)
			else --cooling down, obj is warm and world is cold
				self.rate = math.max(delta, -TUNING.SEG_TIME / freezeTime)
			end
		elseif self:IsWarming() and self:IsWarm() then
			if seasonmgr:GetCurrentTemperature() >= TUNING.STARTING_TEMP then --warming up, obj is warm, world is hot
				self.rate = math.min(delta, TUNING.SEG_TIME / overheatTime)
			else --warming up, obj is warm, world is cold
				self.rate = math.min(delta, TUNING.WARM_DEGREES_PER_SEC)
			end
		else
			self.rate = 0
		end
	end

	if self.inst.components.inventoryitem and 
		self.inst.components.inventoryitem.owner and 
		self.inst.components.inventoryitem.owner:HasTag("fridge") and not
		self.inst.components.inventoryitem.owner:HasTag("nocool") and --For icepack.
		self.current > 0 then -- Don't cool it below freezing
		self.rate = -TUNING.WARM_DEGREES_PER_SEC
		if self.inst.components.inventoryitem.owner:HasTag("lowcool") then
			self.rate = self.rate * .5
		end
	end
	
	self.rate = self.rate * 2 --speed * 2
    self.current = math.max( math.min( self.current + self.rate*dt, self.maxtemp), self.mintemp)
	
    if (self.current < 0) ~= (last < 0)  then
    	if self.current < 0 then
    		self.inst:PushEvent("startfreezing")
    	else
    		self.inst:PushEvent("stopfreezing")
    	end
    end

    if (self.current > self.overheattemp) ~= (last > self.overheattemp) then
    	if self.current > self.overheattemp then
    		self.inst:PushEvent("startoverheating")
    	else
    		self.inst:PushEvent("stopoverheating")
    	end
    end

	self.inst:PushEvent("temperaturedelta")
	
	if applyhealthdelta and self.current < 0 and self.inst.components.health then
		self.inst.components.health:DoDelta(-self.hurtrate*dt, true, "cold") 
	elseif applyhealthdelta and self.current > self.overheattemp and self.inst.components.health then
		self.inst.components.health:DoDelta(-self.hurtrate*dt, true, "hot") 
	end
	
end
--main--
local fn = function(inst)

	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wili.tex" )
	
	local healthnum = 70
	
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(120)
	inst.components.health:SetMaxHealth(healthnum)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)	
	
	inst.components.inventory:GuaranteeItems(start_inv)
	inst.components.combat.min_attack_period = 0.5
	
	self_com = inst.components.temperature
	inst.components.temperature.OnUpdate = OnUpdate
	inst.components.temperature.hurtrate = healthnum / TUNING.FREEZING_KILL_TIME
	
	-- Emit light at night
	inst.components.sanity.night_drain_mult = 0.5
	inst.components.sanity.neg_aura_mult = 0.7
	local light = inst.entity:AddLight()
    inst.Light:Enable(true)
	inst.Light:SetRadius(13)
    inst.Light:SetFalloff(0.75)
    inst.Light:SetIntensity(.6)
    inst.Light:SetColour(235/255,12/255,12/255)
	
	inst:ListenForEvent("onattackother", changedamage)
	inst:ListenForEvent("equip", changeweapon)
	inst:ListenForEvent("unequip", recoverweapon)
	
    return inst
	
end
	
	


-- strings! Any "WO D"

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.wili = " Ӱ   "
STRINGS.CHARACTER_NAMES.wili = "  "
STRINGS.CHARACTER_DESCRIPTIONS.wili = "*  ս \n* ҹ      Զ\n*    Ѫ"
STRINGS.CHARACTER_QUOTES.wili = "\" Ѱ   ɱ Ŀ  \""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.WILI = {}
STRINGS.CHARACTERS.WILI.ACTIONFAIL_GENERIC  = "Ŷ Ŷ        "
STRINGS.CHARACTERS.WILI.ANNOUNCE_ADVENTUREFAIL  = "    ʧ    "

STRINGS.MAXWELL_SANDBOXINTROS.ONE = "   С   "
STRINGS.MAXWELL_SANDBOXINTROS.TWO = "ϣ      ʱ    "

ANNOUNCE_BOOMERANG  = "     "
ANNOUNCE_CHARLIE  = "  Ҫ     "
ANNOUNCE_CHARLIE_ATTACK = " ô     "
ANNOUNCE_MOSQUITOS  = "   Σ   "

STRINGS.CHARACTERS.WILI.ANNOUNCE_COLD  = "      ʲ ô  "
ANNOUNCE_CRAFTING_FAIL  = "        "
STRINGS.CHARACTERS.WILI.ANNOUNCE_DUSK = "ҹ      "
STRINGS.CHARACTERS.WILI.ANNOUNCE_CRAFTING_FAIL  = "        "
STRINGS.CHARACTERS.WILI.ANNOUNCE_Hungry  = "    "
STRINGS.CHARACTERS.WILI.ANNOUNCE_HUNT_BEAST_NEARBY = "  Ŀ      "
STRINGS.CHARACTERS.WILI.ANNOUNCE_HUNT_LOST_TRAIL  = "     Ȼ     "
STRINGS.CHARACTERS.WILI.ANNOUNCE_INV_FULL  = "          "
STRINGS.CHARACTERS.WILI.ANNOUNCE_KNOCKEDOUT  = "  ͷ  "
STRINGS.CHARACTERS.WILI.ANNOUNCE_NODANGERSLEEP  = "Ŷ             "
STRINGS.CHARACTERS.WILI.ANNOUNCE_NOHUNGERSLEEP  = "   ˯  ֮ ǰ       "
STRINGS.CHARACTERS.WILI.ANNOUNCE_NODAYSLEEP  = "   ô ˯   "
STRINGS.CHARACTERS.WILI.ANNOUNCE_NO_TRAP  = "    "
STRINGS.CHARACTERS.WILI.ANNOUNCE_PECKED  = "ס   "
STRINGS.CHARACTERS.WILI.ANNOUNCE_QUAKE = "   λ  ʱ     "
STRINGS.CHARACTERS.WILI.ANNOUNCE_RESEARCH  = "    С    "
STRINGS.CHARACTERS.WILI.ANNOUNCE_THORNS  = "      "
STRINGS.CHARACTERS.WILI.ANNOUNCE_TORCH_OUT  = "Ŷ Ŷ   û   "
STRINGS.CHARACTERS.WILI.ANNOUNCE_TRAP_WENT_OFF  = "   "
STRINGS.CHARACTERS.WILI.ANNOUNCE_WORMHOLE  = "      "

STRINGS.CHARACTERS.WILI.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.WILI.ANNOUNCE_EAT.GENERIC  = "ζ      "
STRINGS.CHARACTERS.WILI.ANNOUNCE_EAT.PAINFULL = "    "
STRINGS.CHARACTERS.WILI.ANNOUNCE_EAT.SPOILED = " ʳ      "
STRINGS.CHARACTERS.WILI.ANNOUNCE_EAT.STALE  = "    ҭ    "


-- Battle
STRINGS.CHARACTERS.WILI.ANNOUNCE_HOUNDS  = "   Ⱥ  Ҫ   С    "
STRINGS.CHARACTERS.WILI.ANNOUNCE_DEERCLOPS  = " ϲ  ɱ      "

STRINGS.CHARACTERS.WILI.BATTLECRY = {}
STRINGS.CHARACTERS.WILI.BATTLECRY.GENERIC  = "ȥ    "
STRINGS.CHARACTERS.WILI.BATTLECRY.PIG = "  ô     "
STRINGS.CHARACTERS.WILI.BATTLECRY.PREY  = "       "
STRINGS.CHARACTERS.WILI.BATTLECRY.SPIDER  = "   ô        "
STRINGS.CHARACTERS.WILI.BATTLECRY.SPIDER_WARRIOR  = " ˵  ͦ    "
STRINGS.CHARACTERS.WILI.BATTLECRY.HOUND  = "  ׷    ׷  "
STRINGS.CHARACTERS.WILI.BATTLECRY.LEIF  = "   ȥ   "

STRINGS.CHARACTERS.WILI.COMBAT_QUIT = {}
STRINGS.CHARACTERS.WILI.COMBAT_QUIT.GENERIC  = "     һ   "
STRINGS.CHARACTERS.WILI.COMBAT_QUIT.PIG = "          "
STRINGS.CHARACTERS.WILI.COMBAT_QUIT.PREY  = "   ѧ ϰ     "
STRINGS.CHARACTERS.WILI.COMBAT_QUIT.SPIDER  = " ֪       "
STRINGS.CHARACTERS.WILI.COMBAT_QUIT.SPIDER_WARRIOR  = "   Ҳ        "

-- Description
STRINGS.CHARACTERS.WILI.DESCRIBE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.SLURPER  = "     Σ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.ORANGEAMULET  = "    Ҫ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.YELLOWSTAFF  = " ϲ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.YELLOWGEM  = "    ɫ  ʯ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.ORANGEGEM  = " ɫ   ϲ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.STAFFLIGHT  = "ħ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.RESEARCHLAB4  = "   ĩ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.ANCIENT_ALTAR  = "Ϊ ɶ Զ     ô    "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAVE_BANANA  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAVE_BANANA_COOKED  = "     ը  "
STRINGS.CHARACTERS.WILI.DESCRIBE.Cave_BANANA_TREE  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROCKY  = "   ʯ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.GENERIC  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.N  = " "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.S  = " "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.E  = " "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.W  = " "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.NE  = "  "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.SE  = "  "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.NW  = "  "
STRINGS.CHARACTERS.WILI.DESCRIBE.COMPASS.SW  = "  "

STRINGS.CHARACTERS.WILI.DESCRIBE.HOUNDSTOOTH  = "   ɱ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.ARMORSNURTLESHELL  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.BAT = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.BATBAT  = " Ѫ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.BATWING  = "    Щ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.BATWING_COOKED = "  ɱ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEDROLL_FURRY = "  ˯ һ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.BUNNYMAN = " ͦ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.FLOWER_CAVE  = "  Ҫ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FLOWER_CAVE_DOUBLE  = "  Ҫ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FLOWER_CAVE_TRIPLE  = "  Ҫ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.GUANO = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.LANTERN  = " Ҫ    ʲ ô  "
STRINGS.CHARACTERS.WILI.DESCRIBE.LIGHTBULB  = "  Ҫ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.MANRABBIT_TAIL  = "   ϲ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.MUSHTREE_TALL  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.MUSHTREE_MEDIUM  = "     Ģ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MUSHTREE_SMALL = " ô һ    ɶ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.RABBITHOUSE  = "        Ҳ ̫    "
STRINGS.CHARACTERS.WILI.DESCRIBE.SLURTLE = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.SLURTLE_SHELLPIECES  = "    װ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.SLURTLEHAT  = " ͷ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.SLURTLEHOLE  = "  ס   ţ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.SLURTLESLIME  = "   ȼ       Ը   һ   ը  "
STRINGS.CHARACTERS.WILI.DESCRIBE.SNURTLE = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER_HIDER  = "     ֩   "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER_SPITTER  = "  ˿    ֩  "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDERHOLE = "  ȫ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE  = " ʯ ͷ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE_FULL  = "ʯ ͷ "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE_LOW  = "ʯ ͷ "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE_MED  = "ʯ ͷ "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE_TALL  = "  һ     ʯ ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE_TALL_FULL  = "  һ     ʯ ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE_TALL_LOW  = "  һ     ʯ ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.STALAGMITE_TALL_MED  = "  һ     ʯ ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.POWCAKE  = "   ׼       "

STRINGS.CHARACTERS.WILI.DESCRIBE.CAVE_ENTRANCE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.CAVE_ENTRANCE.GENERIC  = "       ϲ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAVE_ENTRANCE.OPEN  = "  Ҫ  ȥ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.CAVE_EXIT  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MAXWELLPHONOGRAPH  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.BOOMERANG  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGGUARD  = "  Ϊ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.ABIGAIL  = "   ˵     "
STRINGS.CHARACTERS.WILI.DESCRIBE.ADVENTURE_PORTAL  = "  һ   Σ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.AMULET  = "Ҳ         "
STRINGS.CHARACTERS.WILI.DESCRIBE.ANIMAL_TRACK  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.ARMORGRASS  = " ª     "
STRINGS.CHARACTERS.WILI.DESCRIBE.ARMORMARBLE  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.ARMORWOOD  = "ľ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.ARMOR_SANITY = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.ASH = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.ASH.GENERIC  = " ʲ ô        "
STRINGS.CHARACTERS.WILI.DESCRIBE.ASH.REMAINS_EYE_BONE  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.ASH.REMAINS_THINGIE  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.AXE  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.BABYBEEFALO  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.BACKPACK  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.BACONEGGS = "           "
STRINGS.CHARACTERS.WILI.DESCRIBE.BANDAGE  = "  "
STRINGS.CHARACTERS.WILI.DESCRIBE.BASALT = "һ Щ           "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEARDHAIR = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEDROLL_STRAW  = "  С ˯ һ   "
-- paste here
STRINGS.CHARACTERS.WILI.DESCRIBE.BEE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.BEE.GENERIC  = "С        "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEE.HELD  = "       "

STRINGS.CHARACTERS.WILI.DESCRIBE.BEEBOX = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEBOX.FULLHONEY  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEBOX.GENERIC  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEBOX.NOHONEY  = " û     "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEBOX.SOMEHONEY  = " û    "

STRINGS.CHARACTERS.WILI.DESCRIBE.BEEFALO = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEFALO.FOLLOWER  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEFALO.GENERIC  = " ţ Ӧ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEFALO.NAKED  = "   ë    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEFALO.SLEEPING  = "      ë  "

STRINGS.CHARACTERS.WILI.DESCRIBE.BEEFALOHAT = "      Ҫ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEFALOWOOL  = "      һ Щ  ů     "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEHAT  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEHIVE  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.BEEMINE_MAXWELL  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.BERRIES  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.BERRIES_COOKED = "     "

STRINGS.CHARACTERS.WILI.DESCRIBE.BERRYBUSH = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.BERRYBUSH.BARREN = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BERRYBUSH.GENERIC  = "  "
STRINGS.CHARACTERS.WILI.DESCRIBE.BERRYBUSH.PICKED  = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.BIRDCAGE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.BIRDCAGE.GENERIC  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BIRDCAGE.OCCUPIED  = "С      "
STRINGS.CHARACTERS.WILI.DESCRIBE.BIRDCAGE.SLEEPING = "   ˯    "

STRINGS.CHARACTERS.WILI.DESCRIBE.BIRDTRAP  = " Ҫ ׽ ֻ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.BIRD_EGG = " С    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BIRD_EGG_COOKED  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BISHOP  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLOWDART_FIRE  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLOWDART_SLEEP = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUEAMULET  = "          "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUEGEM  = "  ʯ "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUEPRINT  = "   ѧ ϰ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUE_CAP  = " ֪   û    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUE_CAP_COOKED  = " ֪   û    "

STRINGS.CHARACTERS.WILI.DESCRIBE.BLUE_MUSHROOM = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUE_MUSHROOM.GENERIC  = "С Ģ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUE_MUSHROOM.INGROUND = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.BLUE_MUSHROOM.PICKED  = " ֪          "

STRINGS.CHARACTERS.WILI.DESCRIBE.BOARDS  = "ľ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BUGNET  = "С         "
STRINGS.CHARACTERS.WILI.DESCRIBE.BUSHHAT  = "  ʱ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.BUTTER  = "  "

STRINGS.CHARACTERS.WILI.DESCRIBE.BUTTERFLY = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.BUTTERFLY.GENERIC  = "С    "
STRINGS.CHARACTERS.WILI.DESCRIBE.BUTTERFLY.HELD  = "ץ     "

STRINGS.CHARACTERS.WILI.DESCRIBE.BUTTERFLYWINGS  = "Ư         "

STRINGS.CHARACTERS.WILI.DESCRIBE.CAMPFIRE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.CAMPFIRE.EMBERS  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAMPFIRE.GENERIC  = "       ů  "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAMPFIRE.HIGH  = "̫    "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAMPFIRE.LOW = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAMPFIRE.NORMAL  = " С     "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAMPFIRE.OUT  = "    "

STRINGS.CHARACTERS.WILI.DESCRIBE.CANE  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.CARROT  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.CARROT_COOKED  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.CARROT_PLANTED  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.CAVE_FERN  = " ֲ     װ  Ʒ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.CHARCOAL  = "̼ ľ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.CHESSJUNK1 = "    е  "
STRINGS.CHARACTERS.WILI.DESCRIBE.CHESSJUNK2 = "    е  "
STRINGS.CHARACTERS.WILI.DESCRIBE.CHESSJUNK3  = "    е  "
STRINGS.CHARACTERS.WILI.DESCRIBE.CHESTER  = "         "

STRINGS.CHARACTERS.WILI.DESCRIBE.CHESTER_EYEBONE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.CHESTER_EYEBONE.GENERIC  = "С        "
STRINGS.CHARACTERS.WILI.DESCRIBE.CHESTER_EYEBONE.WAITING = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.COOKEDMANDRAKE  = "            "
STRINGS.CHARACTERS.WILI.DESCRIBE.COOKEDMEAT  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.COOKEDMONSTERMEAT  = " ϣ     Ҫ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.COOKEDSMALLMEAT = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.COOKPOT = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.COOKPOT.COOKING_LONG = " Ҫ һ  ʱ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.COOKPOT.COOKING_SHORT  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.COOKPOT.DONE  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.COOKPOT.EMPTY  = "һ       "

STRINGS.CHARACTERS.WILI.DESCRIBE.CUTGRASS = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.CUTREEDS  = "« έ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.CUTSTONE  = "       "

STRINGS.CHARACTERS.WILI.DESCRIBE.CROW = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.CROW.GENERIC  = " ѻ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.CROW.HELD  = "  ϲ   ѻ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.CORN  = " Ȼ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.DEERCLOPS_EYEBALL  = "  ͦ           "

STRINGS.CHARACTERS.WILI.DESCRIBE.DEPLETED_GRASS = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.DEPLETED_GRASS.GENERIC  = "С   "

STRINGS.CHARACTERS.WILI.DESCRIBE.DEVTOOL = "    ζ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.DEVTOOL_NODEV  = "         Ц  "
STRINGS.CHARACTERS.WILI.DESCRIBE.DIRTPILE  = "ϣ       "

STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGROD = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGROD.COLD = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGROD.GENERIC  = "  ̽    "
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGROD.HOT  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGROD.WARM  = "  һ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGROD.WARMER  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGRODBASE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGRODBASE.GENERIC  = "̽     "
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGRODBASE.READY  = "ħ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGRODBASE.UNLOCKED  = "    "

STRINGS.CHARACTERS.WILI.DESCRIBE.DIVININGRODSTART  = "  ֪          "
STRINGS.CHARACTERS.WILI.DESCRIBE.DRAGONFRUIT  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.DRAGONFRUIT_COOKED  = "        ζ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.DRUMSTICK  = "           "
STRINGS.CHARACTERS.WILI.DESCRIBE.DRUMSTICK_COOKED  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.DDUG_BERRYBUSH  = " Ӧ      ȥ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.DDUG_GRASS  = " Ӧ      ȥ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.DDUG_MARSH_BUSH  = " Ӧ      ȥ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.DDUG_SAPLING = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.DURIAN  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.DURIAN_COOKED  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.EARMUFFSHAT  = "  С ñ  ̫ û    "
STRINGS.CHARACTERS.WILI.DESCRIBE.EGGPLANT  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.EGGPLANT_COOKED  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.EYEPLANT = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN.BURNING  = "ȼ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN.BURNT  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN.CHOPPED  = "          "
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN.GENERIC  = "   ÿ   Ҫ    "

STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN_SPARSE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN_SPARSE.BURNING  = "ɭ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN_SPARSE.BURNT  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN_SPARSE.CHOPPED = "          "
STRINGS.CHARACTERS.WILI.DESCRIBE.EVERGREEN_SPARSE.GENERIC  = "ë    "

STRINGS.CHARACTERS.WILI.DESCRIBE.FARMPLOT = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.FARMPLOT.GENERIC  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FARMPLOTGROWING  = "          "
STRINGS.CHARACTERS.WILI.DESCRIBE.FARMPLOT.NEEDSFERTILIZER  = "   ô     "

STRINGS.CHARACTERS.WILI.DESCRIBE.FEATHERHAT  = "     һ ֻ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.FEATHER_CROW  = " ѻ   ë  "
STRINGS.CHARACTERS.WILI.DESCRIBE.FEATHER_ROBIN  = "֪     ë  "
STRINGS.CHARACTERS.WILI.DESCRIBE.FEATHER_ROBIN_WINTER  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.FIREFLIES = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.GENERIC = " Ư   "
STRINGS.CHARACTERS.WILI.DESCRIBE.HELD  = "            "

STRINGS.CHARACTERS.WILI.DESCRIBE.FIREHOUND  = "С    "

STRINGS.CHARACTERS.WILI.DESCRIBE.FIREPIT = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.FIREPIT.EMBERS  = "Ҫ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FIREPIT.GENERIC  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FIREPIT.HIGH  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FIREPIT.LOW = " С  "
STRINGS.CHARACTERS.WILI.DESCRIBE.FIREPIT.NORMAL  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.FIREPIT.OUT  = "    ԭ ʼ     "

STRINGS.CHARACTERS.WILI.DESCRIBE.FIRESTAFF  = " ϲ   ʦ  װ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.FISH = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FISH_COOKED  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FLINT  = "          "
STRINGS.CHARACTERS.WILI.DESCRIBE.FLOWER  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FLOWERHAT  = " Щ С Ů   ֪     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FLOWER_EVIL  = "   Ҫ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.FOLIAGE  = "Ҷ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.FOOTBALLHAT  = "   ñ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.FROG = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.DEAD  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.SLEEPING  = "  ˯       "

STRINGS.CHARACTERS.WILI.DESCRIBE.FROGLEGS  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.FROGLEGS_COOKED = "ը       "
STRINGS.CHARACTERS.WILI.DESCRIBE.GEARS = "     һ Щ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.GHOST  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.GOLDENAXE  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.GOLDENPICKAXE  = "   ʯ ͷ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.GOLDENPITCHFORK  = " Ӧ   ֲ  ʵ    Ƥ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.GOLDENSHOVEL  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.GOLDNUGGET  = "          "

STRINGS.CHARACTERS.WILI.DESCRIBE.GRASS = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.GRASS.BARREN  = "С         "
STRINGS.CHARACTERS.WILI.DESCRIBE.GRASS.BURNING  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.GRASS.GENERIC  = "С       "
STRINGS.CHARACTERS.WILI.DESCRIBE.GRASS.PICKED  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.GREEN_CAP  = " Ӧ     ʳ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.GREEN_CAP_COOKED = "Ӧ      "

STRINGS.CHARACTERS.WILI.DESCRIBE.GREEN_MUSHROOM = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.GREEN_MUSHROOM.GENERIC  = "С Ģ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.GREEN_MUSHROOM.INGROUND = "ȥ ˯    "
STRINGS.CHARACTERS.WILI.DESCRIBE.GREEN_MUSHROOM.PICKED  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.GUNPOWDER  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.HAMBAT  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.HAMMER  = "    ѽ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.HEALINGSALVE  = "           "

STRINGS.CHARACTERS.WILI.DESCRIBE.HEATROCK = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.HEATROCK.COLD  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.HEATROCK.GENERIC  = "  ϲ    Բ ʯ ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.HEATROCK.HOT  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.HEATROCK.WARM  = "  һ    "

STRINGS.CHARACTERS.WILI.DESCRIBE.HOME = "  ˭    "
STRINGS.CHARACTERS.WILI.DESCRIBE.HOMESIGN  = "             ƭ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.HONEY = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.HONEYCOMB  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.HORN  = "С ţ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.HOUND  = " "
STRINGS.CHARACTERS.WILI.DESCRIBE.HOUNDBONE  = "  ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.HOUNDMOUND  = "С     "
STRINGS.CHARACTERS.WILI.DESCRIBE.ICEBOX  = "    ʳ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.ICEHOUND  = "         ʯ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.INSANITYROCK = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.INSANITYROCK.ACTIVE  = "˭       "
STRINGS.CHARACTERS.WILI.DESCRIBE.INSANITYROCK.INACTIVE  = "    ȥ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.KILLERBEE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.KILLERBEE.GENERIC  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.KILLERBEE.HELD  = "ɱ         "

STRINGS.CHARACTERS.WILI.DESCRIBE.KNIGHT  = " ª   ʿ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.KOALEFANT_SUMMER = "          "
STRINGS.CHARACTERS.WILI.DESCRIBE.KOALEFANT_WINTER  = "            "
STRINGS.CHARACTERS.WILI.DESCRIBE.KRAMPUS  = " ͵       "
STRINGS.CHARACTERS.WILI.DESCRIBE.KRAMPUS_SACK  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.LEIF = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.LEIF_SPARSE  = "   ľ ͷ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.LIGHTNING_ROD = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.LIGHTNING_ROD.CHARGED = "     ǿ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.LIGHTNING_ROD.GENERIC  = " ʱ     ͦ  Ҫ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.LITTLE_WALRUS  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.LIVINGLOG  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.LOCKEDWES  = "  ˹ Τ   ȥ     "

STRINGS.CHARACTERS.WILI.DESCRIBE.LOG = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.LOG.BURNING = " ϧ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.LOG.GENERIC  = "   ľ ͷ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.LUREPLANT = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.LUREPLANTBULB  = "ʳ      "

STRINGS.CHARACTERS.WILI.DESCRIBE.MANDRAKE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.MANDRAKE.DEAD  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MANDRAKE.GENERIC  = "      ֲ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.MANDRAKE.PICKED  = "     "

STRINGS.CHARACTERS.WILI.DESCRIBE.MANDRAKESOUP  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.MANDRAKE_COOKED  = "     ʲ ô   "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARBLE  = "    һ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARBLEPILLAR  = "   ʯ ͷ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARBLETREE  = "   ˭    "

STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_BUSH = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_BUSH.BURNING  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_BUSH.GENERIC  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_BUSH.PICKED  = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_PLANT  = "       "

STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_TREE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_TREE.BURNING = "ɭ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_TREE.BURNT  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_TREE.CHOPPED  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.MARSH_TREE.GENERIC  = "С   "

STRINGS.CHARACTERS.WILI.DESCRIBE.MAXWELL  = "     Ϊ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.MAXWELLHEAD  = "   ͷ ­    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MAXWELLLIGHT  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.MAXWELLLOCK  = "  һ  Կ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MAXWELLTHRONE  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.MEAT  = "    "

STRINGS.CHARACTERS.WILI.DESCRIBE.MEATRACK = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.MEATRACK.DONE  = "    ׼     "
STRINGS.CHARACTERS.WILI.DESCRIBE.MEATRACK.DRYING  = "  Ҫ һ  ʱ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.MEATRACK.GENERIC  = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.MEAT_DRIED  = "    Ӫ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MERM = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.MERMHEAD  = "  ˭  ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.MERMHOUSE  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.MINERHAT  = "    û ʲ ô  "
STRINGS.CHARACTERS.WILI.DESCRIBE.MONKEY  = "  Զ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.MONKEYBARREL  = "  Ͱ Ҳ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.MONSTERLASAGNA  = "   Ҫ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.MONSTERMEAT  = "          "
STRINGS.CHARACTERS.WILI.DESCRIBE.MONSTERMEAT_DRIED  = "Ҫ       "

STRINGS.CHARACTERS.WILI.DESCRIBE.MOSQUITO = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.MOSQUITO.GENERIC  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.MOSQUITO.HELD  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.MOUND = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.MOUND.DUG = "  û ʲ ô     "
STRINGS.CHARACTERS.WILI.DESCRIBE.MOUND.GENERIC  = "  һ      "

STRINGS.CHARACTERS.WILI.DESCRIBE.NIGHTLIGHT  = " Ҫ    ʲ ô   "
STRINGS.CHARACTERS.WILI.DESCRIBE.NIGHTMAREFUEL  = "ج  ȼ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.NIGHTSWORD = "ȼ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.NITRE  = "      Ҫ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.ONEMANBAND  = "     һ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.PANDORASCHEST  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.PANFLUTE  = "  ˯      "
STRINGS.CHARACTERS.WILI.DESCRIBE.PAPYRUS  = " ͨ  ֽ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.PENGUIN  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.PERD  = "           "
STRINGS.CHARACTERS.WILI.DESCRIBE.PETALS  = "    ժ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.PETALS_EVIL  = "ج     "
STRINGS.CHARACTERS.WILI.DESCRIBE.PICKAXE  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGGYBACK  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGHEAD  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.PIGHOUSE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGHOUSE.FULL  = "   ͷ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGHOUSE.GENERIC = "      ô ˯    "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGHOUSE.LIGHTSOUT  = "Ϊ ɶ Ҫ    "

STRINGS.CHARACTERS.WILI.DESCRIBE.PIGKING = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.PIGMAN = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGMAN.DEAD = "Ը       "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGMAN.FOLLOWER  = "  Ӧ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGMAN.GENERIC  = "  Զ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGMAN.GUARD  = "    ʲ ô     "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGMAN.WEREPIG = " ͷ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.PIGSKIN = " ʵ    Ƥ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGTENT  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.PIGTORCH  = "С     "

STRINGS.CHARACTERS.WILI.DESCRIBE.PINECONE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.PINECONE.GENERIC  = "     Ӳ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.PINECONE.PLANTED = "   ʱ          "

STRINGS.CHARACTERS.WILI.DESCRIBE.PITCHFORK  = "       ֲ  Ƥ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.PLANTMEAT  = "  ֲ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.PLANTMEAT_COOKED  = "         "

STRINGS.CHARACTERS.WILI.DESCRIBE.PLANT_NORMAL = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.PLANT_NORMAL.GENERIC  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.PLANT_NORMAL.GROWING  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.PLANT_NORMAL.READY = "          "

STRINGS.CHARACTERS.WILI.DESCRIBE.POMEGRANATE  = "   ˮ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.POMEGRANATE_COOKED  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.POND  = " С     "
STRINGS.CHARACTERS.WILI.DESCRIBE.POOP  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.PUMPKIN  = "ʥ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.PUMPKIN_COOKED = " Ӧ        "
STRINGS.CHARACTERS.WILI.DESCRIBE.PUMPKIN_LANTERN  = " Ҫ    ʲ ô  "
STRINGS.CHARACTERS.WILI.DESCRIBE.PURPLEAMULET = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.PURPLEGEM  = "    ʯ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.RABBIT = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.RABBIT.GENERIC  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.RABBIT.HELD  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.RABBITHOLE  = "С        "
STRINGS.CHARACTERS.WILI.DESCRIBE.RAINOMETER  = "  Ԥ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.RAZOR  = "   ţ  ë  "
STRINGS.CHARACTERS.WILI.DESCRIBE.REDGEM  = "  ʯ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.RED_CAP  = "    ñ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.RED_CAP_COOKED = "    Ģ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.RED_MUSHROOM = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.RED_MUSHROOM.GENERIC  = "һ  Ģ    ֪       "
STRINGS.CHARACTERS.WILI.DESCRIBE.RED_MUSHROOM.INGROUND  = " ˯  ȥ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.RED_MUSHROOM.PICKED  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.REEDS = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.REEDS.BURNING  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.REEDS.GENERIC  = "       ֽ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.REEDS.PICKED  = "  û ʲ ô      "

STRINGS.CHARACTERS.WILI.DESCRIBE.RESEARCHLAB  = "     ѧ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.RESEARCHLAB2 = "               "
STRINGS.CHARACTERS.WILI.DESCRIBE.RESEARCHLAB3 = "  ֱ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.RESURRECTIONSTATUE  = "    ħ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.RESURRECTIONSTONE  = "           "

STRINGS.CHARACTERS.WILI.DESCRIBE.ROBIN = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.ROBIN.GENERIC  = "ɱ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROBIN.HELD = " Ҫ ׽    "

STRINGS.CHARACTERS.WILI.DESCRIBE.ROBIN_WINTER = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.ROBIN_WINTER.GENERIC  = "    С  "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROBIN_WINTER.HELD  = " Ҫ ׽    "

STRINGS.CHARACTERS.WILI.DESCRIBE.ROCK_LIGHT = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.ROCK_LIGHT.GENERIC  = " ɽ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROCK_LIGHT.OUT  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROCK_LIGHT.LOW = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROCK_LIGHT.NORMAL  = "        "

STRINGS.CHARACTERS.WILI.DESCRIBE.ROBOT_PUPPET  = "   ס   "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROCK = " û   ʯ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROCKS  = "  ʯ ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROOK  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROPE  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.ROTTENEGG  = "       ҩ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.SANITYROCK = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.SANITYROCK.ACTIVE  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.SANITYROCK.INACTIVE  = "  Ϣ ȥ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.SAPLING = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.SAPLING.BURNING  = "û ʲ ô      "
STRINGS.CHARACTERS.WILI.DESCRIBE.SAPLING.GENERIC  = "С    "
STRINGS.CHARACTERS.WILI.DESCRIBE.SAPLING.PICKED  = " ֦          "

STRINGS.CHARACTERS.WILI.DESCRIBE.SEEDS  = "  Ҫ һ  ũ    ֲ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.SEEDS_COOKED = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.SEWING_KIT  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.SHOVEL  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.SILK  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.SKELETON  = "ǰ    Ϣ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.SKULLCHEST  = "     "

STRINGS.CHARACTERS.WILI.DESCRIBE.SMALLBIRD = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.SMALLBIRD.GENERIC  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.SMALLBIRD.HUNGRY  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.SMALLBIRD.STARVING = "  Ҫ     "

STRINGS.CHARACTERS.WILI.DESCRIBE.SMALLMEAT  = "  Ӧ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.SMALLMEAT_DRIED  = "    Ӫ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPEAR  = "       "

STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER.DEAD  = "С ֩      "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER.GENERIC  = "С ֩   "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER.SLEEPING  = "͵ ͵        "

STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDERDEN  = "һ  ֩    Ѩ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDEREGGSACK  = " Ҫ     һ     λ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDERGLAND  = " Ӧ        ʱ  ʹ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDERQUEEN  = "֩  Ů          "

STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER_WARRIOR = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER_WARRIOR.DEAD  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER_WARRIOR.GENERIC  = "С ֩      "
STRINGS.CHARACTERS.WILI.DESCRIBE.SPIDER_WARRIOR.SLEEPING = "Ӧ     ɱ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.SPOILED_FOOD  = "   ʳ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.STATUEHARP  = "Ӧ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.STATUEMAXWELL  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.STINGER  = "   С    "
STRINGS.CHARACTERS.WILI.DESCRIBE.STRAWHAT  = " ª   ñ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.STUFFEDEGGPLANT  = "   һ Щ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.SUNKBOAT  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.TAFFY  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRD  = "           "
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDEGG = "    С    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDEGG_COOKED  = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDEGG_CRACKED = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDEGG_CRACKED.COLD  = "  Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDEGG_CRACKED.GENERIC  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDEGG_CRACKED.HOT  = "  Ҫ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDEGG_CRACKED.LONG = "      "

STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDNEST = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDNEST.GENERIC  = " С    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TALLBIRDNEST.PICKED  = "   "

STRINGS.CHARACTERS.WILI.DESCRIBE.TEENBIRD = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.TEENBIRD.GENERIC  = "     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TEENBIRD.HUNGRY  = "    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TEENBIRD.STARVING  = "  Σ   "

STRINGS.CHARACTERS.WILI.DESCRIBE.TELEBASE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEBASE.SVALID  = "׼     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEBASE.SGEMS  = " Ҫ     ʯ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.GEMSOCKET = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.GEMSOCKET.VALID  = "  ׼     "
STRINGS.CHARACTERS.WILI.DESCRIBE.GEMSOCKET.GEMS  = " Ҫ һ   ʯ  "

STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_BASE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_BASE.ACTIVE  = "         "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_BASE.GENERIC  = "ȥ   һ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_BASE.LOCKED = "ȱ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_BASE.PARTIAL  = "  һ Щ    "

STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_BOX  = "һ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_CRANK  = "һ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_POTATO  = "һ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELEPORTATO_RING = "һ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TELESTAFF  = "ħ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TENT  = "    ˯ һ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.TENTACLE  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.TENTACLESPIKE  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.TENTACLESPOTS = " ʵ  Ƥ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.TENTACLE_PILLAR = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.TENTACLE_PILLAR_ARM = "  һ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.TENTACLE_GARDEN = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.TOPHAT = "   û ʲ ô   "
STRINGS.CHARACTERS.WILI.DESCRIBE.TORCH  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRAP = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRAP_TEETH = "   Զ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRAP_TEETH_MAXWELL  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.TREASURECHEST  = "   "
STRINGS.CHARACTERS.WILI.DESCRIBE.TREASURECHEST_TRAP  = "Ŷ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_1 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_10 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_11 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_12  = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_2  = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_3 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_4 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_5 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_6 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_7 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_8 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRINKET_9 = " Ӧ      Щ    "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRUNKVEST_SUMMER  = "     װ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRUNKVEST_WINTER  = " ů     "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRUNK_COOKED  = "  ζ  ʳ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRUNK_SUMMER  = "           "
STRINGS.CHARACTERS.WILI.DESCRIBE.TRUNK_WINTER  = "        "
STRINGS.CHARACTERS.WILI.DESCRIBE.TWIGS  = " Щ  ֦     "
STRINGS.CHARACTERS.WILI.DESCRIBE.UMBRELLA  = "  Ҫ  ɡ   ŷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.UNIMPLEMENTED = "   û    С  һ      "
STRINGS.CHARACTERS.WILI.DESCRIBE.WASPHIVE  = "       ô      "
STRINGS.CHARACTERS.WILI.DESCRIBE.WETGOOP  = "            "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_STONE  = "   ǽ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_STONE_ITEM  = "ʯ ͷ   ǽ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_RUINS  = "  Ӳ  ǽ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_RUINS_ITEM  = " Ӳ    ʯ ͷ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_HAY  = " ǽ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_HAY_ITEM  = "    һ  ǽ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_WOOD  = "ľ ͷ       "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALL_WOOD_ITEM  = "    һ     ǽ  "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALRUS  = "       "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALRUS_TUSK  = "      "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALRUSHAT  = "  ñ        ů  "

STRINGS.CHARACTERS.WILI.DESCRIBE.WALRUS_CAMP = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.WALRUS_CAMP.EMPTY  = "   ֪  ȥ     "
STRINGS.CHARACTERS.WILI.DESCRIBE.WALRUS_CAMP.GENERIC = " Ư      "

STRINGS.CHARACTERS.WILI.DESCRIBE.WASPHIVE  = " Щ     ô   "
STRINGS.CHARACTERS.WILI.DESCRIBE.WINTERHAT  = "     ñ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.WINTEROMETER  = "       "

STRINGS.CHARACTERS.WILI.DESCRIBE.WORMHOLE = {}
STRINGS.CHARACTERS.WILI.DESCRIBE.WORMHOLE.GENERIC = "    ȥ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.WORMHOLE.OPEN  = "Ҫ  Ҫ ȥ   "
STRINGS.CHARACTERS.WILI.DESCRIBE.WORMHOLE_LIMITED  = "ȥ        "

--endpaste



STRINGS.CHARACTERS.WILI.DESCRIBE_GENERIC  = "  Ҫ ɱ  ʲ ô  "
STRINGS.CHARACTERS.WILI.DESCRIBE_TOODARK  = " ô     "








return MakePlayerCharacter("wili", prefabs, assets, fn)
